/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.login;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.engine.Engine;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestContextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LoginServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession(true);
        if (request.getUserPrincipal() != null) {
            String destination = (String)session.getAttribute("org.apache.jetspeed.login.destination");
            if (destination == null) {
                destination = request.getContextPath() + "/";
            }
            response.sendRedirect(response.encodeURL(destination));
        }
        if (Jetspeed.getEngine() != null) {
            request.setAttribute("pipeline", (Object)"login-pipeline");
            Engine engine = Jetspeed.getEngine();
            RequestContextComponent contextComponent = null;
            RequestContext context = null;
            try {
                String jetuiMode = Jetspeed.getConfiguration().getString("jetui.customization.method", "server");
                boolean redirectHomeSpace = Jetspeed.getConfiguration().getBoolean("jetui.redirect.home.space", true);
                if (redirectHomeSpace && jetuiMode.equals("ajax")) {
                    String username;
                    String destination = (String)session.getAttribute("org.apache.jetspeed.login.destination");
                    if (destination == null) {
                        destination = "/";
                    }
                    if ((username = (String)session.getAttribute("org.apache.jetspeed.login.username")) != null) {
                        if (!destination.endsWith("/")) {
                            destination = destination + "/";
                        }
                        destination = destination + "_user/" + username;
                        session.setAttribute("org.apache.jetspeed.login.destination", (Object)destination);
                    }
                }
                contextComponent = (RequestContextComponent)Jetspeed.getComponentManager().getComponent(RequestContextComponent.class);
                context = contextComponent.create(request, response, this.getServletConfig());
                engine.service(context);
            }
            catch (JetspeedException e) {
                log.warn("Jetspeed engine does not work properly.", (Throwable)e);
                response.sendRedirect(response.encodeURL(request.getContextPath() + "/"));
            }
            finally {
                if (contextComponent != null) {
                    contextComponent.setRequestContext(null);
                }
            }
        } else {
            response.sendRedirect(response.encodeURL(request.getContextPath() + "/"));
        }
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }
}

