/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.login.filter;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalAuthenticationConfiguration;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.audit.AuditActivity;
import org.apache.jetspeed.cache.UserContentCacheManager;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.container.session.PortalSessionValidationFilter;
import org.apache.jetspeed.login.LoginConstants;
import org.apache.jetspeed.login.filter.PortalRequestWrapper;
import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.AuthenticatedUserImpl;
import org.apache.jetspeed.security.AuthenticationProvider;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;

public class PortalFilter
implements Filter {
    protected String guest = "guest";

    public void init(FilterConfig filterConfig) throws ServletException {
        PortalConfiguration config = Jetspeed.getConfiguration();
        if (config != null) {
            this.guest = config.getString("default.user.principal");
        }
    }

    public void doFilter(ServletRequest sRequest, ServletResponse sResponse, FilterChain filterChain) throws IOException, ServletException {
        if (sRequest instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)sRequest;
            String username = request.getParameter("org.apache.jetspeed.login.username");
            String password = request.getParameter("org.apache.jetspeed.login.password");
            HttpSession httpSession = PortalSessionValidationFilter.getValidSession(request);
            if (username != null) {
                ComponentManager cm = Jetspeed.getComponentManager();
                UserManager userManager = (UserManager)cm.getComponent((Object)"org.apache.jetspeed.security.UserManager");
                AuditActivity audit = (AuditActivity)cm.getComponent((Object)"org.apache.jetspeed.audit.AuditActivity");
                AuthenticationProvider authProvider = (AuthenticationProvider)cm.getComponent((Object)"org.apache.jetspeed.security.AuthenticationProvider");
                AuthenticatedUser authUser = null;
                try {
                    authUser = authProvider.authenticate(username, password);
                }
                catch (SecurityException e) {
                    audit.logUserActivity(username, request.getRemoteAddr(), "login-failure", "PortalFilter");
                    request.getSession().setAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_INVALID_PASSWORD);
                }
                if (authUser != null) {
                    Subject subject;
                    audit.logUserActivity(username, request.getRemoteAddr(), "login-success", "PortalFilter");
                    PortalAuthenticationConfiguration authenticationConfiguration = (PortalAuthenticationConfiguration)cm.getComponent((Object)"org.apache.jetspeed.administration.PortalAuthenticationConfiguration");
                    if (authenticationConfiguration.isCreateNewSessionOnLogin() && httpSession != null && !httpSession.isNew()) {
                        request.getSession().invalidate();
                    } else {
                        UserContentCacheManager userContentCacheManager = (UserContentCacheManager)cm.getComponent((Object)"userContentCacheManager");
                        userContentCacheManager.evictUserContentCache(username, request.getSession().getId());
                    }
                    if (authUser.getUser() == null) {
                        try {
                            User user = userManager.getUser(username);
                            if (user != null) {
                                authUser = new AuthenticatedUserImpl(user, authUser.getPublicCredentials(), authUser.getPrivateCredentials());
                            }
                        }
                        catch (SecurityException sex) {
                            throw new ServletException((Throwable)sex);
                        }
                    }
                    try {
                        subject = userManager.getSubject(authUser);
                    }
                    catch (SecurityException e) {
                        throw new ServletException((Throwable)e);
                    }
                    sRequest = this.wrapperRequest(request, subject, (Principal)authUser.getUser());
                    request.getSession().removeAttribute("org.apache.jetspeed.login.errorcode");
                    HttpSession session = request.getSession(true);
                    session.setAttribute("org.apache.jetspeed.security.subject", (Object)subject);
                } else {
                    audit.logUserActivity(username, request.getRemoteAddr(), "login-failure", "PortalFilter");
                    request.getSession().setAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_INVALID_PASSWORD);
                }
            } else {
                Principal principal;
                Subject subject = (Subject)request.getSession().getAttribute("org.apache.jetspeed.security.subject");
                if (!(subject == null || (principal = SubjectHelper.getPrincipal((Subject)subject, User.class)) != null && principal.getName().equals(this.guest))) {
                    sRequest = this.wrapperRequest(request, subject, principal);
                }
            }
            sRequest.setAttribute("org.apache.jetspeed.login.filter.PortalFilter", (Object)"true");
        }
        if (filterChain != null) {
            filterChain.doFilter(sRequest, sResponse);
        }
    }

    private ServletRequest wrapperRequest(HttpServletRequest request, Subject subject, Principal principal) {
        PortalRequestWrapper wrapper = new PortalRequestWrapper(request, subject, principal);
        return wrapper;
    }

    public void destroy() {
    }
}

