/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.login.filter;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.jetspeed.container.invoker.ContainerRequiredRequestResponseWrapper;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.SubjectHelper;

public class PortalRequestWrapper
extends HttpServletRequestWrapper
implements ContainerRequiredRequestResponseWrapper {
    private Principal userPrincipal = null;
    private Subject subject;

    public PortalRequestWrapper(HttpServletRequest request, Subject subject, Principal userPrincipal) {
        super(request);
        this.subject = subject;
        this.userPrincipal = userPrincipal;
    }

    public boolean isUserInRole(String roleName) {
        if (this.subject == null) {
            return false;
        }
        return SubjectHelper.getPrincipal((Subject)this.subject, Role.class, (String)roleName) != null;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }
}

