/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.login.impl;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.LoginViewValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginJSPViewValve
extends AbstractValve
implements LoginViewValve {
    private static final Logger log = LoggerFactory.getLogger(LoginJSPViewValve.class);
    private static final String DEFAULT_TEMPLATE_PATH = "/WEB-INF/templates/login";
    private String templatePath;

    public LoginJSPViewValve() {
        this.templatePath = DEFAULT_TEMPLATE_PATH;
    }

    public LoginJSPViewValve(String templatePath) {
        this.templatePath = templatePath;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        String loginTemplateFile = this.templatePath + "/" + request.getMediaType() + "/login.jsp";
        try {
            RequestDispatcher rd = request.getRequest().getRequestDispatcher(loginTemplateFile);
            rd.include((ServletRequest)request.getRequest(), (ServletResponse)request.getResponse());
        }
        catch (ServletException e) {
            log.warn("The included login template file threw the exception.", (Throwable)e);
            throw new PipelineException("The included login template file threw the exception.", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("I/O error occurred on the included login template file.", (Throwable)e);
            throw new PipelineException("I/O error occurred on the included login template file.", (Throwable)e);
        }
        context.invokeNext(request);
    }

    public String toString() {
        return "LoginViewValve";
    }
}

