/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.manager;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.deployment.DeploymentManager;
import org.apache.jetspeed.deployment.DeploymentStatus;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManager;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManagerResult;

public class ManagerServlet
extends HttpServlet {
    private static int OK = 0;
    private static int ERROR_NO_DATA = 1;
    private static int ERROR_UNKNOWN_COMMAND = 2;
    private static int ERROR_UNKNOWN_PA = 3;
    private static int ERROR_INVALID = 4;
    private static int ERROR_UNSUPPORTED = 5;
    private static int ERROR_UNAVAILABLE = 6;
    private static int ERROR_SERVER = 7;
    private static int ERROR_UNEXPECTED = 8;
    private static int ERROR_IGNORED = 9;
    private ApplicationServerManager asm;
    private PortletRegistry registry;
    private PortletFactory portletFactory;
    private DeploymentManager dm;

    public void init() throws ServletException {
        super.init();
        this.asm = (ApplicationServerManager)Jetspeed.getComponentManager().getComponent(ApplicationServerManager.class);
        this.registry = (PortletRegistry)Jetspeed.getComponentManager().getComponent(PortletRegistry.class);
        this.portletFactory = (PortletFactory)Jetspeed.getComponentManager().getComponent((Object)"portletFactory");
        this.dm = (DeploymentManager)Jetspeed.getComponentManager().getComponent((Object)"deploymentManager");
    }

    public void destroy() {
        super.destroy();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response, true);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response, boolean posted) throws ServletException, IOException {
        response.setContentType("text/plain; charset=utf-8");
        CharArrayWriter buffer = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buffer);
        String command = request.getPathInfo();
        int result = OK;
        if (command == null) {
            result = OK;
        } else if (command.equals("/list")) {
            result = this.list(writer);
        } else if (command.equals("/start")) {
            result = this.start(writer, request.getParameter("pa"));
        } else if (command.equals("/stop")) {
            result = this.stop(writer, request.getParameter("pa"));
        } else if (command.equals("/undeploy")) {
            result = this.undeploy(writer, request.getParameter("pa"));
        } else if (command.equals("/unregister")) {
            result = this.unregister(writer, request.getParameter("pa"));
        } else if (command.equals("/deploy")) {
            if (posted) {
                result = this.deploy(writer, request);
            } else {
                writer.println("Error: /deploy is only available through POST");
                result = ERROR_INVALID;
            }
        } else {
            writer.println("Error: Unknown command " + command);
            result = ERROR_UNKNOWN_COMMAND;
        }
        writer.flush();
        writer.close();
        writer = response.getWriter();
        if (result == OK) {
            writer.println("OK");
        } else {
            writer.println("FAIL - CODE: " + result);
        }
        writer.print(buffer.toString());
        writer.flush();
        writer.close();
    }

    protected int list(PrintWriter writer) {
        writer.println("Listed Portlet Applications");
        for (PortletApplication pa : this.registry.getPortletApplications()) {
            writer.println(pa.getName() + ":" + pa.getContextPath() + ":" + (this.portletFactory.isPortletApplicationRegistered(pa) ? "ACTIVE" : "INACTIVE"));
        }
        return OK;
    }

    protected int start(PrintWriter writer, String paName) {
        PortletApplication pa = null;
        if (paName != null) {
            pa = this.registry.getPortletApplication(paName);
        }
        if (pa == null) {
            writer.println("Error: Unknown Portlet Application " + paName);
            return ERROR_UNKNOWN_PA;
        }
        if (this.portletFactory.isPortletApplicationRegistered(pa)) {
            writer.println("Warning: Portlet Application " + paName + " already started");
            return OK;
        }
        if (pa.getApplicationType() == 1) {
            writer.println("Error: Starting LOCAL Portlet Application " + paName + " not supported");
            return ERROR_UNSUPPORTED;
        }
        if (!this.asm.isConnected()) {
            writer.println("Error: Not connected to the server");
            return ERROR_UNAVAILABLE;
        }
        try {
            ApplicationServerManagerResult result = this.asm.start(pa.getContextPath());
            if (result.isOk()) {
                writer.println("Portlet Application " + paName + " started");
                writer.println(result.getResponse());
                return OK;
            }
            writer.println("Error: Portlet Application " + paName + " could not be started");
            writer.println(result.getResponse());
            return ERROR_SERVER;
        }
        catch (Exception e) {
            writer.println("Error: Failed to start Portlet Application " + paName + ": " + e.getMessage());
            e.printStackTrace(writer);
            return ERROR_UNEXPECTED;
        }
    }

    protected int stop(PrintWriter writer, String paName) {
        PortletApplication pa = null;
        if (paName != null) {
            pa = this.registry.getPortletApplication(paName);
        }
        if (pa == null) {
            writer.println("Error: Unknown Portlet Application " + paName);
            return ERROR_UNKNOWN_PA;
        }
        if (!this.portletFactory.isPortletApplicationRegistered(pa)) {
            writer.println("Portlet Application " + paName + " already stopped");
            return OK;
        }
        if (pa.getApplicationType() == 1) {
            writer.println("Error: Stopping LOCAL Portlet Application " + paName + " not supported");
            return ERROR_UNSUPPORTED;
        }
        if (!this.asm.isConnected()) {
            writer.println("Error: Not connected to the server");
            return ERROR_UNAVAILABLE;
        }
        try {
            ApplicationServerManagerResult result = this.asm.stop(pa.getContextPath());
            if (result.isOk()) {
                writer.println("Portlet Application " + paName + " stopped");
                writer.println(result.getResponse());
                return OK;
            }
            writer.println("Error: Portlet Application " + paName + " could not be stopped");
            writer.println(result.getResponse());
            return ERROR_SERVER;
        }
        catch (Exception e) {
            writer.println("Error: Failed to stop Portlet Application " + paName + ": " + e.getMessage());
            e.printStackTrace(writer);
            return ERROR_UNEXPECTED;
        }
    }

    protected int undeploy(PrintWriter writer, String paName) {
        int stopResult = this.stop(writer, paName);
        if (stopResult != OK) {
            return stopResult;
        }
        if (!this.asm.isConnected()) {
            writer.println("Error: Not connected to the server");
            return ERROR_UNAVAILABLE;
        }
        PortletApplication pa = this.registry.getPortletApplication(paName);
        try {
            ApplicationServerManagerResult result = this.asm.undeploy(pa.getContextPath());
            if (result.isOk()) {
                writer.println("Portlet Application " + paName + " undeployed");
                writer.println(result.getResponse());
                return OK;
            }
            writer.println("Error: Portlet Application " + paName + " could not be undeployed");
            writer.println(result.getResponse());
            return ERROR_SERVER;
        }
        catch (Exception e) {
            writer.println("Error: Failed to undeploy Portlet Application " + paName + ": " + e.getMessage());
            e.printStackTrace(writer);
            return ERROR_UNEXPECTED;
        }
    }

    protected int unregister(PrintWriter writer, String paName) {
        int result = this.stop(writer, paName);
        if (result != OK) {
            return result;
        }
        PortletApplication pa = this.registry.getPortletApplication(paName);
        try {
            this.registry.removeApplication(pa);
            writer.println("Portlet Application " + paName + " unregistered");
            return OK;
        }
        catch (RegistryException e) {
            writer.println("Error: Failed to unregister Portlet Application " + paName + ": " + e.getMessage());
            e.printStackTrace(writer);
            return ERROR_UNEXPECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int deploy(PrintWriter writer, HttpServletRequest request) {
        if (!FileUpload.isMultipartContent((HttpServletRequest)request)) {
            writer.println("Error: No file multipart content provided");
            return ERROR_NO_DATA;
        }
        File tempDir = null;
        File tempFile = null;
        try {
            block18: {
                try {
                    DiskFileUpload upload = new DiskFileUpload();
                    tempDir = File.createTempFile("upload", null);
                    tempDir.deleteOnExit();
                    tempDir.delete();
                    tempDir.mkdirs();
                    tempDir.deleteOnExit();
                    List items = upload.parseRequest(request, 0, -1L, tempDir.getAbsolutePath());
                    for (FileItem item : items) {
                        String fileName;
                        block17: {
                            DeploymentStatus status;
                            block16: {
                                int n;
                                if (item.isFormField()) continue;
                                fileName = item.getName();
                                tempFile = new File(tempDir, fileName);
                                tempFile.deleteOnExit();
                                item.write(tempFile);
                                try {
                                    status = this.dm.deploy(tempFile);
                                    if (status.getStatus() != 1) break block16;
                                    writer.println("Deployed " + fileName);
                                    n = OK;
                                }
                                catch (Throwable e) {
                                    writer.println("Error: Failed to deploy file " + fileName + ": " + e.getMessage());
                                    e.printStackTrace(writer);
                                    int n2 = ERROR_UNEXPECTED;
                                    Object var13_21 = null;
                                    if (tempFile != null) {
                                        tempFile.delete();
                                    }
                                    if (tempDir == null) return n2;
                                    tempDir.delete();
                                    return n2;
                                }
                                Object var13_18 = null;
                                if (tempFile != null) {
                                    tempFile.delete();
                                }
                                if (tempDir == null) return n;
                                tempDir.delete();
                                return n;
                            }
                            if (status.getStatus() != 0) break block17;
                            writer.println("Error: Unrecognized file " + fileName);
                            int n = ERROR_IGNORED;
                            Object var13_19 = null;
                            if (tempFile != null) {
                                tempFile.delete();
                            }
                            if (tempDir == null) return n;
                            tempDir.delete();
                            return n;
                        }
                        writer.println("Error: Failed to deploy file " + fileName);
                        int n = ERROR_IGNORED;
                        Object var13_20 = null;
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                        if (tempDir == null) return n;
                        tempDir.delete();
                        return n;
                    }
                    Object var13_22 = null;
                    if (tempFile == null) break block18;
                    tempFile.delete();
                }
                catch (Throwable e) {
                    writer.println("Error: Failed to process uploaded data: " + e.getMessage());
                    e.printStackTrace(writer);
                    int n = ERROR_UNEXPECTED;
                    Object var13_23 = null;
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                    if (tempDir == null) return n;
                    tempDir.delete();
                    return n;
                }
            }
            if (tempDir == null) return OK;
            tempDir.delete();
            return OK;
        }
        catch (Throwable throwable) {
            Object var13_24 = null;
            if (tempFile != null) {
                tempFile.delete();
            }
            if (tempDir == null) throw throwable;
            tempDir.delete();
            throw throwable;
        }
    }
}

