/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.openid;

import com.google.step2.discovery.DefaultHostMetaFetcher;
import com.google.step2.discovery.Discovery2;
import com.google.step2.discovery.HostMetaFetcher;
import com.google.step2.discovery.IdpIdentifier;
import com.google.step2.discovery.LegacyXrdsResolver;
import com.google.step2.discovery.ParallelHostMetaFetcher;
import com.google.step2.discovery.SecureDiscoveryInformation;
import com.google.step2.discovery.SecureUrlIdentifier;
import com.google.step2.discovery.XrdDiscoveryResolver;
import com.google.step2.http.DefaultHttpFetcher;
import com.google.step2.http.HttpFetcher;
import com.google.step2.xmlsimplesign.CachedCertPathValidator;
import com.google.step2.xmlsimplesign.CertValidator;
import com.google.step2.xmlsimplesign.DefaultCertValidator;
import com.google.step2.xmlsimplesign.DefaultTrustRootsProvider;
import com.google.step2.xmlsimplesign.TrustRootsProvider;
import com.google.step2.xmlsimplesign.Verifier;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.administration.PortalAuthenticationConfiguration;
import org.apache.jetspeed.audit.AuditActivity;
import org.apache.jetspeed.cache.UserContentCacheManager;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.openid.OpenIDRegistrationConfiguration;
import org.apache.jetspeed.openid.step2.GoogleHostMetaFetcher;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.html.HtmlResolver;
import org.openid4java.discovery.xri.XriDotNetProxyResolver;
import org.openid4java.discovery.xri.XriResolver;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIDRelayingPartyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(OpenIDRelayingPartyServlet.class);
    private static final long OPEN_ID_DISCOVERY_TIMEOUT_SECONDS = 10L;
    private static final String OPEN_ID_DISCOVERY_INIT_PARAM_NAME_PREFIX = "discovery.";
    private static final String OPEN_ID_CONSUMER_INIT_PARAM_NAME_PREFIX = "consumer.";
    private static final String OPEN_ID_CONSUMER_INIT_PARAM_NAME_VALUE = "openid4java";
    private static final String STEP2_CONSUMER_INIT_PARAM_NAME_VALUE = "step2";
    private static final String OPEN_ID_PROVIDER_ATTR_NAME = "org.apache.jetspeed.openid.provider";
    private static final String OPEN_ID_DISCOVERY_INFO_ATTR_NAME = "org.apache.jetspeed.openid.discoveryinfo";
    private static final String USER_ATTRIBUTE_EMAIL = "user.business-info.online.email";
    private static final String USER_ATTRIBUTE_NAME = "user.name";
    private static final String USER_ATTRIBUTE_GIVEN_NAME = "user.name.given";
    private static final String USER_ATTRIBUTE_FAMILY_NAME = "user.name.family";
    private static final String USER_ATTRIBUTE_NICKNAME = "user.name.nickName";
    private static final String OPEN_ID_LOGIN_LOCALE_ATTR_NAME = "org.apache.jetspeed.openid.locale";
    private static final String OPEN_ID_LOGIN_SERVER_NAME_ATTR_NAME = "org.apache.jetspeed.openid.server.name";
    private ConsumerManager openIDConsumerManager;
    private ConsumerManager openIDStep2ConsumerManager;
    private UserManager portalUserManager;
    private PortalAdministration portalAdministration;
    private AuditActivity portalAudit;
    private PortalAuthenticationConfiguration portalAuthenticationConfiguration;
    private UserContentCacheManager portalUserContentCacheManager;
    private OpenIDRegistrationConfiguration initRegistrationConfiguration;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.openIDConsumerManager = new ConsumerManager();
            GoogleHostMetaFetcher step2GoogleHostMetaFetcher = new GoogleHostMetaFetcher((HttpFetcher)new DefaultHttpFetcher());
            DefaultHostMetaFetcher step2DefaultHostMetaFetcher = new DefaultHostMetaFetcher((HttpFetcher)new DefaultHttpFetcher());
            ThreadFactory parallelThreadFactory = new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread newThread = Executors.defaultThreadFactory().newThread(r);
                    newThread.setName(this.getClass().getSimpleName() + "-" + newThread.getName());
                    newThread.setDaemon(true);
                    return newThread;
                }
            };
            ParallelHostMetaFetcher step2HostMetaFetcher = new ParallelHostMetaFetcher(Executors.newFixedThreadPool(10, parallelThreadFactory), Long.valueOf(10L), new HostMetaFetcher[]{step2GoogleHostMetaFetcher, step2DefaultHostMetaFetcher});
            DefaultTrustRootsProvider step2XrdsTrustProvider = new DefaultTrustRootsProvider();
            CachedCertPathValidator step2XrdsCertPathValidator = new CachedCertPathValidator((TrustRootsProvider)step2XrdsTrustProvider);
            Verifier step2XrdsVerifier = new Verifier(step2XrdsCertPathValidator, (HttpFetcher)new DefaultHttpFetcher());
            DefaultCertValidator step2XrdsCertValidator = new DefaultCertValidator();
            LegacyXrdsResolver step2XrdResolver = new LegacyXrdsResolver((HttpFetcher)new DefaultHttpFetcher(), step2XrdsVerifier, (CertValidator)step2XrdsCertValidator);
            HtmlResolver step2HtmlResolver = new HtmlResolver();
            YadisResolver step2YadisResolver = new YadisResolver();
            XriDotNetProxyResolver step2XriResolver = new XriDotNetProxyResolver();
            Discovery2 step2Discovery = new Discovery2((HostMetaFetcher)step2HostMetaFetcher, (XrdDiscoveryResolver)step2XrdResolver, step2HtmlResolver, step2YadisResolver, (XriResolver)step2XriResolver);
            this.openIDStep2ConsumerManager = new ConsumerManager();
            this.openIDStep2ConsumerManager.setDiscovery((Discovery)step2Discovery);
        }
        catch (OpenIDException oide) {
            throw new ServletException("Unexpected OpenID exception: " + (Object)((Object)oide), (Throwable)oide);
        }
        ComponentManager cm = Jetspeed.getComponentManager();
        this.portalUserManager = (UserManager)cm.getComponent((Object)"org.apache.jetspeed.security.UserManager");
        this.portalAdministration = (PortalAdministration)cm.getComponent((Object)"PortalAdministration");
        this.portalAudit = (AuditActivity)cm.getComponent((Object)"org.apache.jetspeed.audit.AuditActivity");
        this.portalAuthenticationConfiguration = (PortalAuthenticationConfiguration)cm.getComponent((Object)"org.apache.jetspeed.administration.PortalAuthenticationConfiguration");
        this.portalUserContentCacheManager = (UserContentCacheManager)cm.getComponent((Object)"userContentCacheManager");
        if (Boolean.parseBoolean(config.getInitParameter("enableRegistrationConfig"))) {
            this.initRegistrationConfiguration = new OpenIDRegistrationConfiguration();
            this.initRegistrationConfiguration.setEnableRegistration(config.getInitParameter("enableRegistration"));
            this.initRegistrationConfiguration.setUserTemplateDirectory(config.getInitParameter("newUserTemplateDirectory"));
            this.initRegistrationConfiguration.setSubsiteRootFolder(config.getInitParameter("subsiteRootFolder"));
            this.initRegistrationConfiguration.setRoles(config.getInitParameter("roles"));
            this.initRegistrationConfiguration.setGroups(config.getInitParameter("groups"));
            this.initRegistrationConfiguration.setProfilerRules(config.getInitParameter("rulesNames"), config.getInitParameter("rulesValues"));
        }
    }

    public void destroy() {
        this.initRegistrationConfiguration = null;
        this.portalUserContentCacheManager = null;
        this.portalAuthenticationConfiguration = null;
        this.portalAdministration = null;
        this.portalUserManager = null;
        this.openIDStep2ConsumerManager = null;
        this.openIDConsumerManager = null;
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String servletPath;
        String openIDRealmURL = this.openIDRealmURL(request);
        String requestPath = request.getRequestURI();
        if (requestPath.equals(servletPath = request.getContextPath() + request.getServletPath())) {
            response.setHeader("Cache-Control", "no-cache,no-store,private");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.setContentType("text/xml");
            response.setStatus(200);
            PrintWriter out = response.getWriter();
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<Service xmlns=\"xri://$xrd*($v*2.0)\">");
            out.println("  <Type>http://specs.openid.net/auth/2.0/return_to</Type>");
            out.println("  <URI>" + openIDRealmURL + "</URI>");
            out.println("</Service>");
            out.flush();
            out.close();
            if (log.isDebugEnabled()) {
                log.debug("OpenID realm request received, returned realm: " + openIDRealmURL);
            }
        } else {
            HttpSession httpSession = request.getSession();
            httpSession.removeAttribute("org.apache.jetspeed.openid.error");
            httpSession.setAttribute(OPEN_ID_LOGIN_LOCALE_ATTR_NAME, (Object)request.getLocale());
            httpSession.setAttribute(OPEN_ID_LOGIN_SERVER_NAME_ATTR_NAME, (Object)request.getServerName());
            String servletPathPrefix = servletPath + "/";
            if (requestPath.startsWith(servletPathPrefix)) {
                requestPath = requestPath.substring(servletPathPrefix.length());
            }
            if (requestPath.equals("login")) {
                String returnPath;
                String provider;
                String discovery = request.getParameter("org.apache.jetspeed.openid.discovery");
                if (discovery != null && discovery.length() == 0) {
                    discovery = null;
                }
                if ((provider = request.getParameter(OPEN_ID_PROVIDER_ATTR_NAME)) != null && provider.length() == 0) {
                    provider = null;
                }
                if ((returnPath = request.getParameter("org.apache.jetspeed.openid.return")) == null || returnPath.length() == 0) {
                    returnPath = request.getContextPath() + "/";
                }
                boolean discoveredProvider = false;
                try {
                    String consumer;
                    String userSuppliedDiscoveryString = discovery;
                    if (provider == null && userSuppliedDiscoveryString != null) {
                        if (!userSuppliedDiscoveryString.startsWith("http://") && !userSuppliedDiscoveryString.startsWith("https://")) {
                            if (!(userSuppliedDiscoveryString.startsWith("xri://") || userSuppliedDiscoveryString.startsWith("=") || userSuppliedDiscoveryString.startsWith("@"))) {
                                int emailDomainSeparatorIndex = userSuppliedDiscoveryString.indexOf(64);
                                if (emailDomainSeparatorIndex != -1) {
                                    provider = userSuppliedDiscoveryString.substring(emailDomainSeparatorIndex + 1);
                                } else if (Character.isLetterOrDigit(userSuppliedDiscoveryString.charAt(0))) {
                                    provider = userSuppliedDiscoveryString;
                                }
                            }
                        } else {
                            int domainIndex = userSuppliedDiscoveryString.indexOf("://") + 3;
                            int endDomainIndex = userSuppliedDiscoveryString.indexOf(47, domainIndex);
                            if (endDomainIndex == -1) {
                                endDomainIndex = userSuppliedDiscoveryString.length();
                            }
                            if ((domainIndex = (provider = userSuppliedDiscoveryString.substring(domainIndex, endDomainIndex)).lastIndexOf(46, provider.length())) > 0) {
                                domainIndex = provider.lastIndexOf(46, domainIndex - 1);
                            }
                            if (domainIndex != -1) {
                                provider = provider.substring(domainIndex);
                            }
                        }
                    }
                    if (provider != null) {
                        String providerSuppliedDiscoveryString = this.getInitParameter(OPEN_ID_DISCOVERY_INIT_PARAM_NAME_PREFIX + provider);
                        if (providerSuppliedDiscoveryString != null) {
                            userSuppliedDiscoveryString = providerSuppliedDiscoveryString;
                        } else if (userSuppliedDiscoveryString == null) {
                            userSuppliedDiscoveryString = provider;
                        }
                    }
                    String providerConsumer = OPEN_ID_CONSUMER_INIT_PARAM_NAME_VALUE;
                    ConsumerManager providerOpenIDConsumerManager = this.openIDConsumerManager;
                    if (provider != null && (consumer = this.getInitParameter(OPEN_ID_CONSUMER_INIT_PARAM_NAME_PREFIX + provider)) != null && consumer.equals(STEP2_CONSUMER_INIT_PARAM_NAME_VALUE)) {
                        providerConsumer = STEP2_CONSUMER_INIT_PARAM_NAME_VALUE;
                        providerOpenIDConsumerManager = this.openIDStep2ConsumerManager;
                    }
                    DiscoveryInformation discovered = null;
                    try {
                        if (userSuppliedDiscoveryString != null) {
                            List discoveries = null;
                            if (providerConsumer.equals(STEP2_CONSUMER_INIT_PARAM_NAME_VALUE)) {
                                if (userSuppliedDiscoveryString.indexOf("://") == -1 && userSuppliedDiscoveryString.indexOf(64) == -1 && userSuppliedDiscoveryString.indexOf(61) == -1) {
                                    IdpIdentifier providerIdentifier = new IdpIdentifier(userSuppliedDiscoveryString);
                                    discoveries = providerOpenIDConsumerManager.getDiscovery().discover((Identifier)providerIdentifier);
                                }
                            } else {
                                discoveries = providerOpenIDConsumerManager.discover(userSuppliedDiscoveryString);
                            }
                            if (discoveries != null && !discoveries.isEmpty()) {
                                discovered = providerOpenIDConsumerManager.associate(discoveries);
                            }
                        }
                    }
                    catch (OpenIDException oide) {
                        throw new RuntimeException("Unexpected OpenID discovery exception: " + (Object)((Object)oide), oide);
                    }
                    if (discovered == null) {
                        throw new RuntimeException("No OpenID provider discovered for: " + userSuppliedDiscoveryString);
                    }
                    discoveredProvider = true;
                    if (log.isDebugEnabled()) {
                        log.debug("Discovered OpenID provider endpoint: " + discovered.getOPEndpoint() + ", [" + discovered.getClass().getSimpleName() + "]");
                    }
                    httpSession.setAttribute(OPEN_ID_LOGIN_LOCALE_ATTR_NAME, (Object)request.getLocale());
                    httpSession.setAttribute(OPEN_ID_LOGIN_SERVER_NAME_ATTR_NAME, (Object)request.getServerName());
                    httpSession.setAttribute(OPEN_ID_PROVIDER_ATTR_NAME, (Object)provider);
                    httpSession.setAttribute(OPEN_ID_DISCOVERY_INFO_ATTR_NAME, (Object)discovered);
                    String authReturnToURL = openIDRealmURL + "/" + "authed" + "?" + "org.apache.jetspeed.openid.return" + "=" + returnPath;
                    String authRedirectURL = null;
                    try {
                        AuthRequest authRequest = providerOpenIDConsumerManager.authenticate(discovered, authReturnToURL, openIDRealmURL);
                        FetchRequest axRequest = FetchRequest.createFetchRequest();
                        axRequest.addAttribute("email", "http://axschema.org/contact/email", true);
                        axRequest.addAttribute("fullname", "http://axschema.org/namePerson", true);
                        axRequest.addAttribute("lastname", "http://axschema.org/namePerson/last", true);
                        axRequest.addAttribute("firstname", "http://axschema.org/namePerson/first", true);
                        axRequest.addAttribute("nickname", "http://axschema.org/namePerson/friendly", true);
                        authRequest.addExtension((MessageExtension)axRequest);
                        SRegRequest sregRequest = SRegRequest.createFetchRequest();
                        sregRequest.addAttribute("email", true);
                        sregRequest.addAttribute("fullname", true);
                        sregRequest.addAttribute("nickname", true);
                        authRequest.addExtension((MessageExtension)sregRequest);
                        authRedirectURL = authRequest.getDestinationUrl(true);
                    }
                    catch (OpenIDException oide) {
                        throw new RuntimeException("Unexpected OpenID authentication request exception: " + (Object)((Object)oide), oide);
                    }
                    response.sendRedirect(authRedirectURL);
                    if (log.isDebugEnabled()) {
                        log.debug("OpenID authentication redirect: " + authRedirectURL);
                    }
                }
                catch (Exception e) {
                    log.error("OpenID login error: " + e, (Throwable)e);
                    httpSession.setAttribute("org.apache.jetspeed.openid.error", (Object)(!discoveredProvider ? "ErrorNoProvider" : "ErrorCannotAuthenticate"));
                    response.sendRedirect(returnPath);
                }
            } else if (requestPath.equals("authed")) {
                OpenIDRegistrationConfiguration portalRegistrationConfiguration;
                String loginServerName;
                Locale loginLocale;
                String returnPath = request.getParameter("org.apache.jetspeed.openid.return");
                if (returnPath == null || returnPath.length() == 0) {
                    returnPath = request.getContextPath() + "/";
                }
                if ((loginLocale = (Locale)httpSession.getAttribute(OPEN_ID_LOGIN_LOCALE_ATTR_NAME)) != null) {
                    httpSession.removeAttribute(OPEN_ID_LOGIN_LOCALE_ATTR_NAME);
                }
                if ((loginServerName = (String)httpSession.getAttribute(OPEN_ID_LOGIN_SERVER_NAME_ATTR_NAME)) != null) {
                    httpSession.removeAttribute(OPEN_ID_LOGIN_SERVER_NAME_ATTR_NAME);
                }
                if ((portalRegistrationConfiguration = (OpenIDRegistrationConfiguration)httpSession.getAttribute("org.apache.jetspeed.openid.registration.configuration")) != null) {
                    httpSession.removeAttribute("org.apache.jetspeed.openid.registration.configuration");
                }
                boolean authenticatedByProvider = false;
                boolean portalUserExists = false;
                try {
                    int emailDomainIndex;
                    String consumer;
                    ParameterList authParams = new ParameterList(request.getParameterMap());
                    String provider = (String)httpSession.getAttribute(OPEN_ID_PROVIDER_ATTR_NAME);
                    DiscoveryInformation discovered = (DiscoveryInformation)httpSession.getAttribute(OPEN_ID_DISCOVERY_INFO_ATTR_NAME);
                    StringBuffer authRequestURLBuffer = request.getRequestURL();
                    String authRequestQueryString = request.getQueryString();
                    if (authRequestQueryString != null && authRequestQueryString.length() > 0) {
                        authRequestURLBuffer.append('?').append(authRequestQueryString);
                    }
                    String authRequestURL = authRequestURLBuffer.toString();
                    String providerConsumer = OPEN_ID_CONSUMER_INIT_PARAM_NAME_VALUE;
                    if (provider != null && (consumer = this.getInitParameter(OPEN_ID_CONSUMER_INIT_PARAM_NAME_PREFIX + provider)) != null && consumer.equals(STEP2_CONSUMER_INIT_PARAM_NAME_VALUE)) {
                        providerConsumer = STEP2_CONSUMER_INIT_PARAM_NAME_VALUE;
                    }
                    VerificationResults verificationResults = null;
                    verificationResults = providerConsumer.equals(STEP2_CONSUMER_INIT_PARAM_NAME_VALUE) ? this.openIDStep2Verification(authRequestURL, authParams, discovered) : this.openIDVerification(authRequestURL, authParams, discovered);
                    VerificationResult verification = verificationResults.verification;
                    Identifier verifiedIdentifier = verificationResults.verifiedIdentifier;
                    if (verifiedIdentifier == null) {
                        throw new RuntimeException("Verified identifier unavailable for authenticated OpenID login");
                    }
                    authenticatedByProvider = true;
                    String email = null;
                    String firstName = null;
                    String lastName = null;
                    String nickname = null;
                    String fullName = null;
                    AuthSuccess authResponse = (AuthSuccess)verification.getAuthResponse();
                    if (authResponse.hasExtension("http://openid.net/srv/ax/1.0")) {
                        try {
                            FetchResponse axResponse = (FetchResponse)authResponse.getExtension("http://openid.net/srv/ax/1.0");
                            email = axResponse.getAttributeValue("email");
                            fullName = axResponse.getAttributeValue("fullname");
                            firstName = axResponse.getAttributeValue("firstname");
                            lastName = axResponse.getAttributeValue("lastname");
                            nickname = axResponse.getAttributeValue("nickname");
                        }
                        catch (OpenIDException oide) {
                            throw new RuntimeException("Unexpected OpenID authenticated attribute exchange fetch exception: " + (Object)((Object)oide), oide);
                        }
                    }
                    if (authResponse.hasExtension("http://openid.net/sreg/1.0")) {
                        try {
                            SRegResponse sregResponse = (SRegResponse)authResponse.getExtension("http://openid.net/sreg/1.0");
                            email = sregResponse.getAttributeValue("email");
                            fullName = sregResponse.getAttributeValue("fullname");
                            nickname = sregResponse.getAttributeValue("nickname");
                        }
                        catch (OpenIDException oide) {
                            throw new RuntimeException("Unexpected OpenID authenticated simple registration fetch exception: " + (Object)((Object)oide), oide);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Authenticated OpenID verified identifier: " + verifiedIdentifier.getIdentifier() + ", email=" + email + ", fullname=" + fullName + ", firstname=" + firstName + ", lastname=" + lastName + ", nickname=" + nickname);
                    }
                    if (email == null) {
                        throw new RuntimeException("OpenID email attribute required for portal login");
                    }
                    if (fullName != null) {
                        String[] fullNames = fullName.split("\\s");
                        if (firstName == null && fullNames.length > 1) {
                            firstName = fullNames[0];
                        }
                        if (lastName == null) {
                            String string = lastName = fullNames.length > 1 ? fullNames[fullNames.length - 1] : fullName;
                        }
                    }
                    if (nickname == null && firstName != null) {
                        nickname = firstName;
                    }
                    if (nickname == null && (emailDomainIndex = email.indexOf(64)) != -1) {
                        nickname = email.substring(0, emailDomainIndex);
                    }
                    HashMap<String, String> userAttributes = new HashMap<String, String>();
                    userAttributes.put(USER_ATTRIBUTE_EMAIL, email);
                    userAttributes.put(USER_ATTRIBUTE_NAME, email);
                    if (firstName != null) {
                        userAttributes.put(USER_ATTRIBUTE_GIVEN_NAME, firstName);
                    }
                    if (lastName != null) {
                        userAttributes.put(USER_ATTRIBUTE_FAMILY_NAME, lastName);
                    }
                    if (nickname != null) {
                        userAttributes.put(USER_ATTRIBUTE_NICKNAME, nickname);
                    }
                    User portalUser = null;
                    try {
                        portalUser = this.portalUserManager.getUser(email);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (portalUser == null) {
                        try {
                            String logConfiguration = "none";
                            if (portalRegistrationConfiguration != null) {
                                portalRegistrationConfiguration.merge(this.initRegistrationConfiguration);
                                logConfiguration = "session, (from login)";
                            } else if (this.initRegistrationConfiguration != null) {
                                portalRegistrationConfiguration = this.initRegistrationConfiguration;
                                logConfiguration = "init params";
                            }
                            if (portalRegistrationConfiguration == null || portalRegistrationConfiguration.isEnableRegistration()) {
                                if (portalRegistrationConfiguration != null) {
                                    this.portalAdministration.registerUser(email, null, portalRegistrationConfiguration.getRoles(), portalRegistrationConfiguration.getGroups(), userAttributes, portalRegistrationConfiguration.getProfilerRules(), portalRegistrationConfiguration.getUserTemplateDirectory(), portalRegistrationConfiguration.getSubsiteRootFolder(), loginLocale, loginServerName);
                                } else {
                                    this.portalAdministration.registerUser(email, null, null, null, userAttributes, null, null, null, loginLocale, loginServerName);
                                }
                                portalUser = this.portalUserManager.getUser(email);
                                if (log.isDebugEnabled()) {
                                    if (portalUser != null) {
                                        log.debug("OpenID login registered portal user: " + portalUser.getName() + ", configuration: " + logConfiguration + ", locale: " + loginLocale + ", server: " + loginServerName);
                                    } else {
                                        log.debug("OpenID login unregistered portal user, (registration failed): " + email + ", configuration: " + logConfiguration + ", locale: " + loginLocale + ", server: " + loginServerName);
                                    }
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug("OpenID login unregistered portal user, (registration disabled): " + email + ", configuration: " + logConfiguration);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to register portal user: " + email);
                        }
                    }
                    if (portalUser == null) {
                        throw new RuntimeException("Missing registered portal user: " + email);
                    }
                    portalUserExists = true;
                    boolean portalUserAttributesUpdated = false;
                    SecurityAttributes portalUserAttributes = portalUser.getSecurityAttributes();
                    for (Map.Entry attribute : userAttributes.entrySet()) {
                        SecurityAttribute userAttribute;
                        String name = (String)attribute.getKey();
                        String value = (String)attribute.getValue();
                        if (value.equals((userAttribute = portalUserAttributes.getAttribute(name, true)).getStringValue())) continue;
                        userAttribute.setStringValue(value);
                        portalUserAttributesUpdated = true;
                    }
                    if (portalUserAttributesUpdated) {
                        try {
                            this.portalUserManager.updateUser(portalUser);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to update attributes for user: " + portalUser.getName());
                        }
                    }
                    Subject subject = null;
                    try {
                        subject = this.portalUserManager.getSubject(portalUser);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to login portal user: " + portalUser.getName());
                    }
                    if (this.portalAuthenticationConfiguration.isCreateNewSessionOnLogin()) {
                        httpSession.invalidate();
                        httpSession = request.getSession(true);
                    } else {
                        this.portalUserContentCacheManager.evictUserContentCache(portalUser.getName(), httpSession.getId());
                    }
                    httpSession.setAttribute("org.apache.jetspeed.security.openid.provider", (Object)provider);
                    httpSession.setAttribute("org.apache.jetspeed.security.subject", (Object)subject);
                    this.portalAudit.logUserActivity(portalUser.getName(), request.getRemoteAddr(), "login-success", "OpenIDRelayingPartyServlet");
                    response.sendRedirect(returnPath);
                }
                catch (Exception e) {
                    log.error("OpenID login error: " + e, (Throwable)e);
                    httpSession.setAttribute("org.apache.jetspeed.openid.error", (Object)(!authenticatedByProvider ? "ErrorNotAuthenticated" : (!portalUserExists ? "ErrorNoPortaUser" : "ErrorCannotLogin")));
                    response.sendRedirect(returnPath);
                }
            } else if (requestPath.equals("logout")) {
                String returnPath = request.getParameter("org.apache.jetspeed.openid.return");
                if (returnPath == null || returnPath.length() == 0) {
                    returnPath = request.getContextPath() + "/";
                }
                httpSession.invalidate();
                response.sendRedirect(returnPath);
            } else {
                throw new ServletException("Unexpected OpenID request: " + requestPath);
            }
        }
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    private String openIDRealmURL(HttpServletRequest request) {
        StringBuilder openIDRealmURLBuilder = new StringBuilder(request.isSecure() ? "https://" : "http://");
        openIDRealmURLBuilder.append(request.getServerName());
        if (request.isSecure() && request.getServerPort() != 443 || !request.isSecure() && request.getServerPort() != 80) {
            openIDRealmURLBuilder.append(':').append(request.getServerPort());
        }
        openIDRealmURLBuilder.append(request.getContextPath() + request.getServletPath());
        return openIDRealmURLBuilder.toString();
    }

    private VerificationResults openIDVerification(String authRequestURL, ParameterList authParams, DiscoveryInformation discovered) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Verify standard OpenID authentication request using: " + discovered.getOPEndpoint());
            }
            VerificationResults results = new VerificationResults();
            results.verification = this.openIDConsumerManager.verify(authRequestURL, authParams, discovered);
            if (log.isDebugEnabled() && results.verification != null) {
                log.debug("Verified standard OpenID authentication request: " + authRequestURL);
            }
            results.verifiedIdentifier = results.verification.getVerifiedId();
            if (log.isDebugEnabled() && results.verifiedIdentifier != null) {
                log.debug("Verified standard OpenID authentication request identity: " + results.verifiedIdentifier);
            }
            return results;
        }
        catch (OpenIDException oide) {
            throw new RuntimeException("Unexpected standard OpenId authenticated request verification exception: " + (Object)((Object)oide), oide);
        }
    }

    private VerificationResults openIDStep2Verification(String authRequestURL, ParameterList authParams, DiscoveryInformation discovered) {
        try {
            AuthSuccess authResponse;
            VerificationResults results = new VerificationResults();
            String openIdMode = authParams.getParameterValue("openid.mode");
            if (openIdMode != null && openIdMode.equals("id_res") && (authResponse = AuthSuccess.createAuthSuccess((ParameterList)authParams)) != null && authResponse.isVersion2() && authResponse.getIdentity() != null && authResponse.getClaimed() != null) {
                String providerId = authResponse.getIdentity();
                Identifier responseClaimedId = this.openIDStep2ConsumerManager.getDiscovery().parseIdentifier(authResponse.getClaimed(), true);
                String responseEndpoint = authResponse.getOpEndpoint();
                if (log.isDebugEnabled()) {
                    log.debug("Step2 discovery for identity: " + responseClaimedId);
                }
                SecureDiscoveryInformation secureDiscovered = null;
                if (discovered instanceof SecureDiscoveryInformation && discovered.isVersion2() && discovered.hasClaimedIdentifier() && discovered.getClaimedIdentifier().equals(responseClaimedId) && discovered.getOPEndpoint().equals(responseEndpoint)) {
                    String discoveredProviderId;
                    String string = discoveredProviderId = discovered.hasDelegateIdentifier() ? discovered.getDelegateIdentifier() : discovered.getClaimedIdentifier().getIdentifier();
                    if (discoveredProviderId.equals(providerId)) {
                        secureDiscovered = (SecureDiscoveryInformation)discovered;
                        if (log.isDebugEnabled()) {
                            log.debug("Matched previously discovered Step2 secure discovery information for " + responseClaimedId + " identity: " + secureDiscovered.getOPEndpoint());
                        }
                    }
                }
                if (secureDiscovered == null) {
                    List discoveredInfos = this.openIDStep2ConsumerManager.getDiscovery().discover(responseClaimedId);
                    for (SecureDiscoveryInformation discoveredInfo : discoveredInfos) {
                        String discoveredProviderId;
                        String version = discoveredInfo.getVersion();
                        if (version == null || !version.equals("http://specs.openid.net/auth/2.0/server") || !discoveredInfo.isVersion2() || !discoveredInfo.getOPEndpoint().equals(responseEndpoint) || !(discoveredProviderId = discoveredInfo.hasDelegateIdentifier() ? discoveredInfo.getDelegateIdentifier() : discoveredInfo.getClaimedIdentifier().getIdentifier()).equals(providerId)) continue;
                        if (this.openIDStep2ConsumerManager.getPrivateAssociationStore().load(discoveredInfo.getOPEndpoint().toString(), authResponse.getHandle()) != null) {
                            secureDiscovered = discoveredInfo;
                            break;
                        }
                        if (secureDiscovered != null) continue;
                        secureDiscovered = discoveredInfo;
                    }
                    if (log.isDebugEnabled() && secureDiscovered != null) {
                        log.debug("Discovered Step2 secure discovery information for " + responseClaimedId + " identity: " + secureDiscovered.getOPEndpoint());
                    }
                }
                if (log.isDebugEnabled() && secureDiscovered != null) {
                    log.debug("Verify Step2 OpenID authentication request using: " + secureDiscovered.getOPEndpoint());
                }
                results.verification = this.openIDStep2ConsumerManager.verify(authRequestURL, authParams, secureDiscovered);
                if (log.isDebugEnabled() && results.verification != null) {
                    log.debug("Verified Step2 OpenID authentication request: " + authRequestURL);
                }
                if (results.verification.getAuthResponse() instanceof AuthSuccess && results.verification.getVerifiedId() != null) {
                    boolean secureVerification;
                    boolean bl = secureVerification = secureDiscovered != null && secureDiscovered.getClaimedIdentifier() != null && secureDiscovered.isSecure();
                    if (secureVerification) {
                        try {
                            UrlIdentifier verifiedClaimedId = new UrlIdentifier(results.verification.getVerifiedId().getIdentifier(), true);
                            secureVerification = secureDiscovered.getClaimedIdentifier().getIdentifier().equals(verifiedClaimedId.getIdentifier());
                        }
                        catch (OpenIDException oide) {
                            secureVerification = false;
                        }
                    }
                    Identifier verifiedId = results.verification.getVerifiedId();
                    Object object = results.verifiedIdentifier = secureVerification ? new SecureUrlIdentifier(verifiedId) : verifiedId;
                    if (log.isDebugEnabled()) {
                        log.debug("Verified Step2 OpenID authentication request identity: " + results.verifiedIdentifier);
                    }
                } else {
                    throw new RuntimeException("Step2 OpenId authenticated request verification failed");
                }
            }
            return results;
        }
        catch (OpenIDException oide) {
            throw new RuntimeException("Unexpected Step2 OpenId authenticated request verification exception: " + (Object)((Object)oide), oide);
        }
    }

    private class VerificationResults {
        public VerificationResult verification = null;
        public Identifier verifiedIdentifier = null;

        private VerificationResults() {
        }
    }
}

