/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.openid.filter;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.login.filter.PortalRequestWrapper;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;

public class OpenIDPortalFilter
implements Filter {
    protected String guest = "guest";

    public void init(FilterConfig filterConfig) throws ServletException {
        PortalConfiguration config = Jetspeed.getConfiguration();
        if (config != null) {
            this.guest = config.getString("default.user.principal");
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            Principal principal;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            Subject subject = (Subject)request.getSession().getAttribute("org.apache.jetspeed.security.subject");
            if (!(subject == null || (principal = SubjectHelper.getPrincipal((Subject)subject, User.class)) != null && principal.getName().equals(this.guest))) {
                servletRequest = new PortalRequestWrapper(request, subject, principal);
            }
            servletRequest.setAttribute("org.apache.jetspeed.login.filter.PortalFilter", (Object)"true");
        }
        if (filterChain != null) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

