/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.pipeline.Pipeline;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.CleanupValve;
import org.apache.jetspeed.pipeline.valve.Valve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;

public class JetspeedPipeline
implements Pipeline {
    protected String name;
    protected Valve[] valves;
    protected Valve[] cleanupValves;

    public JetspeedPipeline(String name, List valveList) throws Exception {
        ArrayList<Valve> valvesList = new ArrayList<Valve>();
        ArrayList<Valve> cleanupValvesList = new ArrayList<Valve>();
        for (Valve valve : valveList) {
            if (valve instanceof CleanupValve) {
                cleanupValvesList.add(valve);
                continue;
            }
            valvesList.add(valve);
        }
        this.valves = valvesList.toArray(new Valve[valvesList.size()]);
        this.cleanupValves = cleanupValvesList.toArray(new Valve[cleanupValvesList.size()]);
        this.setName(name);
    }

    public void initialize() throws PipelineException {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addValve(Valve valve) {
        if (valve instanceof CleanupValve) {
            this.cleanupValves = JetspeedPipeline.appendToValveArray(this.cleanupValves, valve);
        } else {
            this.valves = JetspeedPipeline.appendToValveArray(this.valves, valve);
        }
    }

    public synchronized Valve[] getValves() {
        return JetspeedPipeline.copyValveArray(this.valves);
    }

    public synchronized Valve[] getCleanupValves() {
        return JetspeedPipeline.copyValveArray(this.cleanupValves);
    }

    public synchronized void removeValve(Valve valve) {
        if (valve instanceof CleanupValve) {
            this.cleanupValves = JetspeedPipeline.removeFromValveArray(this.cleanupValves, valve);
        } else {
            this.valves = JetspeedPipeline.removeFromValveArray(this.valves, valve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(RequestContext request) throws PipelineException {
        JetspeedPipeline jetspeedPipeline;
        try {
            Invocation invocation;
            jetspeedPipeline = this;
            synchronized (jetspeedPipeline) {
                invocation = new Invocation(this.valves);
            }
            invocation.invokeNext(request);
        }
        finally {
            Valve[] invokeCleanupValves;
            jetspeedPipeline = this;
            synchronized (jetspeedPipeline) {
                invokeCleanupValves = JetspeedPipeline.copyValveArray(this.cleanupValves);
            }
            for (int i = 0; i < invokeCleanupValves.length; ++i) {
                Invocation cleanupInvocation = new Invocation(invokeCleanupValves[i]);
                try {
                    cleanupInvocation.invokeNext(request);
                    continue;
                }
                catch (Throwable t) {}
            }
        }
    }

    private static Valve[] copyValveArray(Valve[] array) {
        Valve[] newArray = new Valve[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private static Valve[] appendToValveArray(Valve[] array, Valve valve) {
        Valve[] newArray = new Valve[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = valve;
        return newArray;
    }

    private static Valve[] removeFromValveArray(Valve[] array, Valve valve) {
        int index = -1;
        for (int i = 0; i < array.length && index == -1; ++i) {
            index = array[i] == valve ? i : -1;
        }
        if (index != -1) {
            Valve[] newArray = new Valve[array.length - 1];
            System.arraycopy(array, 0, newArray, 0, index);
            System.arraycopy(array, index + 1, newArray, index, array.length - index - 1);
            return newArray;
        }
        return array;
    }

    private static final class Invocation
    implements ValveContext {
        private final Valve[] valves;
        private int at = 0;

        public Invocation(Valve valve) {
            this.valves = new Valve[]{valve};
        }

        public Invocation(Valve[] valves) {
            this.valves = valves;
        }

        public void invokeNext(RequestContext request) throws PipelineException {
            if (this.at < this.valves.length) {
                Valve next = this.valves[this.at];
                ++this.at;
                next.invoke(request, (ValveContext)this);
            }
        }
    }
}

