/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline;

import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.pipeline.Pipeline;
import org.apache.jetspeed.pipeline.PipelineMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedPipelineMapper
implements PipelineMapper {
    private Map<String, String> pipelineNamesMap;
    private Map<String, String[]> pipelineIdPathsMap;

    public JetspeedPipelineMapper(Map<String, String> pipelineNamesMap) {
        this.pipelineNamesMap = pipelineNamesMap;
        this.pipelineIdPathsMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : this.pipelineNamesMap.entrySet()) {
            String path = entry.getKey();
            String pipelineId = entry.getValue();
            if (!this.pipelineIdPathsMap.containsKey(pipelineId)) {
                this.pipelineIdPathsMap.put(pipelineId, new String[]{path});
                continue;
            }
            String[] paths = this.pipelineIdPathsMap.get(pipelineId);
            String[] mappedPaths = new String[paths.length + 1];
            System.arraycopy(paths, 0, mappedPaths, 0, paths.length);
            mappedPaths[mappedPaths.length - 1] = path;
            this.pipelineIdPathsMap.put(pipelineId, mappedPaths);
        }
    }

    public Pipeline getPipelineByMappedPath(String mappedPath) {
        if (this.pipelineNamesMap == null) {
            return null;
        }
        String pipelineId = this.pipelineNamesMap.get(mappedPath);
        if (pipelineId != null) {
            return this.getPipelineById(pipelineId);
        }
        return null;
    }

    public Pipeline getPipelineById(String pipelineId) {
        ComponentManager componentManager = Jetspeed.getComponentManager();
        if (componentManager == null) {
            return null;
        }
        return (Pipeline)componentManager.getComponent((Object)pipelineId);
    }

    public String getMappedPathByPipelineId(String pipelineId) {
        if (this.pipelineIdPathsMap == null) {
            return null;
        }
        String[] paths = this.pipelineIdPathsMap.get(pipelineId);
        if (paths == null) {
            return null;
        }
        return paths.length > 0 ? paths[0] : null;
    }

    public String[] getMappedPathsByPipelineId(String pipelineId) {
        if (this.pipelineIdPathsMap == null) {
            return null;
        }
        String[] paths = this.pipelineIdPathsMap.get(pipelineId);
        if (paths == null) {
            return new String[0];
        }
        String[] mappedPaths = new String[paths.length];
        System.arraycopy(paths, 0, mappedPaths, 0, paths.length);
        return mappedPaths;
    }
}

