/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline.valve;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.healthcheck.validators.HealthCheckValidator;
import org.apache.jetspeed.healthcheck.validators.HealthCheckValidatorResult;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckValve
extends AbstractValve {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger log = LoggerFactory.getLogger(HealthCheckValve.class);
    public static boolean isInfoEnabled = log.isInfoEnabled();
    public static boolean isDebugEnabled = log.isDebugEnabled();
    private List validators;
    private String successMessage;
    private String failMessage;
    private boolean addValidationMessagesToResponse;
    private boolean stopValidationOnError;

    public HealthCheckValve(List validators, String successMessage, String failMessage, boolean addValidationMessagesToResponse, boolean stopValidationOnError) {
        this.validators = validators;
        this.successMessage = successMessage;
        this.failMessage = failMessage;
        this.addValidationMessagesToResponse = addValidationMessagesToResponse;
        this.stopValidationOnError = stopValidationOnError;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        if (isDebugEnabled) {
            log.debug("Starting method: HealthCheckValve.invoke()");
        }
        ArrayList<String> messages = new ArrayList<String>();
        HttpServletResponse response = request.getResponse();
        boolean healthCheckStatus = true;
        try {
            for (HealthCheckValidator hcv : this.validators) {
                if (isDebugEnabled) {
                    log.debug("Starting validator execution: " + hcv.getClass().getName());
                }
                HealthCheckValidatorResult result = null;
                for (int i = 0; i <= hcv.getNumberOfRetries(); ++i) {
                    result = hcv.validate();
                    if (isDebugEnabled) {
                        log.debug("Validator execution: " + (result.getHealthCheckResult() == 101));
                    }
                    if (result.getHealthCheckResult() == 101) break;
                    if (i + 1 > hcv.getNumberOfRetries() || hcv.getRetryDelay() <= 0L) continue;
                    try {
                        Thread.sleep(hcv.getRetryDelay());
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (result == null) continue;
                if (this.addValidationMessagesToResponse) {
                    messages.add(result.getResultMessage());
                }
                if (result.getHealthCheckResult() == 101) continue;
                healthCheckStatus = false;
                if (!this.stopValidationOnError) continue;
                break;
            }
            PrintWriter pw = response.getWriter();
            if (healthCheckStatus) {
                pw.write(this.successMessage);
            } else {
                pw.write(this.failMessage);
            }
            if (this.addValidationMessagesToResponse) {
                Iterator it = messages.iterator();
                while (it.hasNext()) {
                    pw.write(LINE_SEPARATOR + (String)it.next());
                }
            }
        }
        catch (Exception e) {
            log.error("Exception while running HealthCheckValve", (Throwable)e);
            try {
                if (!response.isCommitted()) {
                    response.resetBuffer();
                }
                PrintWriter pw = response.getWriter();
                pw.write(this.failMessage);
                if (this.addValidationMessagesToResponse) {
                    Iterator it = messages.iterator();
                    while (it.hasNext()) {
                        pw.write(LINE_SEPARATOR + (String)it.next());
                    }
                }
            }
            catch (Exception e1) {
                log.error("Exception while running HealthCheckValve", (Throwable)e1);
            }
        }
    }
}

