/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline.valve.impl;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.decoration.PageActionAccess;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.PageProfilerValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.portalsite.PortalSite;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageValveImpl
extends AbstractValve
implements PageProfilerValve {
    protected Logger log = LoggerFactory.getLogger(AbstractPageValveImpl.class);
    protected PortalSite portalSite;
    protected boolean requestFallback;
    protected boolean useHistory;
    protected PageLayoutComponent pageLayoutComponent;

    public AbstractPageValveImpl(PortalSite portalSite, PageLayoutComponent pageLayoutComponent, boolean requestFallback, boolean useHistory) {
        this.portalSite = portalSite;
        this.pageLayoutComponent = pageLayoutComponent;
        this.requestFallback = requestFallback;
        this.useHistory = useHistory;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            Subject requestSubject;
            String requestPath = (String)request.getAttribute("org.apache.jetspeed.Path");
            if (requestPath == null) {
                requestPath = request.getPath();
            }
            if (requestPath != null && requestPath.length() > 0) {
                if (!requestPath.startsWith("/")) {
                    requestPath = "/" + requestPath;
                }
            } else {
                requestPath = "/";
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Request path: " + requestPath);
            }
            if ((requestSubject = request.getSubject()) == null) {
                throw new ProfilerException("Missing subject for request: " + requestPath);
            }
            Principal requestUserPrincipal = SubjectHelper.getBestPrincipal((Subject)requestSubject, User.class);
            if (requestUserPrincipal == null) {
                throw new ProfilerException("Missing principal for request: " + requestPath);
            }
            this.setRequestPage(request, requestPath, requestUserPrincipal);
            ContentPage requestPage = request.getPage();
            if (requestPage != null) {
                request.setAttribute("org.apache.jetspeed.decoration.PageEditAccess", (Object)this.getPageActionAccess(request));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Page path: " + requestPage.getPath());
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("No page found for request path: " + requestPath);
            }
            if (context != null) {
                context.invokeNext(request);
            }
        }
        catch (SecurityException se) {
            if (this.requestFallback && request.getRequest().getUserPrincipal() == null && request.getPath() != null && !request.getPath().equals("/")) {
                try {
                    request.getResponse().sendRedirect(request.getRequest().getContextPath());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            this.log.error(se.getMessage(), (Throwable)se);
            try {
                request.getResponse().sendError(403, se.getMessage());
            }
            catch (IOException ioe) {
                this.log.error("Failed to invoke HttpServletReponse.sendError: " + ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (NodeNotFoundException nnfe) {
            this.log.error(nnfe.getMessage(), (Throwable)nnfe);
            try {
                request.getResponse().sendError(404, nnfe.getMessage());
            }
            catch (IOException ioe) {
                this.log.error("Failed to invoke HttpServletReponse.sendError: " + ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (Exception e) {
            this.log.error("Exception in request pipeline: " + e.getMessage(), (Throwable)e);
            throw new PipelineException(e.toString(), (Throwable)e);
        }
    }

    protected abstract void setRequestPage(RequestContext var1, String var2, Principal var3) throws NodeNotFoundException, ProfilerException;

    protected void setRequestPage(RequestContext request, String requestPath, PortalSiteRequestContext requestContext) throws NodeNotFoundException {
        request.setAttribute("org.apache.jetspeed.portalsite.PortalSiteRequestContext", (Object)requestContext);
        request.setAttribute("org.apache.jetspeed.profiledPageContext", (Object)requestContext);
        BaseFragmentsElement managedPageOrTemplate = requestContext.getManagedPageOrTemplate();
        PageTemplate managedPageTemplate = requestContext.getManagedPageTemplate();
        Map managedFragmentDefinitions = requestContext.getManagedFragmentDefinitions();
        ContentPage contentPage = this.pageLayoutComponent.newContentPage(managedPageOrTemplate, managedPageTemplate, managedFragmentDefinitions);
        request.setPage(contentPage);
        request.setProfileLocators(requestContext.getLocators());
        if (requestContext.isContentPage()) {
            request.setAttribute("org.apache.jetspeed.Path", (Object)requestPath);
            request.setAttribute("org.apache.jetspeed.ContentPath", (Object)requestContext.getPageContentPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PageActionAccess getPageActionAccess(RequestContext requestContext) {
        ContentPage page = requestContext.getPage();
        String key = page.getId();
        boolean loggedOn = requestContext.getRequest().getUserPrincipal() != null;
        boolean anonymous = !loggedOn;
        PageActionAccess pageActionAccess = null;
        HashMap<String, PageActionAccess> sessionActions = null;
        Object object = this;
        synchronized (object) {
            sessionActions = (HashMap<String, PageActionAccess>)requestContext.getSessionAttribute("org.apache.jetspeed.profiler.pageActionAccessMap");
            if (sessionActions == null) {
                sessionActions = new HashMap<String, PageActionAccess>();
                requestContext.setSessionAttribute("org.apache.jetspeed.profiler.pageActionAccessMap", sessionActions);
            } else {
                pageActionAccess = (PageActionAccess)sessionActions.get(key);
            }
        }
        object = sessionActions;
        synchronized (object) {
            if (pageActionAccess == null) {
                pageActionAccess = new PageActionAccess(anonymous, page);
                sessionActions.put(key, pageActionAccess);
            } else {
                pageActionAccess.checkReset(anonymous, page);
            }
        }
        return pageActionAccess;
    }
}

