/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline.valve.impl;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.JetspeedContentCache;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ActionValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestDiagnostics;
import org.apache.jetspeed.request.RequestDiagnosticsFactory;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionValveImpl
extends AbstractValve
implements ActionValve {
    private static final Logger log = LoggerFactory.getLogger(ActionValveImpl.class);
    private PortletContainer container;
    private boolean patchResponseCommitted = false;
    private JetspeedContentCache portletContentCache;

    public ActionValveImpl(PortletContainer container, JetspeedContentCache portletContentCache) {
        this.container = container;
        this.portletContentCache = portletContentCache;
    }

    public ActionValveImpl(PortletContainer container, JetspeedContentCache portletContentCache, boolean patchResponseCommitted) {
        this.container = container;
        this.portletContentCache = portletContentCache;
        this.patchResponseCommitted = patchResponseCommitted;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        boolean responseCommitted = false;
        boolean failure = false;
        try {
            org.apache.jetspeed.container.PortletWindow actionWindow = request.getActionWindow();
            if (actionWindow != null) {
                HttpServletRequest servletRequest = request.getRequest();
                HttpServletResponse serlvetResponse = request.getResponse();
                actionWindow.setAttribute("JETSPEED_ACTION", (Object)request);
                this.container.doAction((PortletWindow)actionWindow, servletRequest, serlvetResponse);
                this.clearPortletCacheForPage(request, actionWindow);
                responseCommitted = this.patchResponseCommitted ? true : serlvetResponse.isCommitted();
                request.setAttribute("pipeline", null);
            }
        }
        catch (IllegalStateException e) {
            log.error("Illegal State Exception. Response was written to in Action Phase", (Throwable)e);
            failure = true;
            responseCommitted = true;
        }
        catch (Throwable t) {
            failure = true;
            RequestDiagnostics rd = RequestDiagnosticsFactory.newRequestDiagnostics();
            RequestDiagnosticsFactory.fillInPortletWindow(rd, request.getActionWindow(), t);
            PipelineException pe = new PipelineException(t);
            pe.setRequestDiagnostics(rd);
            throw pe;
        }
        finally {
            if (responseCommitted) {
                log.info("Action processed and response committed (pipeline processing stopped)");
            } else if (!failure) {
                context.invokeNext(request);
            }
        }
    }

    protected void clearPortletCacheForPage(RequestContext request, org.apache.jetspeed.container.PortletWindow actionWindow) throws JetspeedException {
        ContentPage page = request.getPage();
        if (null == page) {
            throw new JetspeedException("Failed to find PSML Pin ContentPageAggregator.build");
        }
        ContentFragment root = page.getRootFragment();
        if (root == null) {
            throw new JetspeedException("No root ContentFragment found in ContentPage");
        }
        if (!this.isNonStandardAction(actionWindow)) {
            this.notifyFragments(root, request, page);
            String fragmentId = actionWindow.getWindowId();
            if (page.getFragmentById(fragmentId) == null) {
                this.clearTargetCache(fragmentId, request);
            }
        } else {
            ContentFragment fragment = page.getFragmentById(actionWindow.getWindowId());
            if (fragment != null) {
                this.clearTargetCache(fragment, request);
            } else {
                this.clearTargetCache(actionWindow.getId().toString(), request);
            }
        }
    }

    protected boolean isNonStandardAction(org.apache.jetspeed.container.PortletWindow actionWindow) {
        PortletDefinition portletDefinition = actionWindow.getPortletDefinition();
        Collection actionList = portletDefinition.getMetadata().getFields("nonStandardAction");
        return actionList != null && !actionList.isEmpty();
    }

    protected void notifyFragments(ContentFragment f, RequestContext context, ContentPage page) {
        ContentCacheKey cacheKey;
        if (f.getFragments() != null && f.getFragments().size() > 0) {
            for (Object child : f.getFragments()) {
                if ("hidden".equals(f.getState())) continue;
                this.notifyFragments((ContentFragment)child, context, page);
            }
        }
        if (this.portletContentCache.isKeyInCache((Object)(cacheKey = this.portletContentCache.createCacheKey(context, f.getId())))) {
            this.portletContentCache.remove((Object)cacheKey);
            this.portletContentCache.invalidate(context);
        }
    }

    protected void clearTargetCache(ContentFragment f, RequestContext context) {
        this.clearTargetCache(f.getId(), context);
    }

    protected void clearTargetCache(String fragmentId, RequestContext context) {
        ContentCacheKey cacheKey = this.portletContentCache.createCacheKey(context, fragmentId);
        if (this.portletContentCache.isKeyInCache((Object)cacheKey)) {
            this.portletContentCache.remove((Object)cacheKey);
            this.portletContentCache.invalidate(context);
        }
    }

    public String toString() {
        return "ActionValveImpl";
    }
}

