/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.pipeline.valve.impl;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Stack;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.CleanupValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupValveImpl
extends AbstractValve
implements CleanupValve {
    public static final String RENDER_STACK_ATTR = "org.apache.jetspeed.renderStack";
    private static final Logger log = LoggerFactory.getLogger(CleanupValveImpl.class);
    private PageManager pageManager;

    public CleanupValveImpl(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        HttpServletRequest httpRequest = request.getRequest();
        Stack renderStack = (Stack)httpRequest.getAttribute(RENDER_STACK_ATTR);
        String fragment = null;
        try {
            if (renderStack != null) {
                while (!renderStack.empty()) {
                    fragment = (String)renderStack.pop();
                    RequestDispatcher rd = httpRequest.getRequestDispatcher(fragment);
                    rd.include((ServletRequest)httpRequest, (ServletResponse)request.getResponse());
                }
            }
        }
        catch (Exception e) {
            log.error("CleanupValveImpl: failed while trying to render fragment " + fragment);
            log.error("CleanupValveImpl: Unable to complete all renderings", (Throwable)e);
        }
        try {
            this.pageManager.cleanupRequestCache();
        }
        catch (Exception e) {
            log.error("CleanupValveImpl: Unexpected exception caught", (Throwable)e);
        }
    }

    public String toString() {
        return "CleanupValveImpl";
    }

    public void dumpSession(RequestContext context) {
        try {
            int count = 0;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            Enumeration e = context.getRequest().getSession().getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object o = context.getSessionAttribute(name);
                this.serializeObject(name, o);
                out.writeObject(o);
                ++count;
            }
            out.close();
            log.info("Session object: " + count);
            log.info("Session footprint: " + bout.size());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void serializeObject(String name, Object o) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(o);
            out.close();
            log.info("o = " + name + ", " + o + ", size = " + bout.size());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

