/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.impl;

import java.security.Principal;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.portalsite.PortalSite;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.profiler.impl.ProfilerValveImpl;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshUserHomepageValveImpl
extends ProfilerValveImpl {
    private static final Logger log = LoggerFactory.getLogger(RefreshUserHomepageValveImpl.class);
    protected PageManager pageManager;
    protected UserManager userManager;
    protected String defaultTemplateFolder = "/_template/new-user/";
    protected boolean removeBeforeCopy;

    public RefreshUserHomepageValveImpl(Profiler profiler, PortalSite portalSite, PageLayoutComponent pageLayoutComponent, boolean requestFallback, boolean useHistoryPageManager, PageManager pageManager, UserManager userManager) {
        super(profiler, portalSite, pageLayoutComponent, requestFallback, useHistoryPageManager);
        this.pageManager = pageManager;
        this.userManager = userManager;
    }

    public void setDefaultTemplateFolder(String defaultTemplateFolder) {
        this.defaultTemplateFolder = defaultTemplateFolder;
    }

    public void setRemoveBeforeCopy(boolean removeBeforeCopy) {
        this.removeBeforeCopy = removeBeforeCopy;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        boolean userHomepagesUpdated = false;
        if ("true".equals(request.getRequest().getSession().getAttribute("org.apache.jetspeed.login.check"))) {
            try {
                userHomepagesUpdated = this.updateUserHomepagesByTemplate(request);
            }
            catch (Exception e) {
                log.error("Exception occurred during creating user folder.", (Throwable)e);
            }
        }
        if (userHomepagesUpdated) {
            super.invoke(request, context);
        } else {
            context.invokeNext(request);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateUserHomepagesByTemplate(RequestContext request) throws Exception {
        boolean userHomepagesUpdated = false;
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal == null) {
            throw new ProfilerException("Missing user principal for request: " + request.getPath());
        }
        User user = this.userManager.getUser(userPrincipal.getName());
        if (user == null) {
            throw new ProfilerException("Cannot retrieve user for " + userPrincipal.getName());
        }
        SecurityAttributes secAttrs = user.getSecurityAttributes();
        SecurityAttribute secAtttr = secAttrs.getAttribute("org.apache.jetspeed.profiler.refreshUserHomepage");
        if (secAtttr == null) return userHomepagesUpdated;
        if (!Boolean.parseBoolean(secAtttr.getStringValue())) return userHomepagesUpdated;
        try {
            SecurityAttribute secAttrTemplatePath;
            String templateFolder = (String)request.getAttribute("org.apache.jetspeed.profiler.userHomepageTemplate");
            if (templateFolder == null && (secAttrTemplatePath = secAttrs.getAttribute("org.apache.jetspeed.profiler.userHomepageTemplate")) != null && (templateFolder = secAttrTemplatePath.getStringValue()) != null && "".equals(templateFolder.trim())) {
                templateFolder = null;
            }
            if (templateFolder == null) {
                templateFolder = this.defaultTemplateFolder;
            }
            Folder source = this.pageManager.getFolder(templateFolder);
            String userName = user.getName();
            String userFolder = "/_user/" + userName;
            boolean found = true;
            Folder destFolder = null;
            try {
                destFolder = this.pageManager.getFolder(userFolder);
                if (this.removeBeforeCopy) {
                    this.pageManager.removeFolder(destFolder);
                    found = false;
                }
            }
            catch (FolderNotFoundException e) {
                found = false;
            }
            if (!found) {
                this.pageManager.deepCopyFolder(source, userFolder, userName);
            } else {
                this.pageManager.deepMergeFolder(source, userFolder, userName);
            }
            destFolder = this.pageManager.getFolder(userFolder);
            destFolder.setTitle(userName);
            destFolder.setShortTitle(userName);
            this.pageManager.updateFolder(destFolder);
            userHomepagesUpdated = true;
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            secAtttr.setStringValue("false");
            this.userManager.updateUser(user);
            throw throwable;
        }
        secAtttr.setStringValue("false");
        this.userManager.updateUser(user);
        return userHomepagesUpdated;
    }
}

