/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.resource;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.request.RequestDiagnostics;
import org.apache.jetspeed.request.RequestDiagnosticsFactory;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletWindow;

public class ResourceValveImpl
extends AbstractValve {
    private PortletContainer container;

    public ResourceValveImpl(PortletContainer container) {
        this.container = container;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        org.apache.jetspeed.container.PortletWindow resourceWindow = request.getPortalURL().getNavigationalState().getPortletWindowOfResource();
        if (resourceWindow != null) {
            try {
                HttpServletRequest servletRequest = request.getRequest();
                HttpServletResponse servletResponse = request.getResponse();
                resourceWindow.setAttribute("org.apache.jetspeed.portlet.container.invoker.useForward", (Object)Boolean.TRUE);
                if (resourceWindow.getPortletDefinition().getApplication().getVersion().equals("1.0")) {
                    this.container.doRender((PortletWindow)resourceWindow, servletRequest, servletResponse);
                }
                this.container.doServeResource((PortletWindow)resourceWindow, servletRequest, servletResponse);
            }
            catch (Exception e) {
                RequestDiagnostics rd = RequestDiagnosticsFactory.newRequestDiagnostics();
                RequestDiagnosticsFactory.fillInPortletWindow(rd, resourceWindow, e);
                PipelineException pe = new PipelineException((Throwable)e);
                pe.setRequestDiagnostics(rd);
                throw pe;
            }
        } else {
            context.invokeNext(request);
        }
    }

    public String toString() {
        return "ResourceValveImpl";
    }
}

