/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.login.LoginConstants;
import org.apache.jetspeed.pipeline.PipelineException;
import org.apache.jetspeed.pipeline.valve.AbstractValve;
import org.apache.jetspeed.pipeline.valve.LoginValidationValve;
import org.apache.jetspeed.pipeline.valve.ValveContext;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserCredential;
import org.apache.jetspeed.security.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginValidationValveImpl
extends AbstractValve
implements LoginValidationValve {
    private static final Logger log = LoggerFactory.getLogger(LoginValidationValveImpl.class);
    private int maxNumberOfAuthenticationFailures;
    private List sessionAttributes;

    public LoginValidationValveImpl(List sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public LoginValidationValveImpl(int maxNumberOfAuthenticationFailures) {
        this.maxNumberOfAuthenticationFailures = maxNumberOfAuthenticationFailures;
        this.sessionAttributes = new LinkedList();
    }

    public LoginValidationValveImpl(int maxNumberOfAuthenticationFailures, List sessionAttributes) {
        this.maxNumberOfAuthenticationFailures = maxNumberOfAuthenticationFailures;
        this.sessionAttributes = sessionAttributes;
    }

    public void invoke(RequestContext request, ValveContext context) throws PipelineException {
        try {
            block15: {
                if (request.getRequest().getUserPrincipal() == null) {
                    if (request.getSessionAttribute("org.apache.jetspeed.login.retrycount") != null) {
                        String userName = (String)request.getSessionAttribute("org.apache.jetspeed.login.username");
                        if (userName != null && !userName.equals("")) {
                            UserManager um = (UserManager)Jetspeed.getComponentManager().getComponent(UserManager.class);
                            if (um != null) {
                                User user = null;
                                try {
                                    user = um.getUser(userName);
                                    if (!user.isEnabled()) {
                                        request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_USER_DISABLED);
                                        break block15;
                                    }
                                    UserCredential userCredential = SubjectHelper.getUserCredential((Subject)um.getSubject(user));
                                    if (userCredential == null || !userCredential.isEnabled()) {
                                        request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_CREDENTIAL_DISABLED);
                                        break block15;
                                    }
                                    if (userCredential.isExpired()) {
                                        request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_CREDENTIAL_EXPIRED);
                                        break block15;
                                    }
                                    if (this.maxNumberOfAuthenticationFailures > 1 && userCredential.getAuthenticationFailures() == this.maxNumberOfAuthenticationFailures - 1) {
                                        request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_FINAL_LOGIN_ATTEMPT);
                                        break block15;
                                    }
                                    request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_INVALID_PASSWORD);
                                }
                                catch (SecurityException sex) {
                                    request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_UNKNOWN_USER);
                                }
                            }
                        } else {
                            request.setSessionAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_UNKNOWN_USER);
                        }
                    }
                } else if (request.getSessionAttribute("org.apache.jetspeed.login.check") == null) {
                    this.clearSessionAttributes(request);
                    request.getRequest().getSession().setAttribute("org.apache.jetspeed.login.check", (Object)"true");
                }
            }
            context.invokeNext(request);
        }
        catch (Exception e) {
            log.error("Exception in request pipeline: " + e.getMessage(), (Throwable)e);
            throw new PipelineException(e.toString(), (Throwable)e);
        }
    }

    private void clearSessionAttributes(RequestContext request) {
        for (String attribute : this.sessionAttributes) {
            request.getRequest().getSession().removeAttribute(attribute);
        }
    }

    public String toString() {
        return "LoginValidationValve";
    }
}

