/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.jetspeed.administration.PortalAuthenticationConfiguration;
import org.apache.jetspeed.pipeline.valve.SecurityValve;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.JetspeedSubjectFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.jetspeed.security.impl.AbstractSecurityValve;
import org.apache.jetspeed.statistics.PortalStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityValveImpl
extends AbstractSecurityValve
implements SecurityValve {
    private static Logger log = LoggerFactory.getLogger(SecurityValveImpl.class);
    private UserManager userMgr;
    private PortalStatistics statistics;

    public SecurityValveImpl(Profiler profiler, UserManager userMgr, PortalStatistics statistics, PortalAuthenticationConfiguration authenticationConfiguration) {
        this.userMgr = userMgr;
        this.statistics = statistics;
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public SecurityValveImpl(Profiler profiler, UserManager userMgr, PortalStatistics statistics) {
        this.userMgr = userMgr;
        this.statistics = statistics;
    }

    public SecurityValveImpl(Profiler profiler, UserManager userMgr) {
        this.userMgr = userMgr;
        this.statistics = null;
    }

    public String toString() {
        return "SecurityValve";
    }

    protected final Subject getSubject(RequestContext request) throws Exception {
        Principal subjectUserPrincipal;
        Principal userPrincipal = this.getUserPrincipal(request);
        Subject subject = this.getSubjectFromSession(request);
        if (!(subject == null || (subjectUserPrincipal = SubjectHelper.getPrincipal((Subject)subject, User.class)) != null && subjectUserPrincipal.getName().equals(userPrincipal.getName()))) {
            subject = null;
        }
        if (subject == null) {
            subject = this.resolveSubjectFromContext(request, userPrincipal);
        }
        if (subject == null) {
            try {
                User user = this.userMgr.getUser(userPrincipal.getName());
                if (user != null) {
                    subject = this.userMgr.getSubject(user);
                }
            }
            catch (SecurityException sex) {
                if (userPrincipal.getName().equals(this.userMgr.getAnonymousUser())) {
                    throw sex;
                }
                log.error("Unknown user Principal " + userPrincipal.getName() + ": creating a default subject without any roles", (Throwable)sex);
                subject = JetspeedSubjectFactory.createSubject((User)this.userMgr.newTransientUser(userPrincipal.getName()), null, null, null);
            }
        }
        if (this.statistics != null && request.getSessionAttribute(IP_ADDRESS) == null) {
            this.statistics.logUserLogin(request, 0L);
            request.setSessionAttribute(IP_ADDRESS, (Object)request.getRequest().getRemoteAddr());
        }
        return subject;
    }

    protected Principal getUserPrincipal(RequestContext request) throws Exception {
        Principal userPrincipal = request.getRequest().getUserPrincipal();
        if (userPrincipal == null) {
            userPrincipal = this.userMgr.newTransientUser(this.userMgr.getAnonymousUser());
        }
        return userPrincipal;
    }

    protected Subject resolveSubjectFromContext(RequestContext request, Principal userPrincipal) {
        if (userPrincipal.getName().equals(this.userMgr.getAnonymousUser())) {
            return null;
        }
        if (userPrincipal instanceof UserSubjectPrincipal) {
            return ((UserSubjectPrincipal)userPrincipal).getSubject();
        }
        return this.resolveSubjectFromContainerPrincipal(request, userPrincipal);
    }

    protected Subject resolveSubjectFromContainerPrincipal(RequestContext request, Principal userPrincipal) {
        return null;
    }
}

