/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl.shibboleth;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalAuthenticationConfiguration;
import org.apache.jetspeed.audit.AuditActivity;
import org.apache.jetspeed.cache.UserContentCacheManager;
import org.apache.jetspeed.components.ComponentManager;
import org.apache.jetspeed.container.session.PortalSessionValidationFilter;
import org.apache.jetspeed.login.LoginConstants;
import org.apache.jetspeed.login.filter.PortalRequestWrapper;
import org.apache.jetspeed.security.AuthenticationProvider;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.jetspeed.security.impl.shibboleth.ShibbolethConfiguration;

public class ShibbolethPortalFilter
implements Filter {
    protected String userNameHeader;
    protected Object sem = new Object();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sRequest, ServletResponse sResponse, FilterChain filterChain) throws IOException, ServletException {
        ComponentManager cm = Jetspeed.getComponentManager();
        AuthenticationProvider authProvider = (AuthenticationProvider)cm.getComponent((Object)"org.apache.jetspeed.security.AuthenticationProvider");
        if (sRequest instanceof HttpServletRequest) {
            Subject subject;
            String username;
            HttpServletRequest request = (HttpServletRequest)sRequest;
            HttpSession httpSession = PortalSessionValidationFilter.getValidSession(request);
            if (this.userNameHeader == null) {
                Object object = this.sem;
                synchronized (object) {
                    ShibbolethConfiguration config = (ShibbolethConfiguration)cm.getComponent((Object)"org.apache.jetspeed.security.shibboleth.ShibbolethConfiguration");
                    this.userNameHeader = config.getHeaderMapping().get("username");
                }
            }
            if ((username = request.getHeader(this.userNameHeader)) != null) {
                Principal principal;
                subject = (Subject)request.getSession().getAttribute("org.apache.jetspeed.security.subject");
                if (subject != null && (principal = SubjectHelper.getPrincipal((Subject)subject, UserSubjectPrincipal.class)) != null && principal.getName().equals(username)) {
                    sRequest = this.wrapperRequest(request, subject, principal);
                    if (filterChain != null) {
                        filterChain.doFilter(sRequest, sResponse);
                        return;
                    }
                }
                UserManager userManager = (UserManager)cm.getComponent((Object)"org.apache.jetspeed.security.UserManager");
                AuditActivity audit = (AuditActivity)cm.getComponent((Object)"org.apache.jetspeed.audit.AuditActivity");
                ShibbolethConfiguration config = (ShibbolethConfiguration)cm.getComponent((Object)"org.apache.jetspeed.security.shibboleth.ShibbolethConfiguration");
                boolean success = false;
                if (config.isAuthenticate()) {
                    try {
                        authProvider.authenticate(username, username);
                        success = true;
                    }
                    catch (SecurityException e) {
                        throw new ServletException();
                    }
                }
                try {
                    User user = userManager.getUser(username);
                    if (user != null) {
                        subject = userManager.getSubject(user);
                    }
                    success = true;
                }
                catch (SecurityException sex) {
                    success = false;
                }
                if (success) {
                    audit.logUserActivity(username, request.getRemoteAddr(), "login-success", "ShibbolethFilter");
                    PortalAuthenticationConfiguration authenticationConfiguration = (PortalAuthenticationConfiguration)cm.getComponent((Object)"org.apache.jetspeed.administration.PortalAuthenticationConfiguration");
                    if (authenticationConfiguration.isCreateNewSessionOnLogin() && httpSession != null && !httpSession.isNew()) {
                        request.getSession().invalidate();
                    } else {
                        UserContentCacheManager userContentCacheManager = (UserContentCacheManager)cm.getComponent((Object)"userContentCacheManager");
                        userContentCacheManager.evictUserContentCache(username, request.getSession().getId());
                    }
                    subject = null;
                    try {
                        User user = userManager.getUser(username);
                        if (user != null) {
                            subject = userManager.getSubject(user);
                        }
                    }
                    catch (SecurityException sex) {
                        // empty catch block
                    }
                    Principal principal2 = SubjectHelper.getPrincipal((Subject)subject, User.class);
                    sRequest = this.wrapperRequest(request, subject, principal2);
                    request.getSession().removeAttribute("org.apache.jetspeed.login.errorcode");
                    HttpSession session = request.getSession(true);
                    session.setAttribute("org.apache.jetspeed.security.subject", (Object)subject);
                } else {
                    audit.logUserActivity(username, request.getRemoteAddr(), "login-failure", "ShibbolethFilter");
                    request.getSession().setAttribute("org.apache.jetspeed.login.errorcode", (Object)LoginConstants.ERROR_INVALID_PASSWORD);
                }
            } else {
                subject = (Subject)request.getSession().getAttribute("org.apache.jetspeed.security.subject");
                if (subject != null) {
                    Principal principal = SubjectHelper.getPrincipal((Subject)subject, User.class);
                    ShibbolethConfiguration config = (ShibbolethConfiguration)Jetspeed.getComponentManager().getComponent((Object)"org.apache.jetspeed.security.shibboleth.ShibbolethConfiguration");
                    if (principal == null || !principal.getName().equals(config.getGuestUser())) {
                        sRequest = this.wrapperRequest(request, subject, principal);
                    }
                }
            }
            sRequest.setAttribute("org.apache.jetspeed.login.filter.PortalFilter", (Object)"true");
        }
        if (filterChain != null) {
            filterChain.doFilter(sRequest, sResponse);
        }
    }

    private ServletRequest wrapperRequest(HttpServletRequest request, Subject subject, Principal principal) {
        PortalRequestWrapper wrapper = new PortalRequestWrapper(request, subject, principal);
        return wrapper;
    }

    public void destroy() {
    }
}

