/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.jetspeed.om.portlet.ContainerRuntimeOption;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.services.beans.ContainerRuntimeOptionBean;
import org.apache.jetspeed.services.beans.DescriptionBean;
import org.apache.jetspeed.services.beans.DisplayNameBean;
import org.apache.jetspeed.services.beans.GenericMetadataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="application")
public class PortletApplicationBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String contextPath;
    private String localContextPath;
    private String defaultNamespace;
    private int applicationType;
    private long checksum;
    private long revision;
    private Collection<DisplayNameBean> displayNameBeans;
    private Collection<DescriptionBean> descriptionBeans;
    private GenericMetadataBean metadataBean;
    private Collection<ContainerRuntimeOptionBean> containerRuntimeOptionBeans;

    public PortletApplicationBean() {
    }

    public PortletApplicationBean(PortletApplication portletApplication) {
        this.name = portletApplication.getName();
        this.contextPath = portletApplication.getContextPath();
        this.localContextPath = portletApplication.getLocalContextPath();
        this.defaultNamespace = portletApplication.getDefaultNamespace();
        this.applicationType = portletApplication.getApplicationType();
        this.checksum = portletApplication.getChecksum();
        this.revision = portletApplication.getRevision();
        ArrayList<DisplayNameBean> displayNameBeanList = new ArrayList<DisplayNameBean>();
        for (DisplayName displayName : portletApplication.getDisplayNames()) {
            displayNameBeanList.add(new DisplayNameBean(displayName));
        }
        this.displayNameBeans = displayNameBeanList;
        ArrayList<DescriptionBean> descriptionBeanList = new ArrayList<DescriptionBean>();
        for (Description description : portletApplication.getDescriptions()) {
            descriptionBeanList.add(new DescriptionBean(description));
        }
        this.descriptionBeans = descriptionBeanList;
        this.metadataBean = new GenericMetadataBean(portletApplication.getMetadata());
        ArrayList<ContainerRuntimeOptionBean> containerRuntimeOptionBeanList = new ArrayList<ContainerRuntimeOptionBean>();
        for (ContainerRuntimeOption containerRuntimeOption : portletApplication.getContainerRuntimeOptions()) {
            containerRuntimeOptionBeanList.add(new ContainerRuntimeOptionBean(containerRuntimeOption));
        }
        this.containerRuntimeOptionBeans = containerRuntimeOptionBeanList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getLocalContextPath() {
        return this.localContextPath;
    }

    public void setLocalContextPath(String localContextPath) {
        this.localContextPath = localContextPath;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public int getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(int applicationType) {
        this.applicationType = applicationType;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    @XmlElementWrapper(name="displayNames")
    @XmlElements(value={@XmlElement(name="displayName")})
    public Collection<DisplayNameBean> getDisplayNameBeans() {
        return this.displayNameBeans;
    }

    public void setDisplayNameBeans(Collection<DisplayNameBean> displayNameBeans) {
        this.displayNameBeans = displayNameBeans;
    }

    @XmlElementWrapper(name="descriptions")
    @XmlElements(value={@XmlElement(name="description")})
    public Collection<DescriptionBean> getDescriptionBeans() {
        return this.descriptionBeans;
    }

    public void setDescriptionBeans(Collection<DescriptionBean> descriptionBeans) {
        this.descriptionBeans = descriptionBeans;
    }

    @XmlElement(name="metadata")
    public GenericMetadataBean getMetadataBean() {
        return this.metadataBean;
    }

    public void setMetadataBean(GenericMetadataBean metadataBean) {
        this.metadataBean = metadataBean;
    }

    @XmlElementWrapper(name="containerRuntimeOptions")
    @XmlElements(value={@XmlElement(name="containerRuntimeOption")})
    public Collection<ContainerRuntimeOptionBean> getContainerRuntimeOptionBeans() {
        return this.containerRuntimeOptionBeans;
    }

    public void setContainerRuntimeOptionBeans(Collection<ContainerRuntimeOptionBean> containerRuntimeOptionBeans) {
        this.containerRuntimeOptionBeans = containerRuntimeOptionBeans;
    }
}

