/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.jetspeed.om.portlet.ContainerRuntimeOption;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.services.beans.ContainerRuntimeOptionBean;
import org.apache.jetspeed.services.beans.DescriptionBean;
import org.apache.jetspeed.services.beans.DisplayNameBean;
import org.apache.jetspeed.services.beans.GenericMetadataBean;
import org.apache.jetspeed.services.beans.InitParamBean;
import org.apache.jetspeed.services.beans.LanguageBean;
import org.apache.jetspeed.services.beans.PortletInfoBean;
import org.apache.jetspeed.services.beans.SupportsBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="definition")
public class PortletDefinitionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String applicationName;
    private String applicationContextPath;
    private String portletName;
    private String uniqueName;
    private String portletIcon;
    private String portletIconHolder;
    private String portletIconBasePath;
    private PortletInfoBean portletInfoBean;
    private Collection<DisplayNameBean> displayNameBeans;
    private Collection<DescriptionBean> descriptionBeans;
    private Collection<SupportsBean> supportsBeans;
    private Collection<LanguageBean> languageBeans;
    private GenericMetadataBean metadataBean;
    private Collection<ContainerRuntimeOptionBean> containerRuntimeOptionBeans;
    private Collection<InitParamBean> initParamBeans;

    public PortletDefinitionBean() {
    }

    public PortletDefinitionBean(PortletDefinition portletDefinition) {
        PortletApplication portletApplication = portletDefinition.getApplication();
        this.applicationName = portletApplication.getName();
        this.applicationContextPath = portletApplication.getContextPath();
        this.portletName = portletDefinition.getPortletName();
        this.uniqueName = portletDefinition.getUniqueName();
        this.portletInfoBean = new PortletInfoBean(portletDefinition.getPortletInfo());
        ArrayList<DisplayNameBean> displayNameBeanList = new ArrayList<DisplayNameBean>();
        for (DisplayName displayName : portletDefinition.getDisplayNames()) {
            displayNameBeanList.add(new DisplayNameBean(displayName));
        }
        this.displayNameBeans = displayNameBeanList;
        ArrayList<DescriptionBean> descriptionBeanList = new ArrayList<DescriptionBean>();
        for (Description description : portletDefinition.getDescriptions()) {
            descriptionBeanList.add(new DescriptionBean(description));
        }
        this.descriptionBeans = descriptionBeanList;
        ArrayList<SupportsBean> supportsBeanList = new ArrayList<SupportsBean>();
        for (Supports supports : portletDefinition.getSupports()) {
            supportsBeanList.add(new SupportsBean(supports));
        }
        this.supportsBeans = supportsBeanList;
        ArrayList<LanguageBean> languageBeanList = new ArrayList<LanguageBean>();
        for (Language language : portletDefinition.getLanguages()) {
            languageBeanList.add(new LanguageBean(language));
        }
        this.languageBeans = languageBeanList;
        this.metadataBean = new GenericMetadataBean(portletDefinition.getMetadata());
        ArrayList<ContainerRuntimeOptionBean> containerRuntimeOptionBeanList = new ArrayList<ContainerRuntimeOptionBean>();
        for (ContainerRuntimeOption containerRuntimeOption : portletDefinition.getContainerRuntimeOptions()) {
            containerRuntimeOptionBeanList.add(new ContainerRuntimeOptionBean(containerRuntimeOption));
        }
        this.containerRuntimeOptionBeans = containerRuntimeOptionBeanList;
        ArrayList<InitParamBean> initParamBeanList = new ArrayList<InitParamBean>();
        for (InitParam initParam : portletDefinition.getInitParams()) {
            initParamBeanList.add(new InitParamBean(initParam));
            if (!"portlet-icon".equals(initParam.getParamName())) continue;
            this.portletIcon = initParam.getParamValue();
        }
        if (this.portletIcon != null) {
            GenericMetadata appMetadata = portletApplication.getMetadata();
            Collection fields = appMetadata.getFields("portlet.icon.holder");
            if (fields != null && !fields.isEmpty()) {
                this.portletIconHolder = ((LocalizedField)fields.iterator().next()).getValue();
            }
            if ((fields = appMetadata.getFields("portlet.icon.base.path")) != null && !fields.isEmpty()) {
                this.portletIconBasePath = ((LocalizedField)fields.iterator().next()).getValue();
            }
        }
        this.initParamBeans = initParamBeanList;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    public void setApplicationContextPath(String applicationContextPath) {
        this.applicationContextPath = applicationContextPath;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public String getPortletIcon() {
        return this.portletIcon;
    }

    public void setPortletIcon(String portletIcon) {
        this.portletIcon = portletIcon;
    }

    public String getPortletIconHolder() {
        return this.portletIconHolder;
    }

    public void setPortletIconHolder(String portletIconHolder) {
        this.portletIconHolder = portletIconHolder;
    }

    public String getPortletIconBasePath() {
        return this.portletIconBasePath;
    }

    public void setPortletIconBasePath(String portletIconBasePath) {
        this.portletIconBasePath = portletIconBasePath;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    @XmlElement(name="portletInfo")
    public PortletInfoBean getPortletInfoBean() {
        return this.portletInfoBean;
    }

    public void setPortletInfoBean(PortletInfoBean portletInfoBean) {
        this.portletInfoBean = portletInfoBean;
    }

    @XmlElementWrapper(name="displayNames")
    @XmlElements(value={@XmlElement(name="displayName")})
    public Collection<DisplayNameBean> getDisplayNameBeans() {
        return this.displayNameBeans;
    }

    public void setDisplayNameBeans(Collection<DisplayNameBean> displayNameBeans) {
        this.displayNameBeans = displayNameBeans;
    }

    @XmlElementWrapper(name="descriptions")
    @XmlElements(value={@XmlElement(name="description")})
    public Collection<DescriptionBean> getDescriptionBeans() {
        return this.descriptionBeans;
    }

    public void setDescriptionBeans(Collection<DescriptionBean> descriptionBeans) {
        this.descriptionBeans = descriptionBeans;
    }

    @XmlElementWrapper(name="supports")
    @XmlElements(value={@XmlElement(name="support")})
    public Collection<SupportsBean> getSupportsBeans() {
        return this.supportsBeans;
    }

    public void setSupportsBeans(Collection<SupportsBean> supportsBeans) {
        this.supportsBeans = supportsBeans;
    }

    @XmlElementWrapper(name="languages")
    @XmlElements(value={@XmlElement(name="language")})
    public Collection<LanguageBean> getLanguageBeans() {
        return this.languageBeans;
    }

    public void setLanguageBeans(Collection<LanguageBean> languageBeans) {
        this.languageBeans = languageBeans;
    }

    @XmlElement(name="metadata")
    public GenericMetadataBean getMetadataBean() {
        return this.metadataBean;
    }

    public void setMetadataBean(GenericMetadataBean metadataBean) {
        this.metadataBean = metadataBean;
    }

    @XmlElementWrapper(name="containerRuntimeOptions")
    @XmlElements(value={@XmlElement(name="containerRuntimeOption")})
    public Collection<ContainerRuntimeOptionBean> getContainerRuntimeOptionBeans() {
        return this.containerRuntimeOptionBeans;
    }

    public void setContainerRuntimeOptionBeans(Collection<ContainerRuntimeOptionBean> containerRuntimeOptionBeans) {
        this.containerRuntimeOptionBeans = containerRuntimeOptionBeans;
    }

    @XmlElementWrapper(name="initParams")
    @XmlElements(value={@XmlElement(name="initParam")})
    public Collection<InitParamBean> getInitParamBeans() {
        return this.initParamBeans;
    }

    public void setInitParamBeans(Collection<InitParamBean> initParamBeans) {
        this.initParamBeans = initParamBeans;
    }
}

