/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalResultList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="data")
public class UserDataTableBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long recordsReturned = 5L;
    private long totalRecords;
    private long startIndex = 5L;
    private String sort = "userName";
    private String dir = "asc";
    private long pageSize = 5L;
    private List<HashMap<String, String>> records = null;

    public UserDataTableBean() {
    }

    public UserDataTableBean(JetspeedPrincipalResultList resultList) {
        this.totalRecords = resultList.getTotalSize();
        this.records = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> record = null;
        for (JetspeedPrincipal p : resultList.getResults()) {
            record = new HashMap<String, String>();
            record.put("userName", p.getName());
            record.put("firstName", p.getInfoMap().get("user.name.given") == null ? "" : (String)p.getInfoMap().get("user.name.given"));
            record.put("lastName", p.getInfoMap().get("user.name.family") == null ? "" : (String)p.getInfoMap().get("user.name.family"));
            this.records.add(record);
        }
    }

    public long getRecordsReturned() {
        return this.recordsReturned;
    }

    public void setRecordsReturned(long recordsReturned) {
        this.recordsReturned = recordsReturned;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(long startIndex) {
        this.startIndex = startIndex;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public List<HashMap<String, String>> getRecords() {
        return this.records;
    }

    public void setRecords(List<HashMap<String, String>> records) {
        this.records = records;
    }
}

