/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.rest;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.page.BasePageElement;
import org.apache.jetspeed.om.page.Document;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.services.beans.FolderBean;
import org.apache.jetspeed.services.beans.LinkBean;
import org.apache.jetspeed.services.beans.NodeBean;
import org.apache.jetspeed.services.beans.PageBean;
import org.apache.jetspeed.services.rest.util.PathSegmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/pagemanagement/")
public class PageManagementService {
    private static Logger log = LoggerFactory.getLogger(PageManagementService.class);
    @Context
    private ServletConfig servletConfig;
    @Context
    private ServletContext servletContext;
    private PageManager pageManager;

    public PageManagementService(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @GET
    @Path(value="/{type}/{path:.*}")
    public NodeBean getNode(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="path") List<PathSegment> pathSegments) {
        String path = PathSegmentUtils.joinWithPrefix(pathSegments, "/", "/");
        try {
            if (".psml".equals(type)) {
                Page page = this.pageManager.getPage(path);
                page.checkAccess(JetspeedActions.EDIT);
                return new PageBean(page);
            }
            if (".link".equals(type)) {
                Link link = this.getLink(path);
                link.checkAccess(JetspeedActions.EDIT);
                return new LinkBean(link);
            }
            if ("folder".equals(type)) {
                Folder folder = this.pageManager.getFolder(path);
                folder.checkAccess(JetspeedActions.EDIT);
                return new FolderBean(folder);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (DocumentNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (FolderNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (NodeException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
    }

    @DELETE
    @Path(value="/{type}/{path:.*}")
    public NodeBean deleteNode(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="path") List<PathSegment> pathSegments) {
        String path = PathSegmentUtils.joinWithPrefix(pathSegments, "/", "/");
        try {
            if (".psml".equals(type)) {
                Page page = this.pageManager.getPage(path);
                this.pageManager.removePage(page);
                return new PageBean(page);
            }
            if (".link".equals(type)) {
                Link link = this.getLink(path);
                this.pageManager.removeLink(link);
                return new LinkBean(link);
            }
            if ("folder".equals(type)) {
                Folder folder = this.pageManager.getFolder(path);
                this.pageManager.removeFolder(folder);
                return new FolderBean(folder);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (DocumentNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (FolderNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (NodeException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
    }

    @POST
    @Path(value="/copy/{type}/{sourcePath:.*}")
    public NodeBean copyNode(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="sourcePath") List<PathSegment> sourcePathSegments, @FormParam(value="target") String targetPath, @FormParam(value="deep") boolean deepCopy, @FormParam(value="merge") boolean merging, @FormParam(value="owner") String owner, @FormParam(value="copyids") boolean copyIds) {
        String sourcePath = PathSegmentUtils.joinWithPrefix(sourcePathSegments, "/", "/");
        try {
            if (".psml".equals(type)) {
                Page source = this.pageManager.getPage(sourcePath);
                Page target = this.pageManager.copyPage(source, targetPath);
                this.pageManager.updatePage(target);
                return new PageBean(target);
            }
            if (".link".equals(type)) {
                Link source = this.getLink(sourcePath);
                Link target = this.pageManager.copyLink(source, targetPath);
                this.pageManager.updateLink(target);
                return new LinkBean(target);
            }
            if ("folder".equals(type)) {
                Folder source = this.pageManager.getFolder(sourcePath);
                if (deepCopy) {
                    if (merging) {
                        this.pageManager.deepMergeFolder(source, targetPath, owner, copyIds);
                    } else {
                        this.pageManager.deepCopyFolder(source, targetPath, owner, copyIds);
                    }
                    Folder target = this.pageManager.getFolder(targetPath);
                    return new FolderBean(target);
                }
                Folder target = this.pageManager.copyFolder(source, targetPath);
                this.pageManager.updateFolder(target, true);
                return new FolderBean(target);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (DocumentNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (FolderNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (NodeException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
    }

    @POST
    @Path(value="/move/{type}/{sourcePath:.*}")
    public NodeBean moveNode(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="sourcePath") List<PathSegment> sourcePathSegments, @FormParam(value="target") String targetPath, @FormParam(value="deep") boolean deepCopy, @FormParam(value="merge") boolean merging, @FormParam(value="owner") String owner, @FormParam(value="copyids") boolean copyIds) {
        NodeBean nodeBean = this.copyNode(servletRequest, uriInfo, type, sourcePathSegments, targetPath, deepCopy, merging, owner, copyIds);
        this.deleteNode(servletRequest, uriInfo, type, sourcePathSegments);
        return nodeBean;
    }

    @POST
    @Path(value="/info/{type}/{path:.*}")
    public NodeBean updateNodeInfo(@Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="path") List<PathSegment> pathSegments, @FormParam(value="title") String title, @FormParam(value="shorttitle") String shortTitle, @FormParam(value="hidden") String hidden, @FormParam(value="skin") String skin, @FormParam(value="version") String version, @FormParam(value="docorder") String documentOrder, @FormParam(value="url") String url) {
        RequestContext requestContext = (RequestContext)servletRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
        String path = PathSegmentUtils.joinWithPrefix(pathSegments, "/", "/");
        try {
            boolean hiddenFlag;
            Page node = null;
            if (".psml".equals(type)) {
                node = this.pageManager.getPage(path);
            } else if (".link".equals(type)) {
                node = this.getLink(path);
            } else if ("folder".equals(type)) {
                node = this.pageManager.getFolder(path);
            } else {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            node.checkAccess(JetspeedActions.EDIT);
            boolean changed = false;
            Locale locale = requestContext.getLocale();
            GenericMetadata metadata = node.getMetadata();
            if (title != null && !title.equals(node.getTitle())) {
                node.setTitle(title);
                this.setLocalizedField(metadata, locale, "title", title);
                changed = true;
            }
            if (shortTitle != null && !shortTitle.equals(node.getShortTitle())) {
                node.setShortTitle(shortTitle);
                this.setLocalizedField(metadata, locale, "short-title", title);
                changed = true;
            }
            if (hidden != null && (hiddenFlag = BooleanUtils.toBoolean((String)hidden)) != node.isHidden()) {
                node.setHidden(hiddenFlag);
                changed = true;
            }
            if (skin != null) {
                if (node instanceof BasePageElement) {
                    if (!skin.equals(((BasePageElement)node).getSkin())) {
                        ((BasePageElement)node).setSkin(skin);
                        changed = true;
                    }
                } else if (node instanceof Link) {
                    if (!skin.equals(((Link)node).getSkin())) {
                        ((Link)node).setSkin(skin);
                        changed = true;
                    }
                } else if (node instanceof Folder && !skin.equals(((Folder)node).getSkin())) {
                    ((Folder)node).setSkin(skin);
                    changed = true;
                }
            }
            if (version != null && node instanceof Document && !version.equals(((Document)node).getVersion())) {
                ((Document)node).setVersion(version);
                changed = true;
            }
            if (documentOrder != null && node instanceof Folder) {
                String[] docIndexArray = StringUtils.split((String)documentOrder, (String)",\r\n");
                for (int i = 0; i < docIndexArray.length; ++i) {
                    docIndexArray[i] = docIndexArray[i].trim();
                }
                ((Folder)node).setDocumentOrder(Arrays.asList(docIndexArray));
                changed = true;
            }
            if (url != null && node instanceof Link && !url.equals(((Link)node).getUrl())) {
                ((Link)node).setUrl(url);
                changed = true;
            }
            if (changed) {
                if (node instanceof Page) {
                    this.pageManager.updatePage(node);
                } else if (node instanceof Link) {
                    this.pageManager.updateLink((Link)node);
                } else if (node instanceof Folder) {
                    this.pageManager.updateFolder((Folder)node);
                }
            }
            if (".psml".equals(type)) {
                return new PageBean(node);
            }
            if (".link".equals(type)) {
                return new LinkBean((Link)node);
            }
            if ("folder".equals(type)) {
                return new FolderBean((Folder)node);
            }
            return null;
        }
        catch (DocumentNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (FolderNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (NodeException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
    }

    private LocalizedField getLocalizedField(GenericMetadata metadata, Locale locale, String name) {
        Collection fields = metadata.getFields(name);
        if (fields != null) {
            for (LocalizedField field : fields) {
                if (!locale.equals(field.getLocale())) continue;
                return field;
            }
        }
        return null;
    }

    private void setLocalizedField(GenericMetadata metadata, Locale locale, String name, String value) {
        LocalizedField field = this.getLocalizedField(metadata, locale, name);
        if (field != null) {
            field.setValue(value);
        } else {
            metadata.addField(locale, name, value);
        }
    }

    private Link getLink(String path) throws FolderNotFoundException, InvalidFolderException, NodeException, DocumentNotFoundException {
        String folderPath = null;
        String name = null;
        int offset = path.lastIndexOf(47);
        if (offset != -1) {
            folderPath = path.substring(0, offset);
            name = path.substring(offset + 1);
        }
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("Invalid link path: " + path);
        }
        if (StringUtils.isEmpty((String)folderPath)) {
            folderPath = "/";
        }
        Folder folder = this.pageManager.getFolder(folderPath);
        Link link = this.pageManager.getLink(folder, name);
        return link;
    }
}

