/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.spaces;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.spaces.BaseSpaceImpl;
import org.apache.jetspeed.spaces.Space;
import org.apache.jetspeed.spaces.SpacesServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceImpl
extends BaseSpaceImpl
implements Space,
Serializable {
    private static final long serialVersionUID = 1L;

    public SpaceImpl(Folder folder) {
        this.backingFolder = folder;
    }

    @Override
    protected String getOwnerFieldName() {
        return "space-owner";
    }

    public void setTheme(String themeName) {
        this.backingFolder.setDefaultDecorator(themeName, "layout");
        this.backingFolder.setDefaultDecorator(themeName, "portlet");
    }

    public String getTheme() {
        return this.backingFolder.getDefaultDecorator("layout");
    }

    public String getDomainPath() {
        return SpacesServiceImpl.retrieveField(this.backingFolder, Locale.ENGLISH, "space-domain-path");
    }

    public void setDomainPath(String domainPath) {
        SpacesServiceImpl.updateField(this.backingFolder, Locale.ENGLISH, "space-domain-path", domainPath);
    }

    public String getImage() {
        return SpacesServiceImpl.retrieveField(this.backingFolder, Locale.ENGLISH, "space-image");
    }

    public void setImage(String pathToImage) {
        SpacesServiceImpl.updateField(this.backingFolder, Locale.ENGLISH, "space-domain-path", pathToImage);
    }

    public String getDashboard() {
        String name = this.backingFolder.getDefaultPage();
        if (name == null) {
            name = "default-page.psml";
        }
        return name;
    }

    public void setDashboard(String dashboard) {
        this.backingFolder.setDefaultPage(dashboard);
    }

    public void addSecuredGroup(String group) {
    }

    public void addSecuredRole(String role) {
    }

    public void addSecuredUser(String user) {
    }

    public List<String> getSecuredGroup() {
        return null;
    }

    public List<String> getSecuredRoles() {
        return null;
    }

    public List<String> getSecuredUsers() {
        return null;
    }

    public void removeSecuredGroup(String group) {
    }

    public void removeSecuredRole(String role) {
    }

    public void removeSecuredUser(String user) {
    }

    public String getSecurityConstraint() {
        if (this.backingFolder.getSecurityConstraints() == null) {
            return "";
        }
        List refs = this.backingFolder.getSecurityConstraints().getSecurityConstraintsRefs();
        if (refs == null || refs.isEmpty()) {
            return "";
        }
        return (String)refs.get(0);
    }

    public void setSecurityConstraint(String constraint) {
        List refs;
        if (this.backingFolder.getSecurityConstraints() == null) {
            SecurityConstraints cons = this.backingFolder.newSecurityConstraints();
            this.backingFolder.setSecurityConstraints(cons);
        }
        if ((refs = this.backingFolder.getSecurityConstraints().getSecurityConstraintsRefs()).size() == 0) {
            refs.add(constraint);
        } else {
            refs.set(0, constraint);
        }
    }
}

