/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.jetspeed.administration.AdminUtil;
import org.apache.jetspeed.locator.TemplateLocator;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.spaces.Environment;
import org.apache.jetspeed.spaces.EnvironmentImpl;
import org.apache.jetspeed.spaces.Space;
import org.apache.jetspeed.spaces.SpaceImpl;
import org.apache.jetspeed.spaces.Spaces;
import org.apache.jetspeed.spaces.SpacesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpacesServiceImpl
implements Spaces {
    protected static Logger log = LoggerFactory.getLogger(SpacesServiceImpl.class);
    private PageManager pageManager;
    private TemplateLocator decoratorLocator;

    public SpacesServiceImpl(PageManager pageManager, TemplateLocator decoratorLocator) {
        this.pageManager = pageManager;
        this.decoratorLocator = decoratorLocator;
    }

    public List<Environment> listEnvironments() {
        LinkedList<Environment> envs = new LinkedList<Environment>();
        Folder envFolder = null;
        try {
            envFolder = this.pageManager.getFolder("/_environments/");
            for (Folder backingFolder : envFolder.getFolders()) {
                Environment env = this.loadEnvironment(backingFolder);
                envs.add(env);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return envs;
    }

    public Environment createEnvironment(String envName, String owner) throws SpacesException {
        Folder folder = this.pageManager.newFolder(this.makeEnvironmentPath(envName));
        SpacesServiceImpl.updateField(folder, Locale.ENGLISH, "env-owner", owner);
        try {
            this.pageManager.updateFolder(folder);
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
        return new EnvironmentImpl(folder);
    }

    public void storeEnvironment(Environment env) throws SpacesException {
        try {
            if (env instanceof EnvironmentImpl) {
                this.pageManager.updateFolder(((EnvironmentImpl)env).getBackingFolder());
            }
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
    }

    public void deleteEnvironment(Environment env) throws SpacesException {
        try {
            if (env instanceof EnvironmentImpl) {
                this.pageManager.removeFolder(((EnvironmentImpl)env).getBackingFolder());
            }
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
    }

    public Environment lookupEnvironment(String envName) {
        try {
            EnvironmentImpl env = new EnvironmentImpl(this.pageManager.getFolder(this.makeEnvironmentPath(envName)));
            return env;
        }
        catch (FolderNotFoundException e) {
        }
        catch (Exception e) {
            log.error("lookupEnvironment", (Throwable)e);
        }
        return null;
    }

    public List<Space> listSpaces() {
        ArrayList<Space> result = new ArrayList<Space>();
        try {
            Folder root = this.pageManager.getFolder("/");
            Space defaultSpace = this.loadSpace(root);
            result.add(defaultSpace);
            Iterator spaces = root.getFolders().iterator();
            int ix = 0;
            while (spaces.hasNext()) {
                Space space;
                Folder folder = (Folder)spaces.next();
                if (!folder.isReserved() && (space = this.loadSpace(folder)).getOwner() != null) {
                    result.add(space);
                }
                ++ix;
            }
        }
        catch (Exception e) {
            log.error("listSpaces", (Throwable)e);
        }
        return result;
    }

    public List<Space> listSpaces(String envName) {
        ArrayList<Space> result = new ArrayList<Space>();
        Folder envFolder = null;
        try {
            envFolder = this.pageManager.getFolder(this.makeEnvironmentPath(envName));
        }
        catch (FolderNotFoundException e) {
            return result;
        }
        catch (Exception e) {
            log.error("listSpaces", (Throwable)e);
        }
        try {
            for (Link link : envFolder.getLinks()) {
                Space space;
                String spacePath = link.getPath();
                Folder folder = this.pageManager.getFolder(spacePath);
                if (folder.isHidden() || folder.isReserved() || (space = this.loadSpace(folder)).getOwner() == null) continue;
                result.add(space);
            }
        }
        catch (FolderNotFoundException e) {
        }
        catch (Exception e) {
            log.error("listSpaces", (Throwable)e);
        }
        return result;
    }

    public Space createSpace(String spaceName, String owner, Folder templateFolder, String title, String shortTitle, String description, String theme, String constraint) throws SpacesException {
        SpaceImpl space = null;
        String spacePath = this.makeSpacePath(spaceName);
        Folder spaceFolder = null;
        if (this.pageManager.folderExists(spacePath)) {
            throw new SpacesException("Space " + spaceName + " already exists");
        }
        try {
            if (templateFolder != null) {
                this.pageManager.deepCopyFolder(templateFolder, spacePath, owner, false);
                spaceFolder = this.pageManager.getFolder(spacePath);
            } else {
                spaceFolder = this.pageManager.newFolder(spacePath);
            }
            space = new SpaceImpl(spaceFolder);
            space.setOwner(owner);
            space.setTitle(title);
            space.setShortTitle(shortTitle);
            space.setDescription(description);
            space.setTheme(theme);
            if (constraint != null && !"".equals(constraint.trim())) {
                space.setSecurityConstraint(constraint);
            }
            this.storeSpace(space);
        }
        catch (SpacesException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
        return space;
    }

    public void storeSpace(Space space) throws SpacesException {
        try {
            if (space instanceof SpaceImpl) {
                this.pageManager.updateFolder(((SpaceImpl)space).getBackingFolder(), true);
            }
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
    }

    public void deleteSpace(Space space) throws SpacesException {
        try {
            if (space instanceof SpaceImpl) {
                this.pageManager.removeFolder(((SpaceImpl)space).getBackingFolder());
            }
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
    }

    public Space lookupSpace(String spaceName) {
        try {
            Space space = this.loadSpace(this.pageManager.getFolder(this.makeSpacePath(spaceName)));
            if (space.getOwner() != null) {
                return space;
            }
        }
        catch (FolderNotFoundException e) {
        }
        catch (Exception e) {
            log.error("lookupSpace", (Throwable)e);
        }
        return null;
    }

    public Space lookupUserSpace(String username) {
        String spaceName = "/_user/" + username;
        try {
            Folder folder = this.pageManager.getFolder(this.makeSpacePath(spaceName));
            Space space = this.loadSpace(folder);
            return space;
        }
        catch (FolderNotFoundException e) {
        }
        catch (Exception e) {
            log.error("lookupSpace", (Throwable)e);
        }
        return null;
    }

    public boolean isUserSpace(Space space) {
        return space.getPath().startsWith("/_user/");
    }

    public void addSpaceToEnvironment(Space space, Environment env) throws SpacesException {
        try {
            String path = AdminUtil.concatenatePaths("/_environments/", env.getPath());
            path = AdminUtil.concatenatePaths(path, space.getName());
            Link link = this.pageManager.newLink(path);
            link.setUrl(space.getPath());
            this.pageManager.updateLink(link);
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
    }

    public void removeSpaceFromEnvironment(Space space, Environment env) throws SpacesException {
        try {
            Link link;
            String path = AdminUtil.concatenatePaths("/_environments/", env.getPath());
            path = AdminUtil.concatenatePaths(path, space.getName());
            try {
                link = this.pageManager.getLink(path);
            }
            catch (Exception e) {
                return;
            }
            this.pageManager.removeLink(link);
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
    }

    public boolean isSpaceInEnvironment(Space space, Environment env) {
        String path = AdminUtil.concatenatePaths("/_environments/", env.getPath());
        path = AdminUtil.concatenatePaths(path, space.getName());
        try {
            Link link = this.pageManager.getLink(path);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void deletePage(Page page) throws SpacesException {
        try {
            this.pageManager.removePage(page);
        }
        catch (Exception e) {
            throw new SpacesException((Throwable)e);
        }
    }

    public List<Folder> listFolders(Space space) {
        ArrayList<Folder> result = new ArrayList<Folder>();
        try {
            Folder root = this.pageManager.getFolder(space.getPath());
            Iterator folders = root.getFolders().iterator();
            int ix = 0;
            while (folders.hasNext()) {
                Node folder = (Node)folders.next();
                result.add((Folder)folder);
                ++ix;
            }
        }
        catch (Exception e) {
            log.error("listFolders", (Throwable)e);
        }
        return result;
    }

    public List<Link> listLinks(Space space) {
        ArrayList<Link> result = new ArrayList<Link>();
        try {
            Folder root = this.pageManager.getFolder(space.getPath());
            Iterator links = root.getLinks().iterator();
            int ix = 0;
            while (links.hasNext()) {
                Node link = (Node)links.next();
                result.add((Link)link);
                ++ix;
            }
        }
        catch (Exception e) {
            log.error("listLinks", (Throwable)e);
        }
        return result;
    }

    public List<Page> listPages(Space space) {
        ArrayList<Page> result = new ArrayList<Page>();
        try {
            Folder root = this.pageManager.getFolder(space.getPath());
            Iterator pages = root.getPages().iterator();
            int ix = 0;
            while (pages.hasNext()) {
                Node page = (Node)pages.next();
                result.add((Page)page);
                ++ix;
            }
        }
        catch (Exception e) {
            log.error("listPages", (Throwable)e);
        }
        return result;
    }

    protected static boolean updateMetaField(Collection<LocalizedField> fields, Locale locale, String name, String value) {
        for (LocalizedField field : fields) {
            if (locale != null && !field.getLocale().equals(locale) || !field.getName().equals(name)) continue;
            field.setValue(value);
            return true;
        }
        return false;
    }

    protected static String retrieveField(Folder folder, Locale locale, String name) {
        GenericMetadata metadata = folder.getMetadata();
        Collection fields = metadata.getFields();
        if (fields != null) {
            for (LocalizedField field : fields) {
                if (locale != null && !field.getLocale().equals(locale) || !field.getName().equals(name)) continue;
                return field.getValue();
            }
        }
        return null;
    }

    protected static void updateField(Folder folder, Locale locale, String name, String value) {
        Locale addLocale = locale == null ? Locale.ENGLISH : locale;
        GenericMetadata metadata = folder.getMetadata();
        Collection fields = metadata.getFields();
        if (fields == null || fields.size() == 0) {
            metadata.addField(addLocale, name, value);
        } else if (!SpacesServiceImpl.updateMetaField(fields, locale, name, value)) {
            metadata.addField(addLocale, name, value);
        }
    }

    protected Space loadSpace(Folder f) {
        return new SpaceImpl(f);
    }

    protected Environment loadEnvironment(Folder f) {
        return new EnvironmentImpl(f);
    }

    protected String makeSpacePath(String spaceName) {
        return AdminUtil.concatenatePaths("/", spaceName);
    }

    protected String makeEnvironmentPath(String envName) {
        return AdminUtil.concatenatePaths("/_environments/", envName);
    }
}

