/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.pamanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jetspeed.cluster.NodeManager;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.descriptor.JetspeedDescriptorService;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.SecurityRole;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.security.JetspeedPermission;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManagement;
import org.apache.jetspeed.util.DirectoryHelper;
import org.apache.jetspeed.util.FileSystemHelper;
import org.apache.jetspeed.util.MultiFileChecksumHelper;
import org.apache.jetspeed.util.descriptor.PortletApplicationWar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletApplicationManager
implements PortletApplicationManagement {
    private static int DEFAULT_DESCRIPTOR_CHANGE_MONITOR_INTERVAL = 10000;
    private static int DEFAULT_MAX_RETRIED_STARTS = 10;
    private static final Logger log = LoggerFactory.getLogger((String)"deployment");
    protected PortletFactory portletFactory;
    protected PortletRegistry registry;
    protected ReadWriteLock registryLock;
    protected SearchEngine searchEngine;
    protected RoleManager roleManager;
    protected PermissionManager permissionManager;
    protected boolean autoCreateRoles;
    protected List<String> permissionRoles;
    protected int descriptorChangeMonitorInterval = DEFAULT_DESCRIPTOR_CHANGE_MONITOR_INTERVAL;
    protected int maxRetriedStarts = DEFAULT_MAX_RETRIED_STARTS;
    protected DescriptorChangeMonitor monitor = null;
    protected boolean started;
    protected String appRoot;
    protected NodeManager nodeManager;
    protected JetspeedDescriptorService descriptorService;
    protected PortletApplicationManagement pamProxy;
    protected boolean startOnSetPAMProxy;

    public PortletApplicationManager(PortletFactory portletFactory, PortletRegistry registry, PermissionManager permissionManager, SearchEngine searchEngine, RoleManager roleManager, List<String> permissionRoles, NodeManager nodeManager, String appRoot, JetspeedDescriptorService descriptorService) {
        this.portletFactory = portletFactory;
        this.registry = registry;
        this.permissionManager = permissionManager;
        this.searchEngine = searchEngine;
        this.roleManager = roleManager;
        this.permissionRoles = permissionRoles;
        this.nodeManager = nodeManager;
        this.appRoot = appRoot;
        this.descriptorService = descriptorService;
        this.setLockRegistryAccess(true);
    }

    public void setPAMProxy(PortletApplicationManagement pamProxy) {
        this.pamProxy = pamProxy;
        if (!this.started && this.startOnSetPAMProxy) {
            this.start();
        }
    }

    public void start() {
        if (this.pamProxy == null) {
            this.startOnSetPAMProxy = true;
            return;
        }
        if (this.descriptorChangeMonitorInterval > 0) {
            try {
                this.monitor = new DescriptorChangeMonitor(Thread.currentThread().getThreadGroup(), "PortletApplicationManager Descriptor Change Monitor Thread", this.pamProxy, (long)this.descriptorChangeMonitorInterval, this.maxRetriedStarts);
                this.monitor.setContextClassLoader(this.getClass().getClassLoader());
                this.monitor.start();
                log.info("PortletApplicationManager Descriptor Change Monitor started!");
            }
            catch (Exception e) {
                log.warn("Unable to start PortletApplicationManager Descriptor Change Monitor: " + e.toString(), (Throwable)e);
                this.monitor.safeStop();
                this.monitor = null;
            }
        }
        this.started = true;
    }

    public void stop() {
        this.started = false;
        if (this.monitor != null) {
            this.monitor.safeStop();
            this.monitor = null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public void setAutoCreateRoles(boolean autoCreateRoles) {
        this.autoCreateRoles = autoCreateRoles;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Not started yet");
        }
    }

    public void startLocalPortletApplication(String contextName, FileSystemHelper warStruct, ClassLoader paClassLoader) throws RegistryException {
        this.checkStarted();
        this.retryStartPortletApplication(contextName, "/" + contextName, warStruct, paClassLoader, 1);
    }

    public void startPortletApplication(String contextName, FileSystemHelper warStruct, ClassLoader paClassLoader) throws RegistryException {
        this.startPortletApplication(contextName, "/" + contextName, warStruct, paClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPortletApplication(String contextName, String contextPath, FileSystemHelper warStruct, ClassLoader paClassLoader) throws RegistryException {
        this.checkStarted();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.retryStartPortletApplication(contextName, contextPath, warStruct, paClassLoader, 0);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected void retryStartPortletApplication(String contextName, String contextPath, FileSystemHelper warStruct, ClassLoader paClassLoader, int paType) throws RegistryException {
        RegistryException tryStartException = null;
        for (int i = 0; i < this.maxRetriedStarts + 1; ++i) {
            try {
                this.pamProxy.tryStartPortletApplication(contextName, contextPath, warStruct, paClassLoader, paType, 0L, true);
                tryStartException = null;
                break;
            }
            catch (RegistryException re) {
                tryStartException = re;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        if (tryStartException != null) {
            log.error("Unable to start portlet application after " + this.maxRetriedStarts + " retries: " + (Object)((Object)tryStartException), (Throwable)tryStartException);
            throw tryStartException;
        }
    }

    public void tryStartPortletApplication(String contextName, String contextPath, FileSystemHelper warStruct, ClassLoader paClassLoader, int paType, long checksum, boolean silent) throws RegistryException {
        this.attemptStartPA(contextName, contextPath, warStruct, paClassLoader, paType, checksum, silent);
    }

    public void stopLocalPortletApplication(String contextName) throws RegistryException {
        this.stopPA(contextName, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPortletApplication(String contextName) throws RegistryException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.stopPA(contextName, 0);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortletApplication(String paName) throws RegistryException {
        block13: {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                PortletApplication pa = null;
                this.lockRegistry(RegistryLock.READ);
                try {
                    pa = this.registry.getPortletApplication(paName);
                }
                catch (Exception e) {
                }
                finally {
                    this.unlockRegistry(RegistryLock.READ);
                }
                if (pa == null) break block13;
                if (this.portletFactory.isPortletApplicationRegistered(pa)) {
                    throw new RegistryException("Portlet Application " + paName + " still running");
                }
                this.unregisterPortletApplication(pa, true);
                try {
                    if (this.nodeManager != null) {
                        this.nodeManager.removeNode(paName);
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected void checkValidContextName(String contextName, boolean local) throws RegistryException {
        int prefixLength = "jetspeed-".length();
        if (contextName.length() >= prefixLength && contextName.substring(0, prefixLength).equalsIgnoreCase("jetspeed-")) {
            if (!local) {
                throw new RegistryException("Prefix \"jetspeed-\" is reserved for Local Portlet Applications only.");
            }
        } else if (local) {
            throw new RegistryException("Prefix \"jetspeed-\" is required for Local Portlet Applications.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletApplication registerPortletApplication(PortletApplicationWar paWar, PortletApplication oldPA, int paType, ClassLoader paClassLoader, boolean silent) throws RegistryException {
        long revision = 0L;
        if (oldPA != null) {
            revision = oldPA.getRevision();
            this.unregisterPortletApplication(oldPA, false);
            oldPA = null;
        }
        PortletApplication pa = null;
        boolean registered = false;
        String paName = paWar.getPortletApplicationName();
        try {
            log.info("Loading deployment descriptors for " + paName + " ....");
            pa = paWar.createPortletApp(paClassLoader);
            pa.setApplicationType(paType);
            if (revision > 0L) {
                pa.setRevision(revision);
            }
            if (paType == 1) {
                pa.setContextPath("<portal>");
            }
        }
        catch (Exception e) {
            String msg = "Failed to load portlet application for " + paWar.getPortletApplicationName();
            if (!silent || log.isDebugEnabled()) {
                log.error(msg, (Throwable)e);
            }
            throw new RegistryException(msg, (Throwable)e);
        }
        try {
            this.lockRegistry(RegistryLock.WRITE);
            try {
                this.registry.registerPortletApplication(pa);
            }
            finally {
                this.unlockRegistry(RegistryLock.WRITE);
            }
            registered = true;
            log.info("Registered the portlet application " + paName);
            this.updateSearchEngine(false, pa);
            if (this.nodeManager != null) {
                this.nodeManager.addNode(new Long(pa.getRevision()), pa.getName());
            }
            this.grantDefaultPermissions(paName);
            if (this.autoCreateRoles && this.roleManager != null && pa.getSecurityRoles() != null) {
                try {
                    for (SecurityRole sr : pa.getSecurityRoles()) {
                        if (this.roleManager.roleExists(sr.getName())) continue;
                        this.roleManager.addRole(sr.getName());
                        log.info("AutoCreated role: " + sr.getName() + " from portlet application " + paName + " its web definition");
                    }
                }
                catch (SecurityException sex) {
                    log.warn("Failed to autoCreate roles for portlet application " + paName + ": " + sex.getMessage(), (Throwable)sex);
                }
            }
            return pa;
        }
        catch (Exception e) {
            String msg;
            block21: {
                msg = "Failed to register portlet application, " + paName;
                if (!silent || log.isDebugEnabled()) {
                    log.error(msg, (Throwable)e);
                }
                if (registered) {
                    try {
                        this.unregisterPortletApplication(pa, paType == 1);
                    }
                    catch (Exception re) {
                        if (silent && !log.isDebugEnabled()) break block21;
                        log.error("Failed to rollback registration of portlet application " + paName, (Throwable)re);
                    }
                }
            }
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptStartPA(String contextName, String contextPath, FileSystemHelper warStruct, ClassLoader paClassLoader, int paType, long checksum, boolean silent) throws RegistryException {
        boolean register = true;
        boolean monitored = false;
        DescriptorChangeMonitor changeMonitor = this.monitor;
        if (changeMonitor != null) {
            monitored = changeMonitor.isMonitored(contextName);
        }
        if (log.isDebugEnabled()) {
            log.debug("Is portlet application " + contextName + " monitored? -> " + monitored);
        }
        PortletApplicationWar paWar = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Try to start portlet application " + contextName + ".");
            }
            paWar = new PortletApplicationWar(warStruct, contextName, contextPath, checksum, this.descriptorService);
            try {
                if (paClassLoader == null) {
                    paClassLoader = paWar.createClassloader(this.getClass().getClassLoader());
                }
                checksum = paWar.getPortletApplicationChecksum();
                if (log.isDebugEnabled()) {
                    log.debug("New checksum for portlet application " + contextName + " is " + checksum);
                }
            }
            catch (IOException e) {
                String msg = "Invalid PA WAR for " + contextName;
                e.printStackTrace();
                log.error(msg, (Throwable)e);
                if (paClassLoader == null) {
                    throw new RegistryException((Throwable)e);
                }
                register = false;
            }
            PortletApplication pa = null;
            this.lockRegistry(RegistryLock.READ);
            try {
                pa = this.registry.getPortletApplication(contextName);
            }
            finally {
                this.unlockRegistry(RegistryLock.READ);
            }
            if (pa != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Portlet Application " + contextName + " found in registry.");
                }
                if (pa.getApplicationType() != paType) {
                    throw new RegistryException("Cannot start portlet application " + contextName + ": as Application Types don't match: " + pa.getApplicationType() + " != " + paType);
                }
                if (!monitored && changeMonitor != null) {
                    changeMonitor.remove(contextName);
                }
                if (log.isDebugEnabled()) {
                    log.debug("unregistering portlet application " + contextName + "...");
                }
                this.portletFactory.unregisterPortletApplication(pa);
            }
            if (register) {
                if (pa == null) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("Register new portlet application " + contextName + ".");
                        }
                        pa = this.registerPortletApplication(paWar, pa, paType, paClassLoader, silent);
                    }
                    catch (RegistryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        String msg = "Error register new portlet application " + contextName + ".";
                        if (log.isDebugEnabled()) {
                            log.debug(msg);
                        }
                        throw new RegistryException(msg);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Re-register existing portlet application " + contextName + ".");
                }
                int status = this.nodeManager.checkNode(new Long(pa.getRevision()), pa.getName());
                boolean reregister = false;
                boolean deploy = false;
                switch (status) {
                    case 2: {
                        if (log.isDebugEnabled()) {
                            log.debug("Node for Portlet application " + contextName + " is NEW.");
                        }
                        log.warn("The portlet application " + pa.getName() + " is registered in the database but not locally .... we will reregister");
                        reregister = true;
                        if (checksum == pa.getChecksum()) break;
                        log.warn("The provided portlet application " + pa.getName() + " is a different version than in the database (db-checksum=" + pa.getChecksum() + ", local-checksum=: " + checksum + ") .... we will redeploy (also to the database)");
                        deploy = true;
                        break;
                    }
                    case 0: {
                        if (log.isDebugEnabled()) {
                            log.debug("Node for Portlet application " + contextName + " is SAVED.");
                        }
                        if (checksum == pa.getChecksum()) break;
                        log.warn("The provided portlet application " + pa.getName() + " is a different version than in the local node info and the database (db-checksum=" + pa.getChecksum() + ", local-checksum=: " + checksum + ") .... we will reregister AND redeploy (also to the database)");
                        reregister = true;
                        deploy = true;
                        break;
                    }
                    case 1: {
                        if (log.isDebugEnabled()) {
                            log.debug("Node for Portlet application " + contextName + " is OUTDATED (local PA.id < DB PA.id).");
                        }
                        if (checksum != pa.getChecksum()) {
                            log.error("The portlet application " + pa.getName() + " provided for the upgrade IS WRONG. The database checksum= " + pa.getChecksum() + ", but the local=" + checksum + "....THIS NEEDS TO BE CORRECTED");
                            deploy = true;
                        }
                        reregister = true;
                    }
                }
                if (deploy) {
                    if (log.isDebugEnabled()) {
                        log.debug("Register (deploy=true) Portlet application " + contextName + " in database.");
                    }
                    pa = this.registerPortletApplication(paWar, pa, paType, paClassLoader, silent);
                } else if (reregister) {
                    if (log.isDebugEnabled()) {
                        log.debug("Re-Register (reregister=true) Portlet application " + contextName + ".");
                    }
                    this.updateSearchEngine(true, pa);
                    this.updateSearchEngine(false, pa);
                    try {
                        this.nodeManager.addNode(new Long(pa.getRevision()), pa.getName());
                    }
                    catch (Exception e) {
                        log.error("Adding node for portlet application " + pa.getName() + " caused exception", (Throwable)e);
                    }
                }
            }
            if (register) {
                if (log.isDebugEnabled()) {
                    log.debug("Register Portlet application " + contextName + " in portlet factory.");
                }
                this.portletFactory.registerPortletApplication(pa, paClassLoader);
            }
            if (!monitored && changeMonitor != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Add change monitor for application " + contextName + " with checksum " + checksum + ".");
                }
                changeMonitor.monitor(contextName, contextPath, paClassLoader, paType, warStruct.getRootDirectory(), checksum);
            }
        }
        catch (Exception e) {
            String msg = "Error starting portlet application " + contextName;
            if (!silent || log.isDebugEnabled()) {
                log.error(msg, (Throwable)e);
            }
            if (!monitored && changeMonitor != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Add change monitor for application " + contextName + " and set unsuccessful starts to 1.");
                }
                changeMonitor.monitor(contextName, contextPath, paClassLoader, paType, warStruct.getRootDirectory(), checksum);
                changeMonitor.get(contextName).setUnsuccessfulStarts(1);
            }
            throw new RegistryException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPA(String contextName, int paType) throws RegistryException {
        PortletApplication pa = null;
        this.lockRegistry(RegistryLock.READ);
        try {
            pa = this.registry.getPortletApplication(contextName);
        }
        catch (Exception e) {
        }
        finally {
            this.unlockRegistry(RegistryLock.READ);
        }
        if (pa != null && pa.getApplicationType() != paType) {
            throw new RegistryException("Cannot stop portlet application " + contextName + ": as Application Types don't match: " + pa.getApplicationType() + " != " + paType);
        }
        DescriptorChangeMonitor monitor = this.monitor;
        if (monitor != null) {
            monitor.remove(contextName);
        }
        if (pa != null) {
            this.portletFactory.unregisterPortletApplication(pa);
        }
    }

    protected void updateSearchEngine(boolean remove, PortletApplication pa) {
        if (this.searchEngine != null) {
            List portletDefList = pa.getPortlets();
            List cloneDefList = pa.getClones();
            ArrayList<PortletApplication> list = new ArrayList<PortletApplication>(portletDefList.size() + cloneDefList.size() + 1);
            if (remove) {
                list.addAll(portletDefList);
                list.addAll(cloneDefList);
                list.add(pa);
                this.searchEngine.remove(list);
                log.info("Un-Registered the portlet application in the search engine... " + pa.getName());
            } else {
                list.add(pa);
                list.addAll(portletDefList);
                list.addAll(cloneDefList);
                this.searchEngine.add(list);
                log.info("Registered the portlet application in the search engine... " + pa.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterPortletApplication(PortletApplication pa, boolean purgeEntityInfo) throws RegistryException {
        this.updateSearchEngine(true, pa);
        this.lockRegistry(RegistryLock.WRITE);
        try {
            this.registry.removeApplication(pa);
        }
        finally {
            this.unlockRegistry(RegistryLock.WRITE);
        }
        this.revokeDefaultPermissions(pa.getName());
    }

    protected void grantDefaultPermissions(String paName) {
        try {
            for (String roleName : this.permissionRoles) {
                Role userRole = this.roleManager.getRole(roleName);
                if (userRole == null) continue;
                JetspeedPermission permission = this.permissionManager.newPermission("portlet", paName + "::*", "view, edit");
                if (this.permissionManager.permissionExists(permission)) continue;
                this.permissionManager.addPermission(permission);
                this.permissionManager.grantPermission(permission, (JetspeedPrincipal)userRole);
            }
        }
        catch (SecurityException e) {
            log.error("Error granting default permissions for " + paName, (Throwable)e);
        }
    }

    protected void revokeDefaultPermissions(String paName) {
        try {
            for (String roleName : this.permissionRoles) {
                Role userRole = this.roleManager.getRole(roleName);
                if (userRole == null) continue;
                JetspeedPermission permission = this.permissionManager.newPermission("portlet", paName + "::*", "view, edit");
                if (!this.permissionManager.permissionExists(permission)) continue;
                this.permissionManager.removePermission(permission);
            }
        }
        catch (SecurityException e) {
            log.error("Error revoking default permissions for " + paName, (Throwable)e);
        }
    }

    public int getDescriptorChangeMonitorInterval() {
        return this.descriptorChangeMonitorInterval / 1000;
    }

    public void setDescriptorChangeMonitorInterval(int descriptorChangeMonitorInterval) {
        this.descriptorChangeMonitorInterval = descriptorChangeMonitorInterval * 1000;
    }

    public void setMaxRetriedStarts(int maxRetriedStarts) {
        this.maxRetriedStarts = maxRetriedStarts;
    }

    public int getMaxRetriedStarts() {
        return this.maxRetriedStarts;
    }

    protected void lockRegistry(RegistryLock lockAccess) {
        if (this.registryLock != null) {
            switch (lockAccess) {
                case READ: {
                    this.registryLock.readLock().lock();
                    break;
                }
                case WRITE: {
                    this.registryLock.writeLock().lock();
                }
            }
        }
    }

    protected void unlockRegistry(RegistryLock lockAccess) {
        if (this.registryLock != null) {
            switch (lockAccess) {
                case READ: {
                    this.registryLock.readLock().unlock();
                    break;
                }
                case WRITE: {
                    this.registryLock.writeLock().unlock();
                }
            }
        }
    }

    public boolean getLockRegistryAccess() {
        return this.registryLock != null;
    }

    public void setLockRegistryAccess(boolean lockRegistryAccess) {
        if (this.registryLock != null != lockRegistryAccess) {
            this.registryLock = lockRegistryAccess ? new ReentrantReadWriteLock(true) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum RegistryLock {
        READ,
        WRITE;

    }

    private static class DescriptorChangeMonitor
    extends Thread {
        private PortletApplicationManagement pam;
        private long interval;
        private boolean started = true;
        private ArrayList monitorInfos;
        private int maxRetriedStarts;

        public DescriptorChangeMonitor(ThreadGroup group, String name, PortletApplicationManagement pam, long interval, int maxretriedStarts) {
            super(group, name);
            this.pam = pam;
            this.interval = interval;
            this.monitorInfos = new ArrayList();
            this.setPriority(1);
            this.setDaemon(true);
            this.maxRetriedStarts = maxretriedStarts;
        }

        public synchronized void run() {
            try {
                this.wait(this.interval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (this.started) {
                this.checkDescriptorChanges();
                try {
                    this.wait(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void safeStop() {
            DescriptorChangeMonitor descriptorChangeMonitor = this;
            synchronized (descriptorChangeMonitor) {
                this.started = false;
                this.monitorInfos.clear();
                this.notifyAll();
            }
            try {
                this.join(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void monitor(String contextName, String contextPath, ClassLoader paClassLoader, int paType, File paDir, long checksum) {
            this.monitorInfos.add(new DescriptorChangeMonitorInfo(contextName, contextPath, paClassLoader, paType, paDir, checksum));
        }

        public synchronized void remove(String contextName) {
            for (int i = this.monitorInfos.size() - 1; i > -1; --i) {
                DescriptorChangeMonitorInfo monitorInfo = (DescriptorChangeMonitorInfo)this.monitorInfos.get(i);
                if (!contextName.equals(monitorInfo.getContextName())) continue;
                monitorInfo.setObsolete();
                break;
            }
        }

        public synchronized DescriptorChangeMonitorInfo get(String contextName) {
            for (int i = this.monitorInfos.size() - 1; i > -1; --i) {
                DescriptorChangeMonitorInfo monitorInfo = (DescriptorChangeMonitorInfo)this.monitorInfos.get(i);
                if (!contextName.equals(monitorInfo.getContextName())) continue;
                return monitorInfo;
            }
            return null;
        }

        public boolean isMonitored(String contextName) {
            DescriptorChangeMonitorInfo monitorInfo = this.get(contextName);
            return monitorInfo != null && !monitorInfo.isObsolete();
        }

        private synchronized void checkDescriptorChanges() {
            int size = this.monitorInfos.size();
            if (log.isDebugEnabled()) {
                log.debug("check for portlet application descriptor changes.");
            }
            for (int i = size - 1; i > -1; --i) {
                if (!this.started) continue;
                DescriptorChangeMonitorInfo monitorInfo = (DescriptorChangeMonitorInfo)this.monitorInfos.get(i);
                if (monitorInfo.isObsolete()) {
                    this.monitorInfos.remove(i);
                    continue;
                }
                try {
                    int unsuccessfulStarts = monitorInfo.getUnsuccessfulStarts();
                    if (!monitorInfo.isChanged() && (unsuccessfulStarts <= 0 || unsuccessfulStarts > this.maxRetriedStarts)) continue;
                    try {
                        this.pam.tryStartPortletApplication(monitorInfo.getContextName(), monitorInfo.getContextPath(), (FileSystemHelper)new DirectoryHelper(monitorInfo.getPADir()), monitorInfo.getPAClassLoader(), monitorInfo.getPortletApplicationType(), monitorInfo.getChecksum(), true);
                        monitorInfo.setUnsuccessfulStarts(0);
                    }
                    catch (Exception e) {
                        if (monitorInfo.isChanged()) {
                            log.error("Failed to restart PortletApplication " + monitorInfo.getContextName(), (Throwable)e);
                        } else if (log.isWarnEnabled()) {
                            log.warn("Failed to restart PortletApplication " + monitorInfo.getContextName(), (Throwable)e);
                        }
                        monitorInfo.setUnsuccessfulStarts(unsuccessfulStarts + 1);
                        if (log.isDebugEnabled()) {
                            log.debug("Number of unsuccessful PA starts is " + monitorInfo.getUnsuccessfulStarts() + ".");
                        }
                        if (monitorInfo.getUnsuccessfulStarts() <= this.maxRetriedStarts) continue;
                        log.error("Max number of retries (" + this.maxRetriedStarts + ") reached. Ignoring Monitor for " + monitorInfo.getContextName());
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("Descriptor Change check failure for PortletApplication " + monitorInfo.getContextName(), (Throwable)e);
                }
            }
        }

        private static class DescriptorChangeMonitorInfo {
            private String contextName;
            private String contextPath;
            private ClassLoader paClassLoader;
            private int paType;
            private File paDir;
            private File[] descriptors;
            private long descriptorModificationTime;
            private long extendedDescriptorModificationTime;
            private long checksum;
            private boolean obsolete;
            private int unsuccessfulStarts;

            public DescriptorChangeMonitorInfo(String contextName) {
                this.contextName = contextName;
            }

            public DescriptorChangeMonitorInfo(String contextName, String contextPath, ClassLoader paClassLoader, int paType, File paDir, long checksum) {
                this.contextName = contextName;
                this.contextPath = contextPath;
                this.paClassLoader = paClassLoader;
                this.paType = paType;
                this.paDir = paDir.isAbsolute() ? paDir : paDir.getAbsoluteFile();
                this.checksum = checksum;
                this.descriptors = new File[]{new File(paDir, "WEB-INF/web.xml"), new File(paDir, "WEB-INF/portlet.xml"), new File(paDir, "WEB-INF/jetspeed-portlet.xml")};
                this.descriptorModificationTime = this.descriptors[1].lastModified();
                this.extendedDescriptorModificationTime = this.descriptors[2].lastModified();
            }

            public String getContextName() {
                return this.contextName;
            }

            public ClassLoader getPAClassLoader() {
                return this.paClassLoader;
            }

            public int getPortletApplicationType() {
                return this.paType;
            }

            public File getPADir() {
                return this.paDir;
            }

            public long getChecksum() {
                return this.checksum;
            }

            public boolean isChanged() {
                if (!this.obsolete) {
                    long newDescriptorModificationTime = this.descriptors[1].lastModified();
                    long newExtendedDescriptorModificationTime = this.descriptors[2].lastModified();
                    if (this.descriptorModificationTime != newDescriptorModificationTime || this.extendedDescriptorModificationTime != newExtendedDescriptorModificationTime) {
                        this.descriptorModificationTime = newDescriptorModificationTime;
                        this.extendedDescriptorModificationTime = newExtendedDescriptorModificationTime;
                        long newChecksum = MultiFileChecksumHelper.getChecksum(this.descriptors);
                        if (log.isDebugEnabled()) {
                            log.debug("checksum check for descriptors for application " + this.contextName + ": old (" + this.checksum + ") new (" + newChecksum + ").");
                        }
                        if (this.checksum != newChecksum) {
                            if (log.isDebugEnabled()) {
                                log.debug("portlet descriptors for application " + this.contextName + " have changed.");
                            }
                            this.checksum = newChecksum;
                            this.unsuccessfulStarts = 0;
                            return true;
                        }
                    }
                }
                return false;
            }

            public void setObsolete() {
                this.obsolete = true;
            }

            public boolean isObsolete() {
                return this.obsolete;
            }

            public int getUnsuccessfulStarts() {
                return this.unsuccessfulStarts;
            }

            public void setUnsuccessfulStarts(int unsuccessfulStarts) {
                this.unsuccessfulStarts = unsuccessfulStarts;
            }

            public String getContextPath() {
                return this.contextPath;
            }
        }
    }
}

