/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.pamanager;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.descriptor.JetspeedDescriptorService;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.tools.pamanager.PortletApplicationManager;
import org.apache.jetspeed.util.FileSystemHelper;
import org.apache.jetspeed.util.descriptor.PortletApplicationWar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedPortletApplicationManager
extends PortletApplicationManager {
    private static final Logger log = LoggerFactory.getLogger((String)"deployment");

    public VersionedPortletApplicationManager(PortletFactory portletFactory, PortletRegistry registry, PermissionManager permissionManager, SearchEngine searchEngine, RoleManager roleManager, List<String> permissionRoles, String appRoot, JetspeedDescriptorService descriptorService) {
        super(portletFactory, registry, permissionManager, searchEngine, roleManager, permissionRoles, null, appRoot, descriptorService);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void attemptStartPA(String contextName, String contextPath, FileSystemHelper warStruct, ClassLoader paClassLoader, int paType, long checksum, boolean silent) throws RegistryException {
        PortletApplicationWar paWar = null;
        try {
            block16: {
                paWar = new PortletApplicationWar(warStruct, contextName, contextPath, checksum, this.descriptorService);
                try {
                    if (paClassLoader == null) {
                        paClassLoader = paWar.createClassloader(this.getClass().getClassLoader());
                    }
                }
                catch (IOException e) {
                    String msg = "Invalid PA WAR for " + contextName;
                    if (!silent || log.isDebugEnabled()) {
                        log.error(msg, (Throwable)e);
                    }
                    if (paClassLoader != null) break block16;
                    throw new RegistryException((Throwable)e);
                }
            }
            PortletApplication regPA = null;
            this.lockRegistry(PortletApplicationManager.RegistryLock.READ);
            try {
                regPA = this.registry.getPortletApplication(contextName);
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                this.unlockRegistry(PortletApplicationManager.RegistryLock.READ);
                throw throwable;
            }
            this.unlockRegistry(PortletApplicationManager.RegistryLock.READ);
            PortletApplication newPA = paWar.createPortletApp();
            if (regPA == null) {
                System.out.println("**** New portlet app found - registration required..." + contextName);
                regPA = this.registerPortletApplication(paWar, null, paType, paClassLoader, silent);
            } else {
                String regVersion = this.getVersion(regPA);
                String newVersion = this.getVersion(newPA);
                System.out.print("Reg version is " + regVersion);
                System.out.print(", New version is " + newVersion);
                if (newVersion.equals("")) {
                    System.out.println(" - New Version was NOT provided: registration not required ... " + contextName);
                } else if (newVersion.compareTo(regVersion) > 0) {
                    System.out.println(" - **** New Version is greater: registration required... " + contextName);
                    regPA = this.registerPortletApplication(paWar, regPA, paType, paClassLoader, silent);
                } else {
                    System.out.println(" - New Version is NOT greater: registration not required ... " + contextName);
                }
            }
            if (this.portletFactory.isPortletApplicationRegistered(regPA)) {
                this.portletFactory.unregisterPortletApplication(regPA);
            }
            this.portletFactory.registerPortletApplication(regPA, paClassLoader);
        }
        catch (Exception e) {
            String msg = "Error starting portlet application " + contextName;
            if (!silent || log.isDebugEnabled()) {
                log.error(msg, (Throwable)e);
            }
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    protected String getVersion(PortletApplication pa) {
        Iterator it;
        String version = "";
        Collection versionList = pa.getMetadata().getFields("pa-version");
        if (versionList != null && (it = versionList.iterator()).hasNext()) {
            LocalizedField field = (LocalizedField)it.next();
            version = field.getValue();
        }
        return version;
    }
}

