/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.userinfo.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.om.portlet.UserAttributeRef;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.userinfo.UserAttributeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectUserAttributeSourceImpl
implements UserAttributeSource {
    private static final Logger log = LoggerFactory.getLogger(SubjectUserAttributeSourceImpl.class);

    public Map<String, String> getUserAttributeMap(Subject subject, Collection<UserAttributeRef> userAttributeRefs, RequestContext context) {
        HashMap<String, String> userAttributeMap = new HashMap<String, String>();
        Principal userPrincipal = SubjectHelper.getPrincipal((Subject)subject, User.class);
        if (null != userPrincipal) {
            log.debug("Got user principal: " + userPrincipal.getName());
            Map userInfo = ((User)userPrincipal).getInfoMap();
            if (userAttributeRefs != null) {
                for (UserAttributeRef currentAttributeRef : userAttributeRefs) {
                    String key = currentAttributeRef.getNameLink();
                    String name = currentAttributeRef.getName();
                    if (key == null) {
                        key = name;
                    }
                    if (!userInfo.containsKey(key)) continue;
                    userAttributeMap.put(name, (String)userInfo.get(key));
                }
            }
        }
        return userAttributeMap;
    }
}

