/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.userinfo.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryEventListener;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.UserAttributeRef;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.userinfo.impl.AbstractUserInfoManagerImpl;
import org.apache.jetspeed.userinfo.impl.SubjectUserAttributeSourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfoManagerImpl
extends AbstractUserInfoManagerImpl
implements RegistryEventListener {
    private static final Logger log = LoggerFactory.getLogger(UserInfoManagerImpl.class);
    private static Map<String, List<UserAttributeRef>> appUserInfoAttrCache = Collections.synchronizedMap(new HashMap());
    private static final SubjectUserAttributeSourceImpl subjectUserAttributeSource = new SubjectUserAttributeSourceImpl();
    protected PortletRegistry registry;

    public UserInfoManagerImpl(PortletRegistry registry) {
        this.registry = registry;
        registry.addRegistryListener((RegistryEventListener)this);
    }

    public Map<String, String> getUserInfoMap(String appName, RequestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Getting user info for portlet application: " + appName);
        }
        Map<String, String> userInfo = null;
        Subject subject = context.getSubject();
        if (null != subject) {
            userInfo = subjectUserAttributeSource.getUserAttributeMap(subject, this.getLinkedUserAttr(appName), context);
        }
        return userInfo;
    }

    protected List<UserAttributeRef> getLinkedUserAttr(String appName) {
        List<UserAttributeRef> linkedUserAttr = appUserInfoAttrCache.get(appName);
        if (linkedUserAttr == null) {
            PortletApplication pa = this.registry.getPortletApplication(appName, true);
            if (null == pa) {
                log.debug("javax.portlet.userinfo is set to null");
                return null;
            }
            List userAttributes = pa.getUserAttributes();
            List userAttributeRefs = pa.getUserAttributeRefs();
            linkedUserAttr = this.mapLinkedUserAttributes(userAttributes, userAttributeRefs);
            appUserInfoAttrCache.put(appName, linkedUserAttr);
        }
        return linkedUserAttr;
    }

    public void applicationRemoved(PortletApplication app) {
        appUserInfoAttrCache.remove(app.getName());
    }

    public void applicationUpdated(PortletApplication app) {
        appUserInfoAttrCache.remove(app.getName());
    }

    public void portletRemoved(PortletDefinition def) {
    }

    public void portletUpdated(PortletDefinition def) {
    }
}

