/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils {
    private HttpUtils() {
    }

    public static Map<String, String[]> parseQueryString(String queryString) {
        return HttpUtils.parseQueryString(queryString, "ISO-8859-1");
    }

    public static Map<String, String[]> parseQueryString(String queryString, String encoding) {
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.emptyMap();
        }
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        for (String pair : StringUtils.split((String)queryString, (String)"&")) {
            String[] values;
            String[] nameAndValue = StringUtils.split((String)pair, (String)"=", (int)2);
            if (nameAndValue.length != 2) continue;
            String name = nameAndValue[0];
            String value = nameAndValue[1];
            if (encoding != null) {
                try {
                    name = URLDecoder.decode(name, encoding);
                    value = URLDecoder.decode(value, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Unsupported encoding: " + encoding);
                }
            }
            if ((values = (String[])paramMap.get(name)) == null) {
                paramMap.put(name, new String[]{value});
                continue;
            }
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
            paramMap.put(name, newValues);
        }
        return paramMap;
    }
}

