/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.descriptor.JetspeedDescriptorService;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.SecurityRole;
import org.apache.jetspeed.om.portlet.SecurityRoleRef;
import org.apache.jetspeed.tools.pamanager.PortletApplicationException;
import org.apache.jetspeed.util.DirectoryHelper;
import org.apache.jetspeed.util.FileSystemHelper;
import org.apache.jetspeed.util.MultiFileChecksumHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletApplicationWar {
    public static final String PORTLET_XML_PATH = "WEB-INF/portlet.xml";
    public static final String WEB_XML_PATH = "WEB-INF/web.xml";
    public static final String EXTENDED_PORTLET_XML_PATH = "WEB-INF/jetspeed-portlet.xml";
    protected static final Logger log = LoggerFactory.getLogger((String)"deployment");
    protected String paName;
    protected String webAppContextRoot;
    protected FileSystemHelper warStruct;
    private PortletApplication portletApp;
    private long paChecksum;
    protected JetspeedDescriptorService descriptorService;

    public PortletApplicationWar(FileSystemHelper warStruct, String paName, String webAppContextRoot, JetspeedDescriptorService descriptorService) {
        this(warStruct, paName, webAppContextRoot, 0L, descriptorService);
    }

    public PortletApplicationWar(FileSystemHelper warStruct, String paName, String webAppContextRoot, long paChecksum, JetspeedDescriptorService descriptorService) {
        this.validatePortletApplicationName(paName);
        this.paName = paName;
        this.webAppContextRoot = webAppContextRoot;
        this.warStruct = warStruct;
        this.paChecksum = paChecksum;
        this.descriptorService = descriptorService;
    }

    public long getPortletApplicationChecksum() throws IOException {
        if (this.paChecksum == 0L) {
            this.paChecksum = MultiFileChecksumHelper.getChecksum(new File[]{new File(this.warStruct.getRootDirectory(), WEB_XML_PATH), new File(this.warStruct.getRootDirectory(), PORTLET_XML_PATH), new File(this.warStruct.getRootDirectory(), EXTENDED_PORTLET_XML_PATH)});
        }
        if (this.paChecksum == 0L) {
            throw new IOException("Cannot find any deployment descriptor for Portlet Application " + this.paName);
        }
        return this.paChecksum;
    }

    private void validatePortletApplicationName(String paName) {
        if (paName == null || paName.startsWith("/") || paName.startsWith("\\") || paName.endsWith("/") || paName.endsWith("\\")) {
            throw new IllegalStateException("Invalid paName \"" + paName + "\".  paName cannot be null nor can it begin nor end with any slashes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletApplication createPortletApp(ClassLoader classLoader) throws Exception {
        InputStream webXmlStream = this.getInputStream(WEB_XML_PATH);
        InputStream portletXmlStream = this.getInputStream(PORTLET_XML_PATH);
        InputStream extStream = null;
        try {
            extStream = this.getInputStream(EXTENDED_PORTLET_XML_PATH);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            this.portletApp = this.descriptorService.read(this.paName, this.webAppContextRoot, webXmlStream, portletXmlStream, extStream, classLoader);
            this.validate();
            this.portletApp.setName(this.paName);
            this.portletApp.setContextPath(this.webAppContextRoot);
            this.portletApp.setChecksum(this.paChecksum);
            PortletApplication portletApplication = this.portletApp;
            return portletApplication;
        }
        finally {
            if (webXmlStream != null) {
                webXmlStream.close();
            }
            if (portletXmlStream != null) {
                portletXmlStream.close();
            }
            if (null != extStream) {
                extStream.close();
            }
        }
    }

    public PortletApplication createPortletApp() throws Exception {
        return this.createPortletApp(this.getClass().getClassLoader());
    }

    protected InputStream getInputStream(String path) throws IOException {
        File child = new File(this.warStruct.getRootDirectory(), path);
        if (child == null || !child.exists()) {
            throw new FileNotFoundException("Unable to locate file or path " + child);
        }
        FileInputStream fileInputStream = new FileInputStream(child);
        return fileInputStream;
    }

    protected OutputStream getOutputStream(String path) throws IOException {
        File child = new File(this.warStruct.getRootDirectory(), path);
        if (child == null) {
            throw new FileNotFoundException("Unable to locate file or path " + child);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(child);
        return fileOutputStream;
    }

    protected Writer getWriter(String path) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(path));
    }

    public PortletApplicationWar copyWar(String targetAppRoot) throws IOException {
        DirectoryHelper target = new DirectoryHelper(new File(targetAppRoot));
        try {
            target.copyFrom(this.warStruct.getRootDirectory());
            PortletApplicationWar portletApplicationWar = new PortletApplicationWar((FileSystemHelper)target, this.paName, this.webAppContextRoot, this.paChecksum, this.descriptorService);
            return portletApplicationWar;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            target.close();
        }
    }

    public void removeWar() throws IOException {
        if (!this.warStruct.getRootDirectory().exists()) {
            throw new FileNotFoundException("PortletApplicationWar ," + this.warStruct.getRootDirectory() + ", does not exist.");
        }
        this.warStruct.remove();
    }

    public void validate() throws PortletApplicationException {
        if (this.portletApp == null) {
            throw new IllegalStateException("createPortletApp() must be called before invoking validate()");
        }
        List portlets = this.portletApp.getPortlets();
        for (PortletDefinition portlet : portlets) {
            for (SecurityRoleRef roleRef : portlet.getSecurityRoleRefs()) {
                String roleName = roleRef.getRoleLink();
                if (roleName == null || roleName.length() == 0) {
                    roleName = roleRef.getRoleName();
                }
                boolean found = false;
                for (SecurityRole role : this.portletApp.getSecurityRoles()) {
                    if (!role.getName().equals(roleName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                String errorMsg = "Undefined security role " + roleName + " referenced from portlet " + portlet.getPortletName();
                throw new PortletApplicationException(errorMsg);
            }
        }
    }

    public ClassLoader createClassloader(ClassLoader parent) throws IOException {
        File webInfLib;
        ArrayList<URL> urls = new ArrayList<URL>();
        File webInfClasses = null;
        webInfClasses = new File(this.warStruct.getRootDirectory(), "WEB-INF/classes/");
        if (webInfClasses.exists()) {
            log.info("Adding " + webInfClasses.toURL() + " to class path.");
            urls.add(webInfClasses.toURL());
        }
        if ((webInfLib = new File(this.warStruct.getRootDirectory(), "WEB-INF/lib")).exists()) {
            File[] jars = webInfLib.listFiles();
            for (int i = 0; i < jars.length; ++i) {
                File jar = jars[i];
                log.info("Adding " + jar.toURL() + " to class path.");
                urls.add(jar.toURL());
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    public String getPortletApplicationName() {
        return this.paName;
    }

    public String getDeployedPath() {
        try {
            return this.warStruct.getRootDirectory().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public FileSystemHelper getFileSystem() {
        return this.warStruct;
    }

    public PortletApplication getPortletApp() {
        return this.portletApp;
    }
}

