/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.velocity;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.administration.PortalConfiguration;
import org.apache.jetspeed.aggregator.PortletRenderer;
import org.apache.jetspeed.capabilities.CapabilityMap;
import org.apache.jetspeed.container.PortletWindow;
import org.apache.jetspeed.container.url.BasePortalURL;
import org.apache.jetspeed.locator.LocatorDescriptor;
import org.apache.jetspeed.locator.TemplateDescriptor;
import org.apache.jetspeed.locator.TemplateLocator;
import org.apache.jetspeed.locator.TemplateLocatorException;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.portlet.HeadElement;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.jetspeed.util.ArgUtil;
import org.apache.jetspeed.util.HeadElementUtils;
import org.apache.jetspeed.util.KeyValue;
import org.apache.jetspeed.util.Path;
import org.apache.jetspeed.velocity.JetspeedVelocityPowerTool;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedPowerToolImpl
implements JetspeedVelocityPowerTool {
    private static final String DECORATOR_ID_ATTR = "decoratorId";
    private static final String ACTION_IMAGE_EXTENSION_ATTR = "actionImageExtension";
    protected static final String PORTLET_CONFIG_ATTR = "javax.portlet.config";
    protected static final String RENDER_RESPONSE_ATTR = "javax.portlet.response";
    protected static final String RENDER_REQUEST_ATTR = "javax.portlet.request";
    protected static final String COLUMNS_ATTR = "columns";
    protected static final String COLUMN_SIZES = "columnSizes";
    protected RenderRequest renderRequest;
    protected RenderResponse renderResponse;
    protected PortletConfig portletConfig;
    protected Writer templateWriter;
    protected static final Logger log = LoggerFactory.getLogger(JetspeedPowerToolImpl.class);
    protected CapabilityMap capabilityMap;
    protected Locale locale;
    protected LocatorDescriptor templateLocatorDescriptor;
    protected TemplateLocator templateLocator;
    protected TemplateLocator decorationLocator;
    protected LocatorDescriptor decorationLocatorDescriptor;
    protected RequestContext requestContext;
    protected Context velocityContext;
    private BasePortalURL baseUrlAccess;
    private PortletRenderer renderer;
    protected boolean ajaxCustomization = false;

    public JetspeedPowerToolImpl(RequestContext requestContext, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse, PortletRenderer renderer) throws Exception {
        HttpServletRequest request = requestContext.getRequest();
        this.requestContext = requestContext;
        try {
            this.baseUrlAccess = (BasePortalURL)this.getComponent("BasePortalURL");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.portletConfig = portletConfig;
        this.renderRequest = renderRequest;
        this.renderResponse = renderResponse;
        this.templateLocator = (TemplateLocator)this.getComponent("TemplateLocator");
        this.decorationLocator = (TemplateLocator)this.getComponent("DecorationLocator");
        String jetuiMode = Jetspeed.getConfiguration().getString("jetui.customization.method", "server");
        this.ajaxCustomization = jetuiMode.equals("ajax");
        this.capabilityMap = requestContext.getCapabilityMap();
        this.locale = requestContext.getLocale();
        this.templateLocatorDescriptor = this.templateLocator.createLocatorDescriptor(null);
        this.templateLocatorDescriptor.setMediaType(this.capabilityMap.getPreferredMediaType().getName());
        this.templateLocatorDescriptor.setCountry(this.locale.getCountry());
        this.templateLocatorDescriptor.setLanguage(this.locale.getLanguage());
        this.decorationLocatorDescriptor = this.decorationLocator.createLocatorDescriptor(null);
        this.decorationLocatorDescriptor.setMediaType(this.capabilityMap.getPreferredMediaType().getName());
        this.decorationLocatorDescriptor.setCountry(this.locale.getCountry());
        this.decorationLocatorDescriptor.setLanguage(this.locale.getLanguage());
        this.renderer = renderer;
    }

    protected final RequestContext getRequestContext() {
        return this.requestContext;
    }

    public WindowState getWindowState() throws Exception {
        try {
            PortletWindow window = this.getPortletWindow(this.getCurrentFragment());
            if (!window.isValid()) {
                return WindowState.NORMAL;
            }
            return this.getRequestContext().getPortalURL().getNavigationalState().getState(window);
        }
        catch (Exception e) {
            this.handleError(e, e.toString(), this.getCurrentFragment());
            return WindowState.NORMAL;
        }
    }

    public WindowState getMappedWindowState() throws Exception {
        try {
            PortletWindow window = this.getPortletWindow(this.getCurrentFragment());
            if (!window.isValid()) {
                return WindowState.NORMAL;
            }
            return this.getRequestContext().getPortalURL().getNavigationalState().getMappedState(window);
        }
        catch (Exception e) {
            this.handleError(e, e.toString(), this.getCurrentFragment());
            return WindowState.NORMAL;
        }
    }

    public PortletMode getPortletMode() throws Exception {
        try {
            PortletWindow window = this.getPortletWindow(this.getCurrentFragment());
            if (!window.isValid()) {
                return PortletMode.VIEW;
            }
            return this.getRequestContext().getPortalURL().getNavigationalState().getMode(window);
        }
        catch (Exception e) {
            this.handleError(e, e.toString(), this.getCurrentFragment());
            return PortletMode.VIEW;
        }
    }

    public PortletMode getMappedPortletMode() throws Exception {
        try {
            PortletWindow window = this.getPortletWindow(this.getCurrentFragment());
            if (!window.isValid()) {
                return PortletMode.VIEW;
            }
            return this.getRequestContext().getPortalURL().getNavigationalState().getMappedMode(window);
        }
        catch (Exception e) {
            this.handleError(e, e.toString(), this.getCurrentFragment());
            return PortletMode.VIEW;
        }
    }

    public ContentFragment getCurrentFragment() {
        this.checkState();
        return (ContentFragment)this.renderRequest.getAttribute("org.apache.jetspeed.Fragment");
    }

    public void setCurrentFragment(ContentFragment f) {
        this.checkState();
        this.setAttribute("org.apache.jetspeed.Fragment", f);
    }

    public void setCurrentLayout() {
        this.checkState();
        ContentFragment f = (ContentFragment)this.getRequestContext().getRequest().getAttribute("layout");
        this.setAttribute("layout", f);
    }

    public ContentFragment getCurrentLayout() {
        this.checkState();
        return (ContentFragment)this.renderRequest.getAttribute("layout");
    }

    public ContentPage getPage() {
        this.checkState();
        return this.requestContext.getPage();
    }

    public List[] getColumns() {
        this.checkState();
        return (List[])this.renderRequest.getAttribute(COLUMNS_ATTR);
    }

    public List getColumnSizes() {
        this.checkState();
        Object o = this.renderRequest.getAttribute(COLUMN_SIZES);
        if (o == null) {
            return null;
        }
        return (List)this.renderRequest.getAttribute(COLUMN_SIZES);
    }

    public PortletWindow getPortletWindow(ContentFragment f) throws Exception {
        return this.getRequestContext().getPortletWindow(f);
    }

    public boolean isHidden(ContentFragment f) {
        this.checkState();
        if (f == null) {
            throw new IllegalArgumentException("Fragment cannot be null for isHidden(Fragment)");
        }
        return f.getState() != null && f.getState().equals("hidden");
    }

    public TemplateDescriptor getTemplate(String path, String templateType) throws TemplateLocatorException {
        this.checkState();
        return this.getTemplate(path, templateType, this.templateLocator, this.templateLocatorDescriptor);
    }

    public Configuration getTypeConfiguration(String type, String name, String location) throws Exception {
        ArgUtil.assertNotNull(String.class, (Object)type, (Object)this, (String)"getTypeConfiguration(String type, String name)");
        ArgUtil.assertNotNull(String.class, (Object)name, (Object)this, (String)"getTypeConfiguration(String type, String name)");
        try {
            TemplateDescriptor locator = null;
            if (location.equals("templates")) {
                locator = this.getTemplate(name + "/" + type + ".properties", type);
            } else if (location.equals("decorations")) {
                locator = this.getDecoration(name + "/decorator.properties", type);
            } else {
                throw new IllegalArgumentException("Location type " + location + " is not supported by getTypeConfiguration().");
            }
            return new PropertiesConfiguration(locator.getAbsolutePath());
        }
        catch (TemplateLocatorException e) {
            log.warn(e.toString(), (Throwable)e);
            return null;
        }
    }

    public TemplateDescriptor getDecoration(String path, String templateType) throws TemplateLocatorException {
        this.checkState();
        return this.getTemplate(path, templateType, this.decorationLocator, this.decorationLocatorDescriptor);
    }

    public String includeTemplate(String template, String templateType) throws IOException {
        this.checkState();
        try {
            TemplateDescriptor useLocator = this.getTemplate(template, templateType);
            return useLocator.getAppRelativePath();
        }
        catch (Exception e) {
            PrintWriter directError = new PrintWriter(this.renderResponse.getWriter());
            directError.write("Error occured process includeTemplate(): " + e.toString() + "\n\n");
            e.printStackTrace(directError);
            directError.close();
            return "";
        }
    }

    public String includeDecoration(String template, String templateType) throws IOException {
        this.checkState();
        try {
            return this.getDecoration(template, templateType).getAppRelativePath();
        }
        catch (Exception e) {
            PrintWriter directError = new PrintWriter(this.renderResponse.getWriter());
            directError.write("Error occured process includeDecoration(): " + e.toString() + "\n\n");
            e.printStackTrace(directError);
            directError.close();
            return "";
        }
    }

    public String decorateAndInclude(ContentFragment f) throws Exception {
        this.setCurrentFragment(f);
        this.setCurrentLayout();
        try {
            return this.decorateAndIncludePortlet(f);
        }
        catch (Exception e) {
            this.renderResponse.getWriter().write(e.toString());
            return "";
        }
    }

    protected String decorateAndIncludePortlet(ContentFragment f) throws Exception {
        TemplateDescriptor template;
        PropertiesConfiguration decoConf;
        block4: {
            TemplateDescriptor propsTemp;
            String fragmentType = f.getType();
            String decorator = f.getDecorator();
            if (decorator == null) {
                decorator = this.getPage().getEffectiveDefaultDecorator(fragmentType);
            }
            if ((propsTemp = this.getTemplate(decorator + "/" + "decorator" + ".properties", fragmentType, this.decorationLocator, this.decorationLocatorDescriptor)) == null) {
                fragmentType = "generic";
                propsTemp = this.getTemplate(decorator + "/" + "decorator" + ".properties", fragmentType, this.decorationLocator, this.decorationLocatorDescriptor);
            }
            decoConf = new PropertiesConfiguration(propsTemp.getAbsolutePath());
            String ext = decoConf.getString("template.extension");
            String decoratorPath = decorator + "/" + "decorator" + ext;
            template = null;
            try {
                template = this.getDecoration(decoratorPath, fragmentType);
            }
            catch (TemplateLocatorException e) {
                String parent = decoConf.getString("extends");
                if (parent == null) break block4;
                template = this.getDecoration(parent + "/" + "decorator" + ext, fragmentType);
            }
        }
        this.setAttribute(DECORATOR_ID_ATTR, decoConf.getString("id"));
        this.setAttribute(ACTION_IMAGE_EXTENSION_ATTR, decoConf.getString("action.image.extension", ".gif"));
        return template.getAppRelativePath();
    }

    protected void checkState() {
        if (this.portletConfig == null || this.renderRequest == null || this.renderResponse == null) {
            throw new IllegalStateException("JetspeedPowerTool has not been properly initialized.  The JetspeedPowerTool generally only usuable during the rendering phase of  internal portlet applications.");
        }
    }

    protected TemplateDescriptor getTemplate(String path, String templateType, TemplateLocator locator, LocatorDescriptor descriptor) throws TemplateLocatorException {
        this.checkState();
        if (templateType == null) {
            templateType = "generic";
        }
        try {
            Path pathObject;
            descriptor.setName(path);
            descriptor.setType(templateType);
            TemplateDescriptor template = locator.locateTemplate(descriptor);
            if (template == null && (pathObject = new Path(path)).length() > 1) {
                template = this.getTemplate(pathObject.getSegment(1).toString(), templateType, locator, descriptor);
            }
            return template;
        }
        catch (TemplateLocatorException e) {
            log.error("Unable to locate template: " + path, (Throwable)e);
            throw e;
        }
    }

    protected void handleError(Exception e, String msg, ContentFragment fragment) {
        log.error(msg, (Throwable)e);
        HashSet<Exception> exceptions = (HashSet<Exception>)this.renderRequest.getAttribute("fragment.processing.error." + fragment.getId());
        if (exceptions == null) {
            exceptions = new HashSet<Exception>();
            this.setAttribute("fragment.processing.error." + fragment.getId(), exceptions);
        }
        exceptions.add(e);
    }

    public List getDecoratorActions() {
        return this.getCurrentFragment().getDecoration().getActions();
    }

    public List getPageDecoratorActions() throws Exception {
        return this.getCurrentFragment().getDecoration().getActions();
    }

    public String getTitle(ContentFragment f) {
        String title = null;
        if (f != null) {
            title = f.getTitle();
            if (title == null && f.getPortletContent() != null) {
                title = f.getPortletContent().getTitle();
            }
            if (title == null) {
                PortletDefinition portletDef;
                PortletWindow portletWindow = this.requestContext.getPortletWindow(f);
                if (portletWindow != null && (portletDef = portletWindow.getPortletDefinition()) != null && (title = this.requestContext.getPreferedLanguage(portletDef).getTitle()) == null) {
                    title = portletDef.getPortletName();
                }
                if (title == null && (title = f.getName()) != null && title.indexOf("::") > -1) {
                    title = title.substring(title.indexOf("::") + 2);
                }
            }
        }
        return title;
    }

    public String getTitle() {
        return this.getTitle(this.getCurrentFragment());
    }

    public Object getComponent(String name) {
        return Jetspeed.getComponentManager().getComponent((Object)name);
    }

    public String getAbsoluteUrl(String relativePath) {
        if (relativePath != null && relativePath.indexOf("://") == -1 && relativePath.indexOf("mailto:") == -1) {
            HttpServletRequest request = this.getRequestContext().getRequest();
            StringBuffer path = new StringBuffer();
            if (!this.getRequestContext().getPortalURL().isRelativeOnly()) {
                if (this.baseUrlAccess == null) {
                    path.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
                } else {
                    path.append(this.baseUrlAccess.getServerScheme()).append("://").append(this.baseUrlAccess.getServerName()).append(":").append(this.baseUrlAccess.getServerPort());
                }
            }
            return this.renderResponse.encodeURL(path.append(request.getContextPath()).append(request.getServletPath()).append(relativePath).toString());
        }
        return relativePath;
    }

    public Subject getSubject() {
        return this.requestContext.getSubject();
    }

    public boolean getLoggedOn() {
        Principal principal = this.requestContext.getRequest().getUserPrincipal();
        return principal != null;
    }

    public String getBasePath() {
        return this.getRequestContext().getPortalURL().getBasePath();
    }

    public String getPageBasePath() {
        return this.getRequestContext().getPortalURL().getPageBasePath();
    }

    @Override
    public void setVelocityContext(Context velocityContext) {
        this.velocityContext = velocityContext;
    }

    protected void setAttribute(String name, Object object) {
        this.renderRequest.setAttribute(name, object);
        if (this.velocityContext != null) {
            this.velocityContext.put(name, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderPortletWindow(String windowId, String portletUniqueName) {
        String string;
        if (windowId == null || portletUniqueName == null) {
            throw new IllegalArgumentException("Parameter windowId and portletUniqueName are both required");
        }
        RequestContext context = this.getRequestContext();
        PortletWindow window = context.getPortletWindow(windowId);
        if (window == null) {
            window = context.getInstantlyCreatedPortletWindow(windowId, portletUniqueName);
        }
        if (!window.isValid()) return "";
        PortletWindow currentPortletWindow = context.getCurrentPortletWindow();
        try {
            context.setCurrentPortletWindow(window);
            this.renderer.renderNow(window.getFragment(), context);
            string = window.getFragment().getRenderedContent();
        }
        catch (Throwable throwable) {
            try {
                context.setCurrentPortletWindow(currentPortletWindow);
                throw throwable;
            }
            catch (Exception e) {
                this.handleError(e, e.toString(), this.getCurrentFragment());
                return "";
            }
        }
        context.setCurrentPortletWindow(currentPortletWindow);
        return string;
    }

    public String getElementHtmlString(HeadElement headElement) {
        return HeadElementUtils.toHtmlString(headElement);
    }

    public List<KeyValue<String, HeadElement>> getHeadElements(ContentFragment f) throws Exception {
        return this.getPortletWindow(f).getHeadElements();
    }

    public List<KeyValue<String, HeadElement>> getHeadElements() throws Exception {
        return this.requestContext.getMergedHeadElements();
    }

    public boolean isDojoEnabled(List<KeyValue<String, HeadElement>> headElements) {
        for (KeyValue<String, HeadElement> kvPair : headElements) {
            if (!"header.dojo.library.include".equals(kvPair.getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean isAjaxCustomizationEnabled() {
        return this.ajaxCustomization;
    }

    public Map<String, String> getUserAttributes() {
        RequestContext rc = this.getRequestContext();
        Map map = null;
        Principal principal = rc.getRequest().getUserPrincipal();
        if (principal instanceof UserSubjectPrincipal) {
            UserSubjectPrincipal jp = (UserSubjectPrincipal)principal;
            map = jp.getUser().getInfoMap();
        }
        return map;
    }

    public String getUserAttribute(String attributeName, String defaultValue) {
        Map<String, String> infoMap = this.getUserAttributes();
        String value = infoMap != null ? infoMap.get(attributeName) : null;
        return value != null ? value : defaultValue;
    }

    public PortalConfiguration getPortalConfiguration() {
        return Jetspeed.getConfiguration();
    }
}

