/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.proxy.DynamicPageProxy;
import org.apache.jetspeed.om.page.proxy.FragmentDefinitionProxy;
import org.apache.jetspeed.om.page.proxy.LinkProxy;
import org.apache.jetspeed.om.page.proxy.PageProxy;
import org.apache.jetspeed.om.page.proxy.PageTemplateProxy;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.proxy.NodeProxy;
import org.apache.jetspeed.page.document.proxy.NodeSetImpl;
import org.apache.jetspeed.portalsite.view.SearchPathsSiteView;
import org.apache.jetspeed.portalsite.view.SiteViewSearchPath;

public class FolderProxy
extends NodeProxy
implements InvocationHandler {
    protected static final Method GET_ALL_METHOD = FolderProxy.reflectMethod(Folder.class, "getAll", null);
    protected static final Method GET_DEFAULT_PAGE_METHOD = FolderProxy.reflectMethod(Folder.class, "getDefaultPage", null);
    protected static final Method GET_DYNAMIC_PAGES_METHOD = FolderProxy.reflectMethod(Folder.class, "getDynamicPages", null);
    protected static final Method GET_DYNAMIC_PAGE_METHOD = FolderProxy.reflectMethod(Folder.class, "getDynamicPage", new Class[]{String.class});
    protected static final Method GET_FOLDERS_METHOD = FolderProxy.reflectMethod(Folder.class, "getFolders", null);
    protected static final Method GET_FOLDER_METHOD = FolderProxy.reflectMethod(Folder.class, "getFolder", new Class[]{String.class});
    protected static final Method GET_FRAGMENT_DEFINITIONS_METHOD = FolderProxy.reflectMethod(Folder.class, "getFragmentDefinitions", null);
    protected static final Method GET_FRAGMENT_DEFINITION_METHOD = FolderProxy.reflectMethod(Folder.class, "getFragmentDefinition", new Class[]{String.class});
    protected static final Method GET_LINKS_METHOD = FolderProxy.reflectMethod(Folder.class, "getLinks", null);
    protected static final Method GET_LINK_METHOD = FolderProxy.reflectMethod(Folder.class, "getLink", new Class[]{String.class});
    protected static final Method GET_MENU_DEFINITIONS_METHOD = FolderProxy.reflectMethod(Folder.class, "getMenuDefinitions", null);
    protected static final Method GET_METADATA_METHOD = FolderProxy.reflectMethod(Folder.class, "getMetadata", null);
    protected static final Method GET_NAME_METHOD = FolderProxy.reflectMethod(Folder.class, "getName", null);
    protected static final Method GET_PAGES_METHOD = FolderProxy.reflectMethod(Folder.class, "getPages", null);
    protected static final Method GET_PAGE_METHOD = FolderProxy.reflectMethod(Folder.class, "getPage", new Class[]{String.class});
    protected static final Method GET_PAGE_SECURITY_METHOD = FolderProxy.reflectMethod(Folder.class, "getPageSecurity", null);
    protected static final Method GET_PAGE_TEMPLATES_METHOD = FolderProxy.reflectMethod(Folder.class, "getPageTemplates", null);
    protected static final Method GET_PAGE_TEMPLATE_METHOD = FolderProxy.reflectMethod(Folder.class, "getPageTemplate", new Class[]{String.class});
    protected static final Method GET_SHORT_TITLE_LOCALE_METHOD = FolderProxy.reflectMethod(Folder.class, "getShortTitle", new Class[]{Locale.class});
    protected static final Method GET_SHORT_TITLE_METHOD = FolderProxy.reflectMethod(Folder.class, "getShortTitle", null);
    protected static final Method GET_TITLE_LOCALE_METHOD = FolderProxy.reflectMethod(Folder.class, "getTitle", new Class[]{Locale.class});
    protected static final Method GET_TITLE_METHOD = FolderProxy.reflectMethod(Folder.class, "getTitle", null);
    private Folder defaultFolder;
    private Folder titledFolder;
    private boolean forceReservedVisible;
    private NodeSet children;
    private boolean childrenAggregated;
    private NodeSet folders;
    private boolean foldersAggregated;
    private NodeSet pages;
    private boolean pagesAggregated;
    private NodeSet pageTemplates;
    private boolean pageTemplatesAggregated;
    private NodeSet dynamicPages;
    private boolean dynamicPagesAggregated;
    private NodeSet fragmentDefinitions;
    private boolean fragmentDefinitionsAggregated;
    private NodeSet links;
    private boolean linksAggregated;
    private List searchFolders;
    private List inheritanceFolders;

    public static Folder newInstance(SearchPathsSiteView view, String locatorName, Folder parentFolder, Folder folder, boolean forceReservedVisible) {
        return (Folder)Proxy.newProxyInstance(folder.getClass().getClassLoader(), new Class[]{Folder.class}, (InvocationHandler)new FolderProxy(view, locatorName, parentFolder, folder, forceReservedVisible));
    }

    private FolderProxy(SearchPathsSiteView view, String locatorName, Folder parentFolder, Folder folder, boolean forceReservedVisible) {
        super(view, locatorName, parentFolder, folder.getName(), folder.isHidden());
        this.defaultFolder = this.selectDefaultFromAggregateFolders(folder);
        this.titledFolder = this.selectTitledFromAggregateFolders(this.defaultFolder);
        this.forceReservedVisible = forceReservedVisible;
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(GET_ALL_METHOD)) {
            return this.getAll(proxy);
        }
        if (m.equals(GET_DEFAULT_PAGE_METHOD)) {
            return this.getDefaultPage(proxy);
        }
        if (m.equals(GET_DYNAMIC_PAGES_METHOD)) {
            return this.getDynamicPages(proxy);
        }
        if (m.equals(GET_DYNAMIC_PAGE_METHOD)) {
            return this.getDynamicPage(proxy, (String)args[0]);
        }
        if (m.equals(GET_FOLDERS_METHOD)) {
            return this.getFolders(proxy);
        }
        if (m.equals(GET_FOLDER_METHOD)) {
            return this.getFolder(proxy, (String)args[0]);
        }
        if (m.equals(GET_FRAGMENT_DEFINITIONS_METHOD)) {
            return this.getFragmentDefinitions(proxy);
        }
        if (m.equals(GET_FRAGMENT_DEFINITION_METHOD)) {
            return this.getFragmentDefinition(proxy, (String)args[0]);
        }
        if (m.equals(GET_LINKS_METHOD)) {
            return this.getLinks(proxy);
        }
        if (m.equals(GET_LINK_METHOD)) {
            return this.getLink(proxy, (String)args[0]);
        }
        if (m.equals(GET_MENU_DEFINITIONS_METHOD)) {
            return this.getMenuDefinitions();
        }
        if (m.equals(GET_METADATA_METHOD)) {
            return this.getMetadata();
        }
        if (m.equals(GET_NAME_METHOD)) {
            return this.getName();
        }
        if (m.equals(GET_PAGES_METHOD)) {
            return this.getPages(proxy);
        }
        if (m.equals(GET_PAGE_METHOD)) {
            return this.getPage(proxy, (String)args[0]);
        }
        if (m.equals(GET_PAGE_TEMPLATES_METHOD)) {
            return this.getPageTemplates(proxy);
        }
        if (m.equals(GET_PAGE_TEMPLATE_METHOD)) {
            return this.getPageTemplate(proxy, (String)args[0]);
        }
        if (m.equals(GET_SHORT_TITLE_LOCALE_METHOD)) {
            return this.getShortTitle((Locale)args[0]);
        }
        if (m.equals(GET_SHORT_TITLE_METHOD)) {
            return this.getShortTitle();
        }
        if (m.equals(GET_TITLE_LOCALE_METHOD)) {
            return this.getTitle((Locale)args[0]);
        }
        if (m.equals(GET_TITLE_METHOD)) {
            return this.getTitle();
        }
        if (m.equals(GET_PARENT_METHOD)) {
            return this.getParent();
        }
        if (m.equals(GET_PATH_METHOD)) {
            return this.getPath();
        }
        if (m.equals(GET_URL_METHOD)) {
            return this.getUrl();
        }
        if (m.equals(EQUALS_METHOD)) {
            return new Boolean(this.equals(args[0]));
        }
        if (m.equals(HASH_CODE_METHOD)) {
            return new Integer(this.hashCode());
        }
        if (m.equals(IS_HIDDEN_METHOD)) {
            return new Boolean(this.isHidden());
        }
        if (m.equals(TO_STRING_METHOD)) {
            return this.toString();
        }
        if (m.equals(GET_PAGE_SECURITY_METHOD) || m.getName().startsWith("set")) {
            throw new RuntimeException("Folder instance is immutable from proxy.");
        }
        try {
            return m.invoke((Object)this.defaultFolder, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public NodeSet getAll(Object proxy) throws DocumentException {
        if (!this.childrenAggregated) {
            this.children = this.aggregateChildren(proxy);
            this.childrenAggregated = true;
        }
        return this.children;
    }

    public String getDefaultPage(Object proxy) {
        return this.selectDefaultPageFromAggregateFolders(proxy);
    }

    public NodeSet getFolders(Object proxy) throws DocumentException {
        if (!this.foldersAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.folders = allChildren.subset("folder");
            }
            this.foldersAggregated = true;
        }
        return this.folders;
    }

    public Folder getFolder(Object proxy, String name) throws FolderNotFoundException, DocumentException {
        Folder folder;
        NodeSet allFolders = this.getFolders(proxy);
        if (allFolders != null && (folder = (Folder)allFolders.get(name)) != null) {
            return folder;
        }
        throw new FolderNotFoundException("Folder " + name + " not found at " + this.getPath());
    }

    public NodeSet getLinks(Object proxy) throws NodeException {
        if (!this.linksAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.links = allChildren.subset(".link");
            }
            this.linksAggregated = true;
        }
        return this.links;
    }

    public Link getLink(Object proxy, String name) throws DocumentNotFoundException, NodeException {
        Link link;
        NodeSet allLinks = this.getLinks(proxy);
        if (allLinks != null && (link = (Link)allLinks.get(name)) != null) {
            return link;
        }
        throw new DocumentNotFoundException("Link " + name + " not found at " + this.getPath());
    }

    public String getName() {
        if (this.getPath().equals("/")) {
            return "/";
        }
        return this.defaultFolder.getName();
    }

    public NodeSet getPages(Object proxy) throws NodeException {
        if (!this.pagesAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.pages = allChildren.subset(".psml");
            }
            this.pagesAggregated = true;
        }
        return this.pages;
    }

    public Page getPage(Object proxy, String name) throws PageNotFoundException, NodeException {
        Page page;
        NodeSet allPages = this.getPages(proxy);
        if (allPages != null && (page = (Page)allPages.get(name)) != null) {
            return page;
        }
        throw new PageNotFoundException("Page " + name + " not found at " + this.getPath());
    }

    public NodeSet getDynamicPages(Object proxy) throws NodeException {
        if (!this.dynamicPagesAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.dynamicPages = allChildren.subset(".dpsml");
            }
            this.dynamicPagesAggregated = true;
        }
        return this.dynamicPages;
    }

    public DynamicPage getDynamicPage(Object proxy, String name) throws PageNotFoundException, NodeException {
        DynamicPage dynamicPage;
        NodeSet allDynamicPages = this.getDynamicPages(proxy);
        if (allDynamicPages != null && (dynamicPage = (DynamicPage)allDynamicPages.get(name)) != null) {
            return dynamicPage;
        }
        throw new PageNotFoundException("DynamicPage " + name + " not found at " + this.getPath());
    }

    public NodeSet getPageTemplates(Object proxy) throws NodeException {
        if (!this.pageTemplatesAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.pageTemplates = allChildren.subset(".tpsml");
            }
            this.pageTemplatesAggregated = true;
        }
        return this.pageTemplates;
    }

    public PageTemplate getPageTemplate(Object proxy, String name) throws PageNotFoundException, NodeException {
        PageTemplate pageTemplate;
        NodeSet allPageTemplates = this.getPageTemplates(proxy);
        if (allPageTemplates != null && (pageTemplate = (PageTemplate)allPageTemplates.get(name)) != null) {
            return pageTemplate;
        }
        throw new PageNotFoundException("PageTemplate " + name + " not found at " + this.getPath());
    }

    public NodeSet getFragmentDefinitions(Object proxy) throws NodeException {
        if (!this.fragmentDefinitionsAggregated) {
            NodeSet allChildren = this.getAll(proxy);
            if (allChildren != null) {
                this.fragmentDefinitions = allChildren.subset(".fpsml");
            }
            this.fragmentDefinitionsAggregated = true;
        }
        return this.fragmentDefinitions;
    }

    public FragmentDefinition getFragmentDefinition(Object proxy, String name) throws PageNotFoundException, NodeException {
        FragmentDefinition fragmentDefinition;
        NodeSet allFragmentDefinitions = this.getFragmentDefinitions(proxy);
        if (allFragmentDefinitions != null && (fragmentDefinition = (FragmentDefinition)allFragmentDefinitions.get(name)) != null) {
            return fragmentDefinition;
        }
        throw new PageNotFoundException("FragmentDefinition " + name + " not found at " + this.getPath());
    }

    public GenericMetadata getMetadata() {
        return this.titledFolder.getMetadata();
    }

    public String getTitle() {
        return this.titledFolder.getTitle();
    }

    public String getShortTitle() {
        return this.titledFolder.getShortTitle();
    }

    public String getTitle(Locale locale) {
        return this.titledFolder.getTitle(locale);
    }

    public String getShortTitle(Locale locale) {
        return this.titledFolder.getShortTitle(locale);
    }

    public Folder getDefaultFolder() {
        return this.defaultFolder;
    }

    public void checkAccessToFolderNotFound(String folderName) {
        try {
            for (SearchFolder searchFolder : this.getSearchFolders()) {
                Folder folder = searchFolder.folder;
                try {
                    folder.getFolder(folderName);
                }
                catch (DocumentException de) {
                }
                catch (FolderNotFoundException fnfe) {}
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            // empty catch block
        }
    }

    public void checkAccessToNodeNotFound(String nodeName) {
        try {
            for (SearchFolder searchFolder : this.getSearchFolders()) {
                Folder folder = searchFolder.folder;
                try {
                    folder.getFolder(nodeName);
                }
                catch (DocumentException de) {
                }
                catch (FolderNotFoundException fnfe) {
                    // empty catch block
                }
                try {
                    folder.getPage(nodeName);
                }
                catch (NodeException ne) {
                }
                catch (PageNotFoundException ne) {
                    // empty catch block
                }
                try {
                    folder.getLink(nodeName);
                }
                catch (NodeException ne) {
                }
                catch (DocumentNotFoundException ne) {}
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            // empty catch block
        }
    }

    protected void aggregateMenuDefinitionLocators() {
        try {
            for (InheritanceFolder inheritanceFolder : this.getInheritanceFolders()) {
                Folder folder = inheritanceFolder.folder;
                String path = inheritanceFolder.path;
                this.mergeMenuDefinitionLocators(folder.getMenuDefinitions(), (Node)folder, path, false);
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            // empty catch block
        }
        this.mergeMenuDefinitionLocators(this.getView().getStandardMenuDefinitionLocators());
    }

    private Folder selectDefaultFromAggregateFolders(Folder defaultFolder) {
        try {
            return ((SearchFolder)this.getSearchFolders().get((int)0)).folder;
        }
        catch (FolderNotFoundException folderNotFoundException) {
            return defaultFolder;
        }
    }

    private Folder selectTitledFromAggregateFolders(Folder defaultFolder) {
        try {
            Iterator foldersIter = this.getSearchFolders().iterator();
            while (foldersIter.hasNext()) {
                Folder folder = ((SearchFolder)foldersIter.next()).folder;
                String name = folder.getName();
                String title = folder.getTitle();
                String shortTitle = folder.getShortTitle();
                GenericMetadata folderMetadata = folder.getMetadata();
                if (!(title != null && !title.equalsIgnoreCase(name) || shortTitle != null && !shortTitle.equalsIgnoreCase(name)) && (folderMetadata == null || folderMetadata.getFields() == null || folderMetadata.getFields().isEmpty())) continue;
                return folder;
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            // empty catch block
        }
        return defaultFolder;
    }

    private String selectDefaultPageFromAggregateFolders(Object proxy) {
        try {
            boolean fallbackDefaultPageNotFound = false;
            Iterator foldersIter = this.getSearchFolders().iterator();
            while (foldersIter.hasNext()) {
                Folder folder = ((SearchFolder)foldersIter.next()).folder;
                String defaultPageName = folder.getDefaultPage();
                if (defaultPageName != null) {
                    if (defaultPageName.equals("..")) {
                        if (this.getParent() == null) continue;
                        return defaultPageName;
                    }
                    try {
                        this.getPage(proxy, defaultPageName);
                        return defaultPageName;
                    }
                    catch (NodeException ne) {
                    }
                    catch (NodeNotFoundException nnfe) {
                    }
                    catch (SecurityException se) {
                        // empty catch block
                    }
                    if (defaultPageName.endsWith(".psml")) continue;
                    try {
                        this.getFolder(proxy, defaultPageName);
                        return defaultPageName;
                    }
                    catch (NodeException ne) {
                        continue;
                    }
                    catch (NodeNotFoundException nnfe) {
                        continue;
                    }
                    catch (SecurityException se) {
                        continue;
                    }
                }
                if (fallbackDefaultPageNotFound) continue;
                try {
                    this.getPage(proxy, "default-page.psml");
                    return "default-page.psml";
                }
                catch (NodeException ne) {
                    fallbackDefaultPageNotFound = true;
                }
                catch (NodeNotFoundException nnfe) {
                    fallbackDefaultPageNotFound = true;
                }
                catch (SecurityException se) {
                    fallbackDefaultPageNotFound = true;
                }
            }
        }
        catch (FolderNotFoundException folderNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private NodeSet aggregateChildren(Object proxy) {
        try {
            ArrayList<Object> allChildren = new ArrayList<Object>();
            List folderDocumentOrder = null;
            for (SearchFolder searchFolder : this.getSearchFolders()) {
                List documentOrder;
                Folder folder = searchFolder.folder;
                String locatorName = searchFolder.locatorName;
                NodeSet children = folder.getAll();
                for (Node child : children) {
                    String childName = child.getName();
                    boolean visible = this.forceReservedVisible || !(child instanceof Folder) || !childName.startsWith("__") && !childName.startsWith("_");
                    if (!visible) continue;
                    boolean childUnique = true;
                    Iterator allChildrenIter = allChildren.iterator();
                    while (childUnique && allChildrenIter.hasNext()) {
                        childUnique = !childName.equals(((Node)allChildrenIter.next()).getName());
                    }
                    if (!childUnique) continue;
                    if (child instanceof Folder) {
                        allChildren.add(FolderProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (Folder)child, this.forceReservedVisible));
                        continue;
                    }
                    if (child instanceof Page) {
                        allChildren.add(PageProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (Page)child));
                        continue;
                    }
                    if (child instanceof PageTemplate) {
                        allChildren.add(PageTemplateProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (PageTemplate)child));
                        continue;
                    }
                    if (child instanceof DynamicPage) {
                        allChildren.add(DynamicPageProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (DynamicPage)child));
                        continue;
                    }
                    if (child instanceof FragmentDefinition) {
                        allChildren.add(FragmentDefinitionProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (FragmentDefinition)child));
                        continue;
                    }
                    if (!(child instanceof Link)) continue;
                    allChildren.add(LinkProxy.newInstance(this.getView(), locatorName, (Folder)proxy, (Link)child));
                }
                if (folderDocumentOrder != null || (documentOrder = folder.getDocumentOrder()) == null || documentOrder.isEmpty()) continue;
                folderDocumentOrder = documentOrder;
            }
            if (allChildren.size() > 1) {
                final List order = folderDocumentOrder;
                Comparator comparator = new Comparator(){

                    public int compare(Object proxyNode1, Object proxyNode2) {
                        String name1 = ((Node)proxyNode1).getName();
                        String name2 = ((Node)proxyNode2).getName();
                        if (order != null) {
                            int index1 = order.indexOf(name1);
                            int index2 = order.indexOf(name2);
                            if (index1 != -1 || index2 != -1) {
                                if (index1 == -1 && index2 != -1) {
                                    return 1;
                                }
                                if (index1 != -1 && index2 == -1) {
                                    return -1;
                                }
                                return index1 - index2;
                            }
                        }
                        return name1.compareTo(name2);
                    }
                };
                Collections.sort(allChildren, comparator);
            }
            if (!allChildren.isEmpty()) {
                return new NodeSetImpl(allChildren);
            }
        }
        catch (FolderNotFoundException fnfe) {
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        return null;
    }

    private List getSearchFolders() throws FolderNotFoundException {
        if (this.searchFolders == null) {
            List searchPaths = this.getView().getSearchPaths();
            this.searchFolders = new ArrayList(searchPaths.size());
            for (SiteViewSearchPath searchPath : searchPaths) {
                String path = searchPath.toString();
                path = !path.equals("/") ? path + this.getPath() : this.getPath();
                try {
                    Folder folder = this.getView().getPageManager().getFolder(path);
                    if (folder == null) continue;
                    this.searchFolders.add(new SearchFolder(folder, searchPath.getLocatorName()));
                }
                catch (NodeException ne) {
                }
                catch (NodeNotFoundException ne) {
                }
                catch (SecurityException se) {}
            }
        }
        if (!this.searchFolders.isEmpty()) {
            return this.searchFolders;
        }
        throw new FolderNotFoundException("Search folders at " + this.getPath() + " not found or accessible");
    }

    private List getInheritanceFolders() throws FolderNotFoundException {
        if (this.inheritanceFolders == null) {
            FolderProxy folder = this;
            List searchFolders = folder.getSearchFolders();
            this.inheritanceFolders = this.getParent() != null ? new ArrayList(searchFolders.size() * 2) : new ArrayList(searchFolders.size());
            do {
                Iterator foldersIter = searchFolders.iterator();
                while (foldersIter.hasNext()) {
                    this.inheritanceFolders.add(new InheritanceFolder(((SearchFolder)foldersIter.next()).folder, folder.getPath()));
                }
                if ((folder = (FolderProxy)FolderProxy.getNodeProxy(folder.getParent())) == null) continue;
                searchFolders = folder.getSearchFolders();
            } while (folder != null);
        }
        if (!this.inheritanceFolders.isEmpty()) {
            return this.inheritanceFolders;
        }
        throw new FolderNotFoundException("Inheritance folders at " + this.getPath() + " not found or accessible");
    }

    public static FolderProxy getFolderProxy(Object folder) {
        InvocationHandler folderProxyHandler;
        if (folder != null && Proxy.isProxyClass(folder.getClass()) && (folderProxyHandler = Proxy.getInvocationHandler(folder)) instanceof FolderProxy) {
            return (FolderProxy)folderProxyHandler;
        }
        return null;
    }

    private class InheritanceFolder {
        public Folder folder;
        public String path;

        public InheritanceFolder(Folder folder, String path) {
            this.folder = folder;
            this.path = path;
        }
    }

    private class SearchFolder {
        public Folder folder;
        public String locatorName;

        public SearchFolder(Folder folder, String locatorName) {
            this.folder = folder;
            this.locatorName = locatorName;
        }
    }
}

