/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.proxy.FolderProxy;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.proxy.NodeProxy;
import org.apache.jetspeed.portalsite.view.SearchPathsSiteView;

public class DynamicPageProxy
extends NodeProxy
implements InvocationHandler {
    protected static final Method GET_MENU_DEFINITIONS_METHOD = DynamicPageProxy.reflectMethod(DynamicPage.class, "getMenuDefinitions", null);
    private DynamicPage dynamicPage;

    public static DynamicPage newInstance(SearchPathsSiteView view, String locatorName, Folder parentFolder, DynamicPage dynamicPage) {
        return (DynamicPage)Proxy.newProxyInstance(dynamicPage.getClass().getClassLoader(), new Class[]{DynamicPage.class}, (InvocationHandler)new DynamicPageProxy(view, locatorName, parentFolder, dynamicPage));
    }

    private DynamicPageProxy(SearchPathsSiteView view, String locatorName, Folder parentFolder, DynamicPage dynamicPage) {
        super(view, locatorName, parentFolder, dynamicPage.getName(), dynamicPage.isHidden());
        this.dynamicPage = dynamicPage;
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(GET_MENU_DEFINITIONS_METHOD)) {
            return this.getMenuDefinitions();
        }
        if (m.equals(GET_PARENT_METHOD)) {
            return this.getParent();
        }
        if (m.equals(GET_PATH_METHOD)) {
            return this.getPath();
        }
        if (m.equals(GET_URL_METHOD)) {
            return this.getUrl();
        }
        if (m.equals(EQUALS_METHOD)) {
            return new Boolean(this.equals(args[0]));
        }
        if (m.equals(HASH_CODE_METHOD)) {
            return new Integer(this.hashCode());
        }
        if (m.equals(IS_HIDDEN_METHOD)) {
            return new Boolean(this.isHidden());
        }
        if (m.equals(TO_STRING_METHOD)) {
            return this.toString();
        }
        if (m.getName().startsWith("set")) {
            throw new RuntimeException("DynamicPage instance is immutable from proxy.");
        }
        try {
            return m.invoke((Object)this.dynamicPage, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public DynamicPage getDynamicPage() {
        return this.dynamicPage;
    }

    protected void aggregateMenuDefinitionLocators() {
        FolderProxy parentFolderProxy = FolderProxy.getFolderProxy(this.getParent());
        this.mergeMenuDefinitionLocators(this.dynamicPage.getMenuDefinitions(), (Node)this.dynamicPage, parentFolderProxy.getPath(), true);
        this.mergeMenuDefinitionLocators(parentFolderProxy.getMenuDefinitionLocators());
    }
}

