/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.Locale;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.MenuElement;
import org.apache.jetspeed.portalsite.impl.MenuImpl;
import org.apache.jetspeed.portalsite.view.AbstractSiteView;

public abstract class MenuElementImpl
implements MenuElement,
Cloneable {
    private AbstractSiteView view;
    private MenuImpl parent;
    private Node node;
    private String skin;
    private boolean skinInherited;

    protected MenuElementImpl(AbstractSiteView view, MenuImpl parent) {
        this.view = view;
        this.parent = parent;
    }

    protected MenuElementImpl(AbstractSiteView view, MenuImpl parent, Node node) {
        this(view, parent);
        this.node = node;
    }

    public Object clone() throws CloneNotSupportedException {
        MenuElementImpl copy = (MenuElementImpl)super.clone();
        copy.parent = null;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this.getClass().equals(obj.getClass())) {
            String url = this.getUrl();
            String name = this.getName();
            if (url != null || name != null) {
                String objUrl = ((MenuElementImpl)obj).getUrl();
                String objName = ((MenuElementImpl)obj).getName();
                return (name == null && objName == null || name != null && name.equals(objName)) && (url != null && url.equals(objUrl) || url == null && objUrl == null);
            }
        }
        return false;
    }

    public abstract String getElementType();

    protected AbstractSiteView getView() {
        return this.view;
    }

    public Menu getParentMenu() {
        return this.parent;
    }

    protected void setParentMenu(Menu parentMenu) {
        this.parent = (MenuImpl)parentMenu;
    }

    public String getName() {
        return null;
    }

    public String getUrl() {
        return null;
    }

    public String getTitle() {
        if (this.node != null) {
            return this.node.getTitle();
        }
        return this.getName();
    }

    public String getShortTitle() {
        if (this.node != null) {
            return this.node.getShortTitle();
        }
        return this.getName();
    }

    public String getTitle(Locale locale) {
        if (this.node != null) {
            return this.node.getTitle(locale);
        }
        return this.getName();
    }

    public String getShortTitle(Locale locale) {
        if (this.node != null) {
            return this.node.getShortTitle(locale);
        }
        return this.getName();
    }

    public GenericMetadata getMetadata() {
        GenericMetadata metadata;
        if (this.node != null && (metadata = this.node.getMetadata()) != null && metadata.getFields() != null && !metadata.getFields().isEmpty()) {
            return metadata;
        }
        return null;
    }

    public String getSkin() {
        if (!this.skinInherited) {
            if (this.parent != null) {
                this.skin = this.parent.getSkin();
            }
            this.skinInherited = true;
        }
        return this.skin;
    }

    public Node getNode() {
        return this.node;
    }

    protected void setNode(Node node) {
        this.node = node;
    }

    public boolean isEditable() {
        try {
            this.getNode().checkAccess(JetspeedActions.EDIT);
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public Node getManagedNode() {
        if (this.view != null) {
            Node node = this.getNode();
            if (node instanceof Page) {
                return this.view.getManagedPage((Page)node);
            }
            if (node instanceof Link) {
                return this.view.getManagedLink((Link)node);
            }
            if (node instanceof Folder) {
                return this.view.getManagedFolder((Folder)node);
            }
        }
        return null;
    }
}

