/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.MenuElement;
import org.apache.jetspeed.portalsite.MenuOption;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.impl.MenuElementImpl;
import org.apache.jetspeed.portalsite.impl.MenuOptionImpl;
import org.apache.jetspeed.portalsite.impl.MenuSeparatorImpl;
import org.apache.jetspeed.portalsite.impl.PortalSiteRequestContextImpl;
import org.apache.jetspeed.portalsite.impl.PortalSiteSessionContextImpl;
import org.apache.jetspeed.portalsite.menu.DefaultMenuDefinition;
import org.apache.jetspeed.portalsite.menu.DefaultMenuOptionsDefinition;
import org.apache.jetspeed.portalsite.view.AbstractSiteView;

public class MenuImpl
extends MenuElementImpl
implements Menu,
Cloneable {
    private MenuDefinition definition;
    private List elements;
    private boolean elementRelative;

    public MenuImpl(MenuDefinition definition, String path, PortalSiteRequestContextImpl context, Set menus) {
        this(null, definition, path, context, menus);
    }

    public MenuImpl(MenuImpl parent, MenuDefinition definition, String path, PortalSiteRequestContextImpl context, Set menus) {
        this(((PortalSiteSessionContextImpl)context.getSessionContext()).getSiteView(), parent, definition, path, context, menus);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MenuImpl(AbstractSiteView view, MenuImpl parent, MenuDefinition definition, String path, PortalSiteRequestContextImpl context, Set menus) {
        super(view, parent);
        boolean bl;
        this.definition = definition;
        if (view == null) return;
        String options = definition.getOptions();
        Node optionView = null;
        if (options != null && options.indexOf(44) == -1) {
            try {
                optionView = view.getNodeView(options, (Node)context.getPageOrTemplate(), path, true, true, true);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (optionView != null) {
                this.setNode(optionView);
            }
        }
        if (definition.getMenuElements() == null || definition.getMenuElements().isEmpty()) {
            void var9_16;
            Object var9_12 = null;
            if (optionView != null) {
                if (optionView instanceof Folder && !definition.isPaths() && definition.getDepth() != 0) {
                    String folderChildrenPath = null;
                    folderChildrenPath = !options.endsWith("/") ? options + "/" + "*" : options + "*";
                    List folderChildren = null;
                    try {
                        folderChildren = view.getNodeViews(folderChildrenPath, (Node)context.getPageOrTemplate(), path, true, true, true);
                    }
                    catch (NodeNotFoundException nnfe) {
                    }
                    catch (SecurityException se) {
                        // empty catch block
                    }
                    if (folderChildren == null || folderChildren.isEmpty()) return;
                    List list = folderChildren;
                } else {
                    ArrayList<Node> arrayList = new ArrayList<Node>(1);
                    arrayList.add(optionView);
                }
                this.elementRelative = this.elementRelative || !options.startsWith("/") || options.contains("@");
            }
            this.elements = this.constructMenuElements(view, context, path, options, (List)var9_16, definition.getDepth(), definition.isPaths(), definition.isRegexp(), definition.getProfile(), definition.getOrder());
            return;
        }
        boolean bl2 = false;
        if (definition.getName() != null && parent == null) {
            if (menus == null) {
                menus = new HashSet(4);
            }
            bl = menus.add(definition.getName());
        }
        MenuSeparatorImpl separator = null;
        List separatedElements = null;
        for (Object menuElement : definition.getMenuElements()) {
            if (menuElement instanceof MenuOptionsDefinition) {
                List optionsAndMenus;
                String order;
                MenuOptionsDefinition optionDefinition = (MenuOptionsDefinition)menuElement;
                String locatorName = optionDefinition.getProfile();
                if (locatorName == null) {
                    locatorName = definition.getProfile();
                }
                if ((order = optionDefinition.getOrder()) == null) {
                    order = definition.getOrder();
                }
                if ((optionsAndMenus = this.constructMenuElements(view, context, path, optionDefinition.getOptions(), null, optionDefinition.getDepth(), optionDefinition.isPaths(), optionDefinition.isRegexp(), locatorName, order)) == null) continue;
                if (separatedElements == null) {
                    separatedElements = optionsAndMenus;
                    continue;
                }
                this.appendMenuElements(optionsAndMenus, separatedElements);
                continue;
            }
            if (menuElement instanceof MenuSeparatorDefinition) {
                if (separatedElements != null && !separatedElements.isEmpty()) {
                    if (this.elements == null) {
                        int initialSize = separatedElements.size();
                        if (separator != null) {
                            ++initialSize;
                        }
                        this.elements = new ArrayList(initialSize);
                    }
                    if (separator != null) {
                        this.elements.add(separator);
                    }
                    this.elements.addAll(separatedElements);
                }
                MenuSeparatorDefinition separatorDefinition = (MenuSeparatorDefinition)menuElement;
                separator = new MenuSeparatorImpl(view, this, separatorDefinition);
                if (separatedElements == null) continue;
                separatedElements.clear();
                continue;
            }
            if (menuElement instanceof MenuDefinition) {
                MenuDefinition menuDefinition = (MenuDefinition)menuElement;
                MenuImpl nestedMenu = new MenuImpl(view, this, menuDefinition, path, context, menus);
                if (separatedElements == null) {
                    separatedElements = new ArrayList(1);
                }
                this.appendMenuElement(nestedMenu, separatedElements);
                this.elementRelative = this.elementRelative || nestedMenu.isElementRelative();
                continue;
            }
            if (menuElement instanceof MenuIncludeDefinition) {
                MenuIncludeDefinition includeDefinition = (MenuIncludeDefinition)menuElement;
                if (menus != null && menus.contains(includeDefinition.getName())) continue;
                MenuImpl includeMenu = null;
                try {
                    includeMenu = (MenuImpl)context.getMenu(includeDefinition.getName());
                }
                catch (NodeNotFoundException nnfe) {
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                if (includeMenu == null) continue;
                if (includeDefinition.isNest()) {
                    try {
                        includeMenu = (MenuImpl)includeMenu.clone();
                        includeMenu.setParentMenu(this);
                        if (separatedElements == null) {
                            separatedElements = new ArrayList(1);
                        }
                        this.appendMenuElement(includeMenu, separatedElements);
                    }
                    catch (CloneNotSupportedException cnse) {}
                } else if (!includeMenu.isEmpty()) {
                    for (MenuElementImpl includeElement : includeMenu.getElements()) {
                        try {
                            includeElement = (MenuElementImpl)includeElement.clone();
                            includeElement.setParentMenu(this);
                            if (includeElement instanceof MenuSeparatorImpl) {
                                if (separatedElements != null && !separatedElements.isEmpty()) {
                                    if (this.elements == null) {
                                        int initialSize = separatedElements.size();
                                        if (separator != null) {
                                            ++initialSize;
                                        }
                                        this.elements = new ArrayList(initialSize);
                                    }
                                    if (separator != null) {
                                        this.elements.add(separator);
                                    }
                                    this.elements.addAll(separatedElements);
                                }
                                separator = (MenuSeparatorImpl)includeElement;
                                if (separatedElements == null) continue;
                                separatedElements.clear();
                                continue;
                            }
                            if (separatedElements == null) {
                                separatedElements = new ArrayList(includeMenu.getElements().size());
                            }
                            this.appendMenuElement(includeElement, separatedElements);
                        }
                        catch (CloneNotSupportedException cnse) {}
                    }
                }
                this.elementRelative = this.elementRelative || includeMenu.isElementRelative();
                continue;
            }
            if (!(menuElement instanceof MenuExcludeDefinition) || separatedElements == null || separatedElements.isEmpty()) continue;
            MenuExcludeDefinition excludeDefinition = (MenuExcludeDefinition)menuElement;
            if (menus != null && menus.contains(excludeDefinition.getName())) continue;
            MenuImpl excludeMenu = null;
            try {
                excludeMenu = (MenuImpl)context.getMenu(excludeDefinition.getName());
            }
            catch (NodeNotFoundException nnfe) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (excludeMenu == null) continue;
            this.removeMenuElements(excludeMenu.getElements(), separatedElements);
            this.elementRelative = this.elementRelative || excludeMenu.isElementRelative();
        }
        if (separatedElements != null && !separatedElements.isEmpty()) {
            if (this.elements == null) {
                this.elements = separatedElements;
                if (separator != null) {
                    this.elements.add(0, separator);
                }
            } else {
                if (separator != null) {
                    this.elements.add(separator);
                }
                this.elements.addAll(separatedElements);
            }
        }
        if (!bl) return;
        menus.remove(definition.getName());
    }

    private void appendMenuElement(MenuElementImpl appendMenuElement, List menuElements) {
        if (appendMenuElement != null && !menuElements.contains(appendMenuElement)) {
            menuElements.add(appendMenuElement);
        }
    }

    private void appendMenuElements(List appendMenuElements, List menuElements) {
        if (appendMenuElements != null) {
            Iterator elementsIter = appendMenuElements.iterator();
            while (elementsIter.hasNext()) {
                this.appendMenuElement((MenuElementImpl)elementsIter.next(), menuElements);
            }
        }
    }

    private void removeMenuElements(List removeMenuElements, List menuElements) {
        if (removeMenuElements != null) {
            menuElements.removeAll(removeMenuElements);
        }
    }

    private List constructMenuElements(AbstractSiteView view, PortalSiteRequestContextImpl context, String path, String options, List overrideElementViews, int depth, boolean paths, boolean regexp, String locatorName, String order) {
        if (options != null) {
            ArrayList<Node> elementViews = overrideElementViews;
            if (elementViews == null) {
                String[] optionPaths = options.split(",");
                for (int i = 0; i < optionPaths.length; ++i) {
                    String optionPath = optionPaths[i].trim();
                    if (optionPath.length() <= 0) continue;
                    if (regexp) {
                        List pathViews = null;
                        try {
                            pathViews = view.getNodeViews(optionPath, (Node)context.getPageOrTemplate(), path, true, true, true);
                        }
                        catch (NodeNotFoundException nnfe) {
                        }
                        catch (SecurityException se) {
                            // empty catch block
                        }
                        if (pathViews != null) {
                            for (Node pathView : pathViews) {
                                if (locatorName != null && !locatorName.equals("*") && !locatorName.equals(view.getProfileLocatorName(pathView))) continue;
                                if (elementViews == null) {
                                    elementViews = new ArrayList();
                                }
                                this.appendMenuElementViews(pathView, elementViews);
                            }
                        }
                    } else {
                        Node pathView = null;
                        try {
                            pathView = view.getNodeView(optionPath, (Node)context.getPageOrTemplate(), path, true, true, true);
                        }
                        catch (NodeNotFoundException nnfe) {
                        }
                        catch (SecurityException se) {
                            // empty catch block
                        }
                        if (pathView != null && (locatorName == null || locatorName.equals("*") || locatorName.equals(view.getProfileLocatorName(pathView)))) {
                            if (elementViews == null) {
                                elementViews = new ArrayList();
                            }
                            this.appendMenuElementViews(pathView, elementViews);
                        }
                    }
                    this.elementRelative = this.elementRelative || !optionPath.startsWith("/") || options.contains("@");
                }
                if (elementViews == null) {
                    return null;
                }
            }
            if (order != null && elementViews.size() > 1) {
                ArrayList<Node> orderedElementViews = new ArrayList<Node>(elementViews.size());
                String[] orderings = MenuImpl.orderRegexpPattern(order).split(",");
                for (int i = 0; i < orderings.length && elementViews.size() > 1; ++i) {
                    String ordering = orderings[i].trim();
                    if (ordering.length() <= 0) continue;
                    Pattern pattern = Pattern.compile(ordering);
                    Matcher matcher = null;
                    Iterator elementViewsIter = elementViews.iterator();
                    while (elementViewsIter.hasNext()) {
                        Node elementView = (Node)elementViewsIter.next();
                        String test = null;
                        test = ordering.charAt(0) == '/' ? elementView.getUrl() : elementView.getName();
                        if (matcher == null) {
                            matcher = pattern.matcher(test);
                        } else {
                            matcher.reset(test);
                        }
                        if (!matcher.matches()) continue;
                        orderedElementViews.add(elementView);
                        elementViewsIter.remove();
                    }
                }
                orderedElementViews.addAll(elementViews);
                elementViews = orderedElementViews;
            }
            if (paths && depth == 0 && elementViews.size() == 1 && (elementViews.get(0) instanceof Folder || elementViews.get(0) instanceof Page)) {
                for (Node parentNode = ((Node)elementViews.get(0)).getParent(); parentNode != null; parentNode = parentNode.getParent()) {
                    elementViews.add(0, parentNode);
                }
            }
            DefaultMenuOptionsDefinition defaultMenuOptionsDefinition = null;
            ListIterator<MenuOptionImpl> elementViewsIter = elementViews.listIterator();
            while (elementViewsIter.hasNext()) {
                Node elementView = (Node)elementViewsIter.next();
                MenuElementImpl menuElement = null;
                if (elementView instanceof Folder && (depth < 0 || depth > 1) && !paths) {
                    DefaultMenuDefinition nestedMenuDefinition = new DefaultMenuDefinition(elementView.getUrl(), depth - 1, locatorName);
                    menuElement = new MenuImpl(view, this, nestedMenuDefinition, null, context, null);
                } else {
                    if (defaultMenuOptionsDefinition == null) {
                        defaultMenuOptionsDefinition = new DefaultMenuOptionsDefinition(options, depth, paths, regexp, locatorName, order);
                    }
                    menuElement = new MenuOptionImpl(view, this, elementView, defaultMenuOptionsDefinition);
                }
                elementViewsIter.set((MenuOptionImpl)menuElement);
            }
            ArrayList<Node> menuElements = elementViews;
            return menuElements;
        }
        return null;
    }

    private void appendMenuElementViews(Node pathView, List elementViews) {
        if (!elementViews.contains(pathView)) {
            elementViews.add(pathView);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MenuImpl copy = (MenuImpl)super.clone();
        if (copy.elements != null) {
            Iterator elementsIter = copy.elements.iterator();
            copy.elements = new ArrayList(copy.elements.size());
            while (elementsIter.hasNext()) {
                MenuElementImpl elementCopy = (MenuElementImpl)((MenuElementImpl)elementsIter.next()).clone();
                elementCopy.setParentMenu(copy);
                copy.elements.add(elementCopy);
            }
        }
        return copy;
    }

    public String getElementType() {
        return "menu";
    }

    public String getName() {
        return this.definition.getName();
    }

    public String getTitle() {
        String title = this.definition.getTitle();
        if (title != null) {
            return title;
        }
        return super.getTitle();
    }

    public String getShortTitle() {
        String title = this.definition.getShortTitle();
        if (title != null) {
            return title;
        }
        return super.getShortTitle();
    }

    public String getTitle(Locale locale) {
        String title = this.definition.getTitle(locale);
        if (title != null) {
            return title;
        }
        return super.getTitle(locale);
    }

    public String getShortTitle(Locale locale) {
        String title = this.definition.getShortTitle(locale);
        if (title != null) {
            return title;
        }
        return super.getShortTitle(locale);
    }

    public GenericMetadata getMetadata() {
        GenericMetadata metadata = this.definition.getMetadata();
        if (metadata != null && metadata.getFields() != null && !metadata.getFields().isEmpty()) {
            return metadata;
        }
        return super.getMetadata();
    }

    public String getSkin() {
        String skin = this.definition.getSkin();
        if (skin == null) {
            skin = super.getSkin();
        }
        return skin;
    }

    public String getUrl() {
        if (this.getNode() != null) {
            return this.getNode().getUrl();
        }
        return null;
    }

    public boolean isHidden() {
        if (this.getNode() != null) {
            return this.getNode().isHidden();
        }
        return false;
    }

    public boolean isSelected(PortalSiteRequestContext context) {
        return this.getSelectedElement(context) != null;
    }

    public List getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    public boolean isElementRelative() {
        return this.elementRelative;
    }

    public MenuElement getSelectedElement(PortalSiteRequestContext context) {
        if (this.elements != null) {
            for (MenuElement element : this.elements) {
                boolean selected = false;
                if (element instanceof MenuOption) {
                    selected = ((MenuOption)element).isSelected(context);
                } else if (element instanceof Menu) {
                    selected = ((Menu)element).isSelected(context);
                }
                if (!selected) continue;
                return element;
            }
        }
        return null;
    }

    private static String orderRegexpPattern(String regexp) {
        StringBuffer pattern = null;
        int limit = regexp.length();
        block9: for (int i = 0; i < limit; ++i) {
            char regexpChar = regexp.charAt(i);
            switch (regexpChar) {
                case '*': 
                case '.': 
                case '?': 
                case '[': {
                    if (pattern == null) {
                        pattern = new StringBuffer(regexp.length() * 2);
                        pattern.append(regexp.substring(0, i));
                    }
                    switch (regexpChar) {
                        case '*': {
                            pattern.append("[^/]*");
                            break;
                        }
                        case '.': {
                            pattern.append("\\.");
                            break;
                        }
                        case '?': {
                            pattern.append("[^/]");
                            break;
                        }
                        case '[': {
                            pattern.append('[');
                        }
                    }
                    continue block9;
                }
                default: {
                    if (pattern == null) continue block9;
                    pattern.append(regexpChar);
                }
            }
        }
        if (pattern != null) {
            return pattern.toString();
        }
        return regexp;
    }
}

