/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.page.BaseConcretePageElement;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.portalsite.MenuOption;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.impl.MenuElementImpl;
import org.apache.jetspeed.portalsite.impl.MenuImpl;
import org.apache.jetspeed.portalsite.view.AbstractSiteView;

public class MenuOptionImpl
extends MenuElementImpl
implements MenuOption,
Cloneable {
    private MenuOptionsDefinition definition;

    public MenuOptionImpl(AbstractSiteView view, MenuImpl parent, Node node, MenuOptionsDefinition definition) {
        super(view, parent, node);
        this.definition = definition;
    }

    public String getElementType() {
        return "option";
    }

    public String getType() {
        Node node = this.getNode();
        if (node instanceof Page) {
            return "page";
        }
        if (node instanceof Link) {
            return "link";
        }
        if (node instanceof Folder) {
            return "folder";
        }
        return null;
    }

    public String getSkin() {
        String skin = this.definition.getSkin();
        if (skin == null) {
            Node node = this.getNode();
            if (node instanceof Page) {
                skin = ((Page)node).getSkin();
            } else if (node instanceof Link) {
                skin = ((Link)node).getSkin();
            } else if (node instanceof Folder) {
                skin = ((Folder)node).getSkin();
            }
        }
        if (skin == null) {
            skin = super.getSkin();
        }
        return skin;
    }

    public String getUrl() {
        return this.getNode().getUrl();
    }

    public String getTarget() {
        Node node = this.getNode();
        if (node instanceof Link) {
            return ((Link)node).getTarget();
        }
        return null;
    }

    public String getDefaultPage() {
        Node node = this.getNode();
        if (node instanceof Folder) {
            return ((Folder)node).getDefaultPage();
        }
        return null;
    }

    public boolean isHidden() {
        return this.getNode().isHidden();
    }

    public boolean isSelected(PortalSiteRequestContext context) {
        if (context != null) {
            BaseConcretePageElement requestPage = null;
            try {
                if (context.isConcretePage()) {
                    requestPage = (BaseConcretePageElement)context.getPageOrTemplate();
                }
            }
            catch (NodeNotFoundException nnfe) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (requestPage != null) {
                Node node = this.getNode();
                if (node instanceof Page) {
                    return requestPage.getUrl().equals(node.getUrl());
                }
                if (node instanceof Folder) {
                    return requestPage.getUrl().startsWith(node.getUrl());
                }
            }
        }
        return false;
    }
}

