/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.List;
import org.apache.jetspeed.portalsite.PortalSiteContentTypeMapper;
import org.apache.jetspeed.portalsite.impl.ContentTypeMapping;
import org.apache.jetspeed.portalsite.impl.RequestPathMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalSiteContentTypeMapperImpl
implements PortalSiteContentTypeMapper {
    public static final String DEFAULT_PAGE_SYSTEM_TYPE_SUFFIX = ".psml";
    public static final String[] DEFAULT_TEMPLATE_SYSTEM_TYPE_SUFFIXES = new String[]{".tpsml", ".fpsml", ".dpsml"};
    private List<ContentTypeMapping> contentTypeMappings;
    private List<RequestPathMapping> systemRequestPathMappings;
    private List<RequestPathMapping> dynamicRequestPathMappings;
    private List<RequestPathMapping> contentRequestPathMappings;
    private boolean enableContentTypeFallback;

    public PortalSiteContentTypeMapperImpl() {
        this(null);
    }

    public PortalSiteContentTypeMapperImpl(List<ContentTypeMapping> contentTypeMappings) {
        this(contentTypeMappings, null, null, null, false);
    }

    public PortalSiteContentTypeMapperImpl(List<ContentTypeMapping> contentTypeMappings, boolean enableContentTypeFallback) {
        this(contentTypeMappings, null, null, null, enableContentTypeFallback);
    }

    public PortalSiteContentTypeMapperImpl(List<ContentTypeMapping> contentTypeMappings, List<RequestPathMapping> dynamicPathMappings) {
        this(contentTypeMappings, dynamicPathMappings, null, null, false);
    }

    public PortalSiteContentTypeMapperImpl(List<ContentTypeMapping> contentTypeMappings, List<RequestPathMapping> dynamicPathMappings, boolean enableContentTypeFallback) {
        this(contentTypeMappings, dynamicPathMappings, null, null, enableContentTypeFallback);
    }

    public PortalSiteContentTypeMapperImpl(List<ContentTypeMapping> contentTypeMappings, List<RequestPathMapping> dynamicPathMappings, List<RequestPathMapping> systemPathMappings, List<RequestPathMapping> contentPathMappings, boolean enableContentTypeFallback) {
        this.contentTypeMappings = contentTypeMappings;
        this.dynamicRequestPathMappings = dynamicPathMappings;
        this.systemRequestPathMappings = systemPathMappings;
        this.contentRequestPathMappings = contentPathMappings;
        this.enableContentTypeFallback = enableContentTypeFallback;
    }

    public String mapContentType(String requestPath) {
        if (this.contentTypeMappings != null) {
            for (ContentTypeMapping mapping : this.contentTypeMappings) {
                String contentType = mapping.map(requestPath);
                if (contentType == null) continue;
                return contentType;
            }
        }
        return null;
    }

    public boolean isContentTypeFallbackEnabled() {
        return this.enableContentTypeFallback;
    }

    public String mapSystemRequestPath(String serverName, String contentType, String requestPath) {
        String mappedSystemRequestPath = this.mapRequestPath(this.systemRequestPathMappings, serverName, contentType, requestPath);
        if (mappedSystemRequestPath != null && !mappedSystemRequestPath.endsWith(DEFAULT_PAGE_SYSTEM_TYPE_SUFFIX) && !mappedSystemRequestPath.endsWith("/")) {
            int lastPathSeparatorIndex = mappedSystemRequestPath.lastIndexOf(47);
            int lastExtensionSeparatorIndex = mappedSystemRequestPath.lastIndexOf(46);
            if (lastExtensionSeparatorIndex > lastPathSeparatorIndex) {
                mappedSystemRequestPath = mappedSystemRequestPath.substring(0, lastExtensionSeparatorIndex);
            }
            mappedSystemRequestPath = mappedSystemRequestPath + DEFAULT_PAGE_SYSTEM_TYPE_SUFFIX;
        }
        return mappedSystemRequestPath;
    }

    public String mapDynamicRequestPath(String serverName, String contentType, String requestPath) {
        return this.mapRequestPath(this.dynamicRequestPathMappings, serverName, contentType, requestPath);
    }

    public String mapContentRequestPath(String serverName, String contentType, String requestPath) {
        return this.mapRequestPath(this.contentRequestPathMappings, serverName, contentType, requestPath);
    }

    public String mapSystemType(String requestPath) {
        if (requestPath.endsWith(DEFAULT_PAGE_SYSTEM_TYPE_SUFFIX)) {
            return "portal-page";
        }
        for (int i = 0; i < DEFAULT_TEMPLATE_SYSTEM_TYPE_SUFFIXES.length; ++i) {
            if (!requestPath.endsWith(DEFAULT_TEMPLATE_SYSTEM_TYPE_SUFFIXES[i])) continue;
            return "portal-template";
        }
        return null;
    }

    private String mapRequestPath(List<RequestPathMapping> requestPathMappings, String serverName, String contentType, String requestPath) {
        if (requestPathMappings != null) {
            for (RequestPathMapping mapping : requestPathMappings) {
                String mappedRequestPath = mapping.map(serverName, contentType, requestPath);
                if (mappedRequestPath == null || mappedRequestPath.equals(requestPath)) continue;
                requestPath = mappedRequestPath;
            }
            return requestPath;
        }
        return null;
    }
}

