/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.BaseConcretePageElement;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.FragmentReference;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.proxy.NodeSetImpl;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.PortalSiteSessionContext;
import org.apache.jetspeed.portalsite.impl.MenuImpl;
import org.apache.jetspeed.portalsite.impl.PortalSiteSessionContextImpl;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;

public class PortalSiteRequestContextImpl
implements PortalSiteRequestContext {
    private PortalSiteSessionContextImpl sessionContext;
    private Map requestProfileLocators;
    private String requestPath;
    private String requestServerName;
    private String requestUserPrincipal;
    private boolean requestFallback;
    private boolean useHistory;
    private boolean forceReservedVisible;
    private transient boolean forceTemplatesAccessible;
    private BaseFragmentsElement requestPageOrTemplate;
    private String requestPageContentPath;
    private PageTemplate requestPageTemplate;
    private boolean requestPageTemplateCached;
    private Map requestFragmentDefinitions;
    private boolean requestFragmentDefinitionsCached;
    private NodeSet siblingPages;
    private boolean siblingPagesCached;
    private NodeSet siblingFolders;
    private boolean siblingFoldersCached;
    private Folder requestRootFolder;
    private NodeSet rootLinks;
    private boolean rootLinksCached;
    private Set pageMenuDefinitionNames;
    private Map menuDefinitionLocatorCache;

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, Map requestProfileLocators, String requestUserPrincipal, boolean requestFallback, boolean useHistory, boolean forceReservedVisible, boolean forceTemplatesAccessible) {
        this.sessionContext = sessionContext;
        this.requestProfileLocators = requestProfileLocators;
        this.requestUserPrincipal = requestUserPrincipal;
        this.requestFallback = requestFallback;
        this.useHistory = useHistory;
        this.forceReservedVisible = forceReservedVisible;
        this.forceTemplatesAccessible = forceTemplatesAccessible;
    }

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, Map requestProfileLocators, String requestUserPrincipal, boolean requestFallback, boolean useHistory) {
        this(sessionContext, requestProfileLocators, requestUserPrincipal, requestFallback, useHistory, false, false);
    }

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, Map requestProfileLocators, String requestUserPrincipal, boolean requestFallback) {
        this(sessionContext, requestProfileLocators, requestUserPrincipal, requestFallback, true, false, false);
    }

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, Map requestProfileLocators, String requestUserPrincipal) {
        this(sessionContext, requestProfileLocators, requestUserPrincipal, true, true, false, false);
    }

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, String requestPath, String requestServerName, String requestUserPrincipal, boolean requestFallback, boolean useHistory, boolean forceTemplatesAccessible) {
        this.sessionContext = sessionContext;
        this.requestPath = requestPath;
        this.requestServerName = requestServerName;
        this.requestUserPrincipal = requestUserPrincipal;
        this.requestFallback = requestFallback;
        this.useHistory = useHistory;
        this.forceTemplatesAccessible = forceTemplatesAccessible;
    }

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, String requestPath, String requestServerName, String requestUserPrincipal, boolean requestFallback, boolean useHistory) {
        this(sessionContext, requestPath, requestServerName, requestUserPrincipal, requestFallback, useHistory, false);
    }

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, String requestPath, String requestServerName, String requestUserPrincipal, boolean requestFallback) {
        this(sessionContext, requestPath, requestServerName, requestUserPrincipal, requestFallback, true, false);
    }

    public PortalSiteRequestContextImpl(PortalSiteSessionContextImpl sessionContext, String requestPath, String requestServerName, String requestUserPrincipal) {
        this(sessionContext, requestPath, requestServerName, requestUserPrincipal, true, true, false);
    }

    public PortalSiteSessionContext getSessionContext() {
        return this.sessionContext;
    }

    public Map getLocators() {
        return this.requestProfileLocators;
    }

    public BaseFragmentsElement getManagedPageOrTemplate() throws NodeNotFoundException {
        return this.sessionContext.getManagedPageOrTemplate(this.getPageOrTemplate());
    }

    public PageTemplate getManagedPageTemplate() throws NodeNotFoundException {
        return this.sessionContext.getManagedPageTemplate(this.getPageTemplate());
    }

    public Map getManagedFragmentDefinitions() throws NodeNotFoundException {
        Map fragmentDefinitions = this.getFragmentDefinitions();
        if (fragmentDefinitions != null) {
            HashMap<String, FragmentDefinition> managedFragmentDefinitions = new HashMap<String, FragmentDefinition>(4);
            for (Map.Entry fragmentDefinitionEntry : fragmentDefinitions.entrySet()) {
                String id = (String)fragmentDefinitionEntry.getKey();
                FragmentDefinition fragmentDefinition = (FragmentDefinition)fragmentDefinitionEntry.getValue();
                FragmentDefinition managedFragmentDefinition = this.sessionContext.getManagedFragmentDefinition(fragmentDefinition);
                if (managedFragmentDefinition == null) continue;
                managedFragmentDefinitions.put(id, managedFragmentDefinition);
            }
            return managedFragmentDefinitions;
        }
        return null;
    }

    public boolean isContentPage() throws NodeNotFoundException {
        return this.getPageOrTemplate() instanceof BaseConcretePageElement && this.getPageContentPath() != null;
    }

    public boolean isConcretePage() throws NodeNotFoundException {
        BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate();
        String pageContentPath = this.getPageContentPath();
        return pageOrTemplate instanceof Page || pageOrTemplate instanceof DynamicPage && pageContentPath != null;
    }

    public BaseFragmentsElement getPageOrTemplate() throws NodeNotFoundException {
        if (this.requestPageOrTemplate == null) {
            String[] selectedRequestPageContentPath = new String[]{null};
            this.requestPageOrTemplate = this.requestProfileLocators != null ? this.sessionContext.selectRequestPageOrTemplate(this.requestProfileLocators, this.requestUserPrincipal, this.requestFallback, this.useHistory, this.forceReservedVisible, this.forceTemplatesAccessible, selectedRequestPageContentPath) : this.sessionContext.selectRequestPageOrTemplate(this.requestPath, this.requestServerName, this.requestUserPrincipal, this.requestFallback, this.useHistory, this.forceTemplatesAccessible, selectedRequestPageContentPath);
            if (this.requestPageOrTemplate != null) {
                this.requestPageContentPath = selectedRequestPageContentPath[0];
            }
        }
        return this.requestPageOrTemplate;
    }

    public String getPageContentPath() throws NodeNotFoundException {
        return this.getPageOrTemplate() != null ? this.requestPageContentPath : null;
    }

    public PageTemplate getPageTemplate() throws NodeNotFoundException {
        if (!this.requestPageTemplateCached) {
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate();
            if (pageOrTemplate != null) {
                try {
                    Folder folder = (Folder)pageOrTemplate.getParent();
                    while (folder != null && this.requestPageTemplate == null) {
                        NodeSet pageTemplates = folder.getPageTemplates();
                        if (pageTemplates != null && !pageTemplates.isEmpty()) {
                            this.requestPageTemplate = (PageTemplate)pageTemplates.iterator().next();
                            continue;
                        }
                        folder = (Folder)folder.getParent();
                    }
                }
                catch (NodeException nodeException) {
                    // empty catch block
                }
            }
            this.requestPageTemplateCached = true;
        }
        return this.requestPageTemplate;
    }

    public Map getFragmentDefinitions() throws NodeNotFoundException {
        if (!this.requestFragmentDefinitionsCached) {
            BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate();
            PageTemplate pageTemplate = this.getPageTemplate();
            if (pageOrTemplate != null) {
                HashSet refIds = new HashSet(4);
                List requestPageFragmentReferences = pageOrTemplate.getFragmentsByInterface(FragmentReference.class);
                this.mergeFragmentDefinitionRefIds(requestPageFragmentReferences, refIds);
                List requestPageTemplateFragmentReferences = pageTemplate != null ? pageTemplate.getFragmentsByInterface(FragmentReference.class) : null;
                this.mergeFragmentDefinitionRefIds(requestPageTemplateFragmentReferences, refIds);
                for (String refId : refIds) {
                    FragmentDefinition requestFragmentDefinition = null;
                    try {
                        Folder folder = (Folder)pageOrTemplate.getParent();
                        while (folder != null && requestFragmentDefinition == null) {
                            NodeSet fragmentDefinitions = folder.getFragmentDefinitions();
                            if (fragmentDefinitions != null && !fragmentDefinitions.isEmpty()) {
                                Iterator fragmentDefinitionsIter = fragmentDefinitions.iterator();
                                while (fragmentDefinitionsIter.hasNext() && requestFragmentDefinition == null) {
                                    FragmentDefinition fragmentDefinition = (FragmentDefinition)fragmentDefinitionsIter.next();
                                    if (!fragmentDefinition.getDefId().equals(refId)) continue;
                                    requestFragmentDefinition = fragmentDefinition;
                                }
                                continue;
                            }
                            folder = (Folder)folder.getParent();
                        }
                        if (requestFragmentDefinition != null) {
                            if (this.requestFragmentDefinitions == null) {
                                this.requestFragmentDefinitions = Collections.synchronizedMap(new HashMap(4));
                            }
                            this.requestFragmentDefinitions.put(refId, requestFragmentDefinition);
                            continue;
                        }
                        throw new NodeNotFoundException("Fragment definition for " + refId + " not found.");
                    }
                    catch (NodeException ne) {
                        NodeNotFoundException nnfe = new NodeNotFoundException("Fragment definition for " + refId + " not found.");
                        nnfe.initCause((Throwable)ne);
                        throw nnfe;
                    }
                }
            }
            this.requestFragmentDefinitionsCached = true;
        }
        return this.requestFragmentDefinitions;
    }

    private void mergeFragmentDefinitionRefIds(List fragmentReferences, Set refIds) {
        if (fragmentReferences != null && !fragmentReferences.isEmpty()) {
            for (FragmentReference fragmentReference : fragmentReferences) {
                if (fragmentReference.getRefId() == null) continue;
                refIds.add(fragmentReference.getRefId());
            }
        }
    }

    public Folder getFolder() throws NodeNotFoundException {
        BaseFragmentsElement pageOrTemplate = this.getPageOrTemplate();
        if (pageOrTemplate != null) {
            return (Folder)pageOrTemplate.getParent();
        }
        return null;
    }

    public NodeSet getSiblingPages() throws NodeNotFoundException {
        Folder folder;
        if (!this.siblingPagesCached && (folder = this.getFolder()) != null) {
            try {
                this.siblingPages = PortalSiteRequestContextImpl.filterHiddenNodes(folder.getPages());
                this.siblingPagesCached = true;
            }
            catch (NodeException ne) {
                NodeNotFoundException nnfe = new NodeNotFoundException("Sibling pages not found.");
                nnfe.initCause((Throwable)ne);
                throw nnfe;
            }
        }
        return this.siblingPages;
    }

    public Folder getParentFolder() throws NodeNotFoundException {
        Folder parent;
        Folder folder = this.getFolder();
        if (folder != null && (parent = (Folder)folder.getParent()) != null && !parent.isHidden()) {
            return parent;
        }
        return null;
    }

    public NodeSet getSiblingFolders() throws NodeNotFoundException {
        Folder folder;
        if (!this.siblingFoldersCached && (folder = this.getFolder()) != null) {
            try {
                this.siblingFolders = PortalSiteRequestContextImpl.filterHiddenNodes(folder.getFolders());
                this.siblingFoldersCached = true;
            }
            catch (NodeException ne) {
                NodeNotFoundException nnfe = new NodeNotFoundException("Sibling folders not found.");
                nnfe.initCause((Throwable)ne);
                throw nnfe;
            }
        }
        return this.siblingFolders;
    }

    public Folder getRootFolder() throws NodeNotFoundException {
        if (this.requestRootFolder == null) {
            this.requestRootFolder = this.requestProfileLocators != null ? this.sessionContext.getRequestRootFolder(this.requestProfileLocators, this.requestUserPrincipal, this.forceReservedVisible) : this.sessionContext.getRequestRootFolder(this.requestUserPrincipal);
        }
        return this.requestRootFolder;
    }

    public NodeSet getRootLinks() throws NodeNotFoundException {
        Folder rootFolder;
        if (!this.rootLinksCached && (rootFolder = this.getRootFolder()) != null) {
            try {
                this.rootLinks = PortalSiteRequestContextImpl.filterHiddenNodes(rootFolder.getLinks());
                this.rootLinksCached = true;
            }
            catch (NodeException ne) {
                NodeNotFoundException nnfe = new NodeNotFoundException("Root links not found.");
                nnfe.initCause((Throwable)ne);
                throw nnfe;
            }
        }
        return this.rootLinks;
    }

    public Set getStandardMenuNames() {
        return this.sessionContext.getStandardMenuNames();
    }

    public Set getCustomMenuNames() throws NodeNotFoundException {
        if (this.isConcretePage()) {
            BaseConcretePageElement page = (BaseConcretePageElement)this.getPageOrTemplate();
            PageTemplate pageTemplate = this.getPageTemplate();
            Set standardMenuNames = this.sessionContext.getStandardMenuNames();
            if (page != null && standardMenuNames != null && this.pageMenuDefinitionNames == null) {
                List pageTemplateLocators;
                List pageLocators = this.sessionContext.getMenuDefinitionLocators((Node)page);
                List list = pageTemplateLocators = pageTemplate != null ? this.sessionContext.getMenuDefinitionLocators((Node)pageTemplate) : null;
                if (pageLocators != null || pageTemplateLocators != null) {
                    this.pageMenuDefinitionNames = Collections.synchronizedSet(new HashSet(8));
                    this.mergeMenuDefinitionLocatorNames(pageLocators, standardMenuNames, this.pageMenuDefinitionNames);
                    this.mergeMenuDefinitionLocatorNames(pageTemplateLocators, standardMenuNames, this.pageMenuDefinitionNames);
                } else {
                    this.pageMenuDefinitionNames = Collections.synchronizedSet(new HashSet(0));
                }
            }
            return this.pageMenuDefinitionNames;
        }
        return null;
    }

    private void mergeMenuDefinitionLocatorNames(List locators, Set excludeNames, Set names) {
        if (locators != null) {
            Iterator locatorsIter = locators.iterator();
            while (locatorsIter.hasNext()) {
                String definitionName = ((SiteViewMenuDefinitionLocator)locatorsIter.next()).getName();
                if (excludeNames.contains(definitionName)) continue;
                names.add(definitionName);
            }
        }
    }

    public Menu getMenu(String name) throws NodeNotFoundException {
        return this.getMenu(name, null);
    }

    public Menu getMenu(String name, Set names) throws NodeNotFoundException {
        if (name != null && this.isConcretePage()) {
            SiteViewMenuDefinitionLocator pageTemplateLocator;
            BaseConcretePageElement page = (BaseConcretePageElement)this.getPageOrTemplate();
            PageTemplate pageTemplate = this.getPageTemplate();
            SiteViewMenuDefinitionLocator locator = this.sessionContext.getMenuDefinitionLocator((Node)page, name);
            if (!(pageTemplate == null || locator != null && locator.isOverride() || (pageTemplateLocator = this.sessionContext.getMenuDefinitionLocator((Node)pageTemplate, name)) == null)) {
                locator = pageTemplateLocator;
            }
            if (locator != null) {
                MenuImpl menu;
                if (this.menuDefinitionLocatorCache != null && (menu = (MenuImpl)this.menuDefinitionLocatorCache.get(locator)) != null) {
                    return menu;
                }
                if (this.sessionContext.getMenuDefinitionLocatorCache() != null && (menu = (MenuImpl)this.sessionContext.getMenuDefinitionLocatorCache().get(locator)) != null) {
                    return menu;
                }
                menu = new MenuImpl(locator.getMenuDefinition(), locator.getPath(), this, names);
                if (page.isHidden() || menu.isElementRelative()) {
                    if (this.menuDefinitionLocatorCache == null) {
                        this.menuDefinitionLocatorCache = Collections.synchronizedMap(new HashMap(8));
                    }
                    this.menuDefinitionLocatorCache.put(locator, menu);
                } else {
                    if (this.sessionContext.getMenuDefinitionLocatorCache() == null) {
                        this.sessionContext.setMenuDefinitionLocatorCache(Collections.synchronizedMap(new HashMap(8)));
                    }
                    this.sessionContext.getMenuDefinitionLocatorCache().put(locator, menu);
                }
                return menu;
            }
        }
        return null;
    }

    public String getUserFolderPath() {
        return this.sessionContext.getUserFolderPath(this.requestProfileLocators, this.requestUserPrincipal, this.forceReservedVisible);
    }

    public String getBaseFolderPath() {
        return this.sessionContext.getBaseFolderPath(this.requestProfileLocators, this.requestUserPrincipal, this.forceReservedVisible);
    }

    private static NodeSet filterHiddenNodes(NodeSet nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            ArrayList<Node> filteredNodes = null;
            for (Node node : nodes) {
                if (node.isHidden()) {
                    Node copyNode;
                    if (filteredNodes != null) continue;
                    filteredNodes = new ArrayList<Node>(nodes.size());
                    Iterator copyIter = nodes.iterator();
                    while (copyIter.hasNext() && (copyNode = (Node)copyIter.next()) != node) {
                        filteredNodes.add(copyNode);
                    }
                    continue;
                }
                if (filteredNodes == null) continue;
                filteredNodes.add(node);
            }
            if (filteredNodes != null) {
                return new NodeSetImpl(filteredNodes);
            }
        }
        return nodes;
    }
}

