/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerEventListener;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.portalsite.PortalSiteContentTypeMapper;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portalsite.PortalSiteSessionContext;
import org.apache.jetspeed.portalsite.impl.PortalSiteRequestContextImpl;
import org.apache.jetspeed.portalsite.view.AbstractSiteView;
import org.apache.jetspeed.portalsite.view.PhysicalSiteView;
import org.apache.jetspeed.portalsite.view.SearchPathsSiteView;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.ProfileLocatorProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalSiteSessionContextImpl
implements PortalSiteSessionContext,
PageManagerEventListener,
HttpSessionActivationListener,
HttpSessionBindingListener,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(PortalSiteSessionContextImpl.class);
    private transient PageManager pageManager;
    private transient PortalSiteContentTypeMapper contentTypeMapper;
    private transient Map profileLocators;
    private transient boolean forceReservedVisible;
    private transient String userPrincipal;
    private transient AbstractSiteView siteView;
    private transient Map folderPageHistory;
    private transient Map menuDefinitionLocatorCache;
    private transient boolean subscribed;
    private transient boolean stale;
    private transient long locatorsLastUpdateCheck;

    public PortalSiteSessionContextImpl(PageManager pageManager, PortalSiteContentTypeMapper contentTypeMapper) {
        this.pageManager = pageManager;
        this.contentTypeMapper = contentTypeMapper;
    }

    public PortalSiteRequestContext newRequestContext(Map requestProfileLocators, String requestUserPrincipal) {
        return new PortalSiteRequestContextImpl(this, requestProfileLocators, requestUserPrincipal, true, true, false, false);
    }

    public PortalSiteRequestContext newRequestContext(Map requestProfileLocators, String requestUserPrincipal, boolean requestFallback) {
        return new PortalSiteRequestContextImpl(this, requestProfileLocators, requestUserPrincipal, requestFallback, true, false, false);
    }

    public PortalSiteRequestContext newRequestContext(Map requestProfileLocators, String requestUserPrincipal, boolean requestFallback, boolean useHistory) {
        return new PortalSiteRequestContextImpl(this, requestProfileLocators, requestUserPrincipal, requestFallback, useHistory, false, false);
    }

    public PortalSiteRequestContext newRequestContext(Map requestProfileLocators, String requestUserPrincipal, boolean requestFallback, boolean useHistory, boolean forceReservedVisible, boolean forceTemplatesAccessible) {
        return new PortalSiteRequestContextImpl(this, requestProfileLocators, requestUserPrincipal, requestFallback, useHistory, forceReservedVisible, forceTemplatesAccessible);
    }

    public PortalSiteRequestContext newRequestContext(String requestPath, String requestServerName, String requestUserPrincipal) {
        return new PortalSiteRequestContextImpl(this, requestPath, requestServerName, requestUserPrincipal, true, true, false);
    }

    public PortalSiteRequestContext newRequestContext(String requestPath, String requestServerName, String requestUserPrincipal, boolean requestFallback) {
        return new PortalSiteRequestContextImpl(this, requestPath, requestServerName, requestUserPrincipal, requestFallback, true, false);
    }

    public PortalSiteRequestContext newRequestContext(String requestPath, String requestServerName, String requestUserPrincipal, boolean requestFallback, boolean useHistory) {
        return new PortalSiteRequestContextImpl(this, requestPath, requestServerName, requestUserPrincipal, requestFallback, useHistory, false);
    }

    public PortalSiteRequestContext newRequestContext(String requestPath, String requestServerName, String requestUserPrincipal, boolean requestFallback, boolean useHistory, boolean forceTemplatesAccessible) {
        return new PortalSiteRequestContextImpl(this, requestPath, requestServerName, requestUserPrincipal, requestFallback, useHistory, forceTemplatesAccessible);
    }

    public BaseFragmentsElement selectRequestPageOrTemplate(String requestPath, String requestServerName, String requestUserPrincipal, boolean requestFallback, boolean useHistory, boolean forceTemplatesAccessible, String[] requestPageContentPath) throws NodeNotFoundException {
        return this.selectRequestPageOrTemplate(null, requestPath, requestServerName, requestUserPrincipal, requestFallback, useHistory, false, forceTemplatesAccessible, requestPageContentPath);
    }

    public BaseFragmentsElement selectRequestPageOrTemplate(Map requestProfileLocators, String requestUserPrincipal, boolean requestFallback, boolean useHistory, boolean forceReservedVisible, boolean forceTemplatesAccessible, String[] requestPageContentPath) throws NodeNotFoundException {
        return this.selectRequestPageOrTemplate(requestProfileLocators, null, null, requestUserPrincipal, requestFallback, useHistory, forceReservedVisible, forceTemplatesAccessible, requestPageContentPath);
    }

    private BaseFragmentsElement selectRequestPageOrTemplate(Map requestProfileLocators, String requestPath, String requestServerName, String requestUserPrincipal, boolean requestFallback, boolean useHistory, boolean forceReservedVisible, boolean forceTemplatesAccessible, String[] requestPageContentPath) throws NodeNotFoundException {
        if (this.updateSessionProfileLocators(requestProfileLocators, requestUserPrincipal, forceReservedVisible)) {
            ProfileLocator locator = null;
            if (requestProfileLocators != null) {
                requestPath = "/";
                requestServerName = null;
                locator = (ProfileLocator)requestProfileLocators.get("page");
                if (locator != null) {
                    requestPath = this.getRequestPathFromLocator(locator);
                } else {
                    locator = (ProfileLocator)requestProfileLocators.values().iterator().next();
                    requestPath = locator.getRequestPath();
                }
                requestServerName = locator.getRequestServerName();
            }
            if (log.isDebugEnabled()) {
                log.debug("Select request page: requestPath=" + requestPath + ", requestServerName: " + requestServerName);
            }
            if (this.contentTypeMapper != null) {
                AbstractSiteView view;
                String systemType = this.contentTypeMapper.mapSystemType(requestPath);
                if (systemType != null && this.contentTypeMapper.isContentTypeFallbackEnabled() && (view = this.getSiteView()) != null) {
                    try {
                        view.getNodeView(requestPath, null, null, !forceTemplatesAccessible, false, false);
                    }
                    catch (NodeNotFoundException nnfe) {
                        if (log.isDebugEnabled()) {
                            log.debug("System request: requestPath=" + requestPath + " does not exist: fallback to content type");
                        }
                        systemType = null;
                    }
                }
                if (systemType == null) {
                    String contentType = this.contentTypeMapper.mapContentType(requestPath);
                    if (contentType != null) {
                        String systemPageRequestPath;
                        String contentPageRequestPath;
                        if (log.isDebugEnabled()) {
                            log.debug("Content request: requestPath=" + requestPath + ", mapped to content type: " + contentType);
                        }
                        if ((contentPageRequestPath = this.contentTypeMapper.mapContentRequestPath(requestServerName, contentType, requestPath)) != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Mapped content request to content path: serverName=" + requestServerName + ", contentType=" + contentType + ", requestPath=" + requestPath + ", mapped to: " + contentPageRequestPath);
                            }
                            if (requestPageContentPath != null) {
                                requestPageContentPath[0] = contentPageRequestPath;
                            }
                        }
                        if ((systemPageRequestPath = this.contentTypeMapper.mapSystemRequestPath(requestServerName, contentType, requestPath)) != null) {
                            AbstractSiteView view2 = this.getSiteView();
                            if (view2 != null) {
                                try {
                                    if (view2.getNodeView(systemPageRequestPath, null, null, true, false, false) instanceof Page) {
                                        systemType = "portal-page";
                                    }
                                }
                                catch (NodeNotFoundException nnfe) {
                                    // empty catch block
                                }
                            }
                            if (systemType != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Mapped content request to existing system page: serverName=" + requestServerName + ", contentType=" + contentType + ", requestPath=" + requestPath + ", mapped to: " + systemPageRequestPath);
                                }
                                requestPath = systemPageRequestPath;
                            }
                        }
                        if (systemType == null) {
                            String dynamicPageRequestPath = this.contentTypeMapper.mapDynamicRequestPath(requestServerName, contentType, requestPath);
                            if (dynamicPageRequestPath != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Mapped content request to dynamic page: serverName=" + requestServerName + ", contentType=" + contentType + ", requestPath=" + requestPath + ", mapped to: " + dynamicPageRequestPath);
                                }
                                requestPath = dynamicPageRequestPath;
                            }
                            return this.selectContentRequestPage(requestPath, contentType);
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("System request: requestPath=" + requestPath + ", mapped to system type: " + systemType);
                }
            }
            while (true) {
                Throwable fallbackException = null;
                try {
                    return this.selectRequestPageOrTemplate(requestPath, useHistory, forceTemplatesAccessible);
                }
                catch (NodeNotFoundException nnfe) {
                    if (!requestFallback || requestPath.equals("/")) {
                        throw nnfe;
                    }
                    fallbackException = nnfe;
                }
                catch (SecurityException se) {
                    if (!requestFallback || requestPath.equals("/")) {
                        throw se;
                    }
                    fallbackException = se;
                }
                if (!requestFallback || requestPath.equals("/")) break;
                String fallbackRequestPath = requestPath;
                while (fallbackRequestPath.endsWith("/")) {
                    fallbackRequestPath = fallbackRequestPath.substring(0, fallbackRequestPath.length() - 1);
                }
                int folderIndex = fallbackRequestPath.lastIndexOf("/");
                if ((fallbackRequestPath = folderIndex >= 2 ? fallbackRequestPath.substring(0, folderIndex) : "/").equals(requestPath)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Missing/forbidden page selection fallback: request path=" + requestPath + ", attempting fallback request path=" + fallbackRequestPath, fallbackException);
                }
                Iterator folderPathIter = this.getFolderPageHistory().keySet().iterator();
                while (folderPathIter.hasNext()) {
                    String folderPath = (String)folderPathIter.next();
                    if (!folderPath.equals(fallbackRequestPath)) continue;
                    folderPathIter.remove();
                    break;
                }
                requestPath = fallbackRequestPath;
            }
        }
        throw new NodeNotFoundException("No request page available in site view.");
    }

    private String getRequestPathFromLocator(ProfileLocator locator) {
        String requestPath = locator.getRequestPath();
        Iterator locatorIter = locator.iterator();
        if (locatorIter.hasNext()) {
            ProfileLocatorProperty[] properties = (ProfileLocatorProperty[])locatorIter.next();
            for (int i = 0; i < properties.length; ++i) {
                String path;
                if (properties[i].isControl() || properties[i].isNavigation() || (path = properties[i].getValue()) == null) continue;
                if (!path.startsWith("/")) {
                    String basePath = requestPath;
                    if (basePath == null) {
                        basePath = "/";
                    } else if (basePath.endsWith(".psml")) {
                        basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1);
                    } else if (!basePath.endsWith("/")) {
                        basePath = basePath + "/";
                    }
                    path = basePath + path;
                    if (!path.endsWith("/") && !path.endsWith(".psml")) {
                        path = path + ".psml";
                    }
                }
                if (path.equals(requestPath)) continue;
                if (path.endsWith("/default-page.psml")) {
                    path = path.substring(0, path.length() - "default-page.psml".length());
                }
                if (log.isDebugEnabled() && !path.equals(requestPath)) {
                    log.debug("Request path modified by profile locator: request path=" + path + ", original request path=" + requestPath);
                }
                return path;
            }
        }
        return requestPath;
    }

    private BaseFragmentsElement selectRequestPageOrTemplate(String requestPath, boolean useHistory, boolean forceTemplatesAccessible) throws NodeNotFoundException {
        SecurityException accessException = null;
        AbstractSiteView view = this.getSiteView();
        if (view != null) {
            if (requestPath == null) {
                requestPath = "/";
            }
            if (log.isDebugEnabled()) {
                log.debug("Request page: request path=" + requestPath);
            }
            Node requestNode = null;
            try {
                requestNode = view.getNodeView(requestPath, null, null, !forceTemplatesAccessible, false, false);
            }
            catch (NodeNotFoundException nnfe) {
                if (requestPath.endsWith("/default-page.psml")) {
                    requestPath = requestPath.substring(0, requestPath.length() - "default-page.psml".length());
                    requestNode = view.getNodeView(requestPath, null, null, !forceTemplatesAccessible, true, false);
                }
                throw nnfe;
            }
            if (requestNode instanceof Folder) {
                Folder requestFolder = (Folder)requestNode;
                try {
                    String defaultFolderName = requestFolder.getDefaultPage();
                    if (defaultFolderName != null) {
                        Folder defaultRequestFolder = requestFolder;
                        while (defaultRequestFolder != null && defaultFolderName != null && defaultFolderName.equals("..")) {
                            if ((defaultRequestFolder = (Folder)defaultRequestFolder.getParent()) != null) {
                                defaultFolderName = defaultRequestFolder.getDefaultPage();
                                continue;
                            }
                            defaultFolderName = null;
                        }
                        while (defaultRequestFolder != null && defaultFolderName != null && !defaultFolderName.endsWith(".psml") && !defaultFolderName.equals("..")) {
                            defaultRequestFolder = defaultRequestFolder.getFolder(defaultFolderName);
                            defaultFolderName = defaultRequestFolder.getDefaultPage();
                        }
                        if (defaultRequestFolder != null) {
                            requestFolder = defaultRequestFolder;
                        }
                    }
                }
                catch (NodeException ne) {
                }
                catch (NodeNotFoundException nnfe) {
                }
                catch (SecurityException se) {
                    requestFolder = null;
                    accessException = se;
                }
                NodeSet requestFolderPages = null;
                if (requestFolder != null) {
                    try {
                        requestFolderPages = requestFolder.getPages();
                        while ((requestFolderPages == null || requestFolderPages.isEmpty()) && requestFolder.getParent() != null) {
                            requestFolder = (Folder)requestFolder.getParent();
                            requestFolderPages = requestFolder.getPages();
                        }
                    }
                    catch (NodeException ne) {
                        requestFolderPages = null;
                    }
                    catch (SecurityException se) {
                        requestFolderPages = null;
                        accessException = se;
                    }
                }
                if (requestFolder != null && requestFolderPages != null && !requestFolderPages.isEmpty()) {
                    String requestPageId;
                    Page requestPage = null;
                    if (useHistory && (requestPageId = (String)this.getFolderPageHistory().get(requestFolder.getPath())) != null) {
                        Iterator requestFolderPagesIter = requestFolderPages.iterator();
                        while (requestPage == null && requestFolderPagesIter.hasNext()) {
                            Page requestFolderPage = (Page)requestFolderPagesIter.next();
                            if (!requestPageId.equals(requestFolderPage.getId())) continue;
                            requestPage = requestFolderPage;
                        }
                        if (requestPage != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Selected folder historical page: path=" + view.getManagedPage(requestPage).getPath());
                            }
                            return requestPage;
                        }
                    }
                    if (requestFolderPages.size() > 1) {
                        String defaultPageName = requestFolder.getDefaultPage();
                        if (defaultPageName == null) {
                            defaultPageName = "default-page.psml";
                        }
                        try {
                            requestPage = requestFolder.getPage(defaultPageName);
                            if (!requestPage.isHidden()) {
                                this.getFolderPageHistory().put(requestFolder.getPath(), requestPage.getId());
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Selected folder default page: path=" + view.getManagedPage(requestPage).getPath());
                            }
                            return requestPage;
                        }
                        catch (NodeException ne) {
                        }
                        catch (NodeNotFoundException nnfe) {
                        }
                        catch (SecurityException se) {
                            accessException = se;
                        }
                    }
                    if (!(requestPage = (Page)requestFolderPages.iterator().next()).isHidden()) {
                        this.getFolderPageHistory().put(requestFolder.getPath(), requestPage.getId());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Selected first folder page, path=" + view.getManagedPage(requestPage).getPath());
                    }
                    return requestPage;
                }
            } else {
                if (requestNode instanceof Page) {
                    Page requestPage = (Page)requestNode;
                    Folder requestFolder = (Folder)requestPage.getParent();
                    if (!requestPage.isHidden()) {
                        this.getFolderPageHistory().put(requestFolder.getPath(), requestPage.getId());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Selected page, path=" + view.getManagedPage(requestPage).getPath());
                    }
                    return requestPage;
                }
                if (forceTemplatesAccessible) {
                    if (requestNode instanceof PageTemplate) {
                        PageTemplate requestPageTemplate = (PageTemplate)requestNode;
                        if (log.isDebugEnabled()) {
                            log.debug("Selected page template, path=" + view.getManagedPageTemplate(requestPageTemplate).getPath());
                        }
                        return requestPageTemplate;
                    }
                    if (requestNode instanceof DynamicPage) {
                        DynamicPage requestDynamicPage = (DynamicPage)requestNode;
                        if (log.isDebugEnabled()) {
                            log.debug("Selected dynamic page, path=" + view.getManagedDynamicPage(requestDynamicPage).getPath());
                        }
                        return requestDynamicPage;
                    }
                    if (requestNode instanceof FragmentDefinition) {
                        FragmentDefinition requestFragmentDefinition = (FragmentDefinition)requestNode;
                        if (log.isDebugEnabled()) {
                            log.debug("Selected fragment definition, path=" + view.getManagedFragmentDefinition(requestFragmentDefinition).getPath());
                        }
                        return requestFragmentDefinition;
                    }
                }
            }
        }
        if (accessException != null) {
            throw accessException;
        }
        throw new NodeNotFoundException("No page matched " + requestPath + " request in site view.");
    }

    private DynamicPage selectContentRequestPage(String requestPath, String contentType) throws NodeNotFoundException {
        SecurityException accessException = null;
        AbstractSiteView view = this.getSiteView();
        if (view != null) {
            int startOfPathNameIndex;
            int endOfPathNameIndex;
            if (requestPath == null) {
                requestPath = "/";
            }
            if (log.isDebugEnabled()) {
                log.debug("Request content page: request path=" + requestPath);
            }
            Folder contentRequestFolder = (Folder)view.getNodeView("/", null, null, true, false, false);
            String contentRequestPath = contentRequestFolder.getPath();
            while ((endOfPathNameIndex = requestPath.indexOf("/", startOfPathNameIndex = contentRequestPath.equals("/") ? 1 : contentRequestPath.length() + 1)) != -1 && endOfPathNameIndex != startOfPathNameIndex) {
                try {
                    String pathFolderName = requestPath.substring(startOfPathNameIndex, endOfPathNameIndex);
                    contentRequestFolder = contentRequestFolder.getFolder(pathFolderName);
                    contentRequestPath = contentRequestFolder.getPath();
                }
                catch (Exception e) {
                    break;
                }
            }
            boolean matchingContentRequestFolder = true;
            if (contentRequestPath.length() < requestPath.length()) {
                String requestPathTail;
                boolean bl = matchingContentRequestFolder = requestPathTail.indexOf(47, (requestPathTail = requestPath.substring(contentRequestPath.length())).startsWith("/") ? 1 : 0) == -1;
            }
            while (contentRequestFolder != null) {
                try {
                    NodeSet dynamicPages = contentRequestFolder.getDynamicPages();
                    if (dynamicPages != null && !dynamicPages.isEmpty()) {
                        DynamicPage matchingPage = null;
                        DynamicPage inheritableMatchingPage = null;
                        DynamicPage wildcardMatchingPage = null;
                        for (DynamicPage dynamicPage : dynamicPages) {
                            if (dynamicPage.getContentType() == null || dynamicPage.getContentType().equals("*")) {
                                wildcardMatchingPage = dynamicPage;
                                continue;
                            }
                            if (!dynamicPage.getContentType().equals(contentType)) continue;
                            boolean inheritableDynamicPage = dynamicPage.isInheritable();
                            if (matchingContentRequestFolder && !inheritableDynamicPage) {
                                matchingPage = dynamicPage;
                                continue;
                            }
                            if (!inheritableDynamicPage) continue;
                            inheritableMatchingPage = dynamicPage;
                        }
                        if (matchingPage != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Selected " + contentType + " content dynamic page, path=" + view.getManagedDynamicPage(matchingPage).getPath());
                            }
                            return matchingPage;
                        }
                        if (inheritableMatchingPage != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Selected " + contentType + " inheritable content dynamic page, path=" + view.getManagedDynamicPage(inheritableMatchingPage).getPath());
                            }
                            return inheritableMatchingPage;
                        }
                        if (wildcardMatchingPage != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Selected " + contentType + " wildcard content dynamic page, path=" + view.getManagedDynamicPage(wildcardMatchingPage).getPath());
                            }
                            return wildcardMatchingPage;
                        }
                    }
                }
                catch (NodeException ne) {
                    break;
                }
                catch (SecurityException se) {
                    accessException = se;
                }
                contentRequestFolder = (Folder)contentRequestFolder.getParent();
                matchingContentRequestFolder = false;
            }
        }
        if (accessException != null) {
            throw accessException;
        }
        throw new NodeNotFoundException("No dynamic page matched " + requestPath + " request in site view.");
    }

    public Folder getRequestRootFolder(String requestUserPrincipal) throws NodeNotFoundException {
        return this.getRequestRootFolder(null, requestUserPrincipal, false);
    }

    public Folder getRequestRootFolder(Map requestProfileLocators, String requestUserPrincipal, boolean requestForceReservedVisible) throws NodeNotFoundException {
        AbstractSiteView view;
        if (this.updateSessionProfileLocators(requestProfileLocators, requestUserPrincipal, requestForceReservedVisible) && (view = this.getSiteView()) != null) {
            return view.getRootFolderView();
        }
        throw new NodeNotFoundException("No root folder available in site view.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSessionProfileLocators(Map requestProfileLocators, String requestUserPrincipal, boolean requestForceReservedVisible) {
        if (requestProfileLocators == null || !requestProfileLocators.isEmpty()) {
            boolean userUpdate = false;
            boolean locatorsUpdate = false;
            boolean forceReservedVisibleUpdate = false;
            boolean updated = false;
            PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
            synchronized (portalSiteSessionContextImpl) {
                userUpdate = this.userPrincipal == null && requestUserPrincipal != null || this.userPrincipal != null && !this.userPrincipal.equals(requestUserPrincipal);
                locatorsUpdate = !PortalSiteSessionContextImpl.locatorsEquals(this.profileLocators, requestProfileLocators);
                boolean bl = forceReservedVisibleUpdate = this.forceReservedVisible != requestForceReservedVisible;
                if (this.stale || userUpdate || locatorsUpdate || forceReservedVisibleUpdate) {
                    this.clearSessionProfileLocators();
                    this.profileLocators = requestProfileLocators;
                    this.forceReservedVisible = requestForceReservedVisible;
                    this.userPrincipal = requestUserPrincipal;
                    updated = true;
                }
                this.locatorsLastUpdateCheck = System.currentTimeMillis();
            }
            if (updated && log.isDebugEnabled()) {
                StringBuffer debug = new StringBuffer();
                if (userUpdate) {
                    debug.append("Updated user");
                    if (locatorsUpdate) {
                        debug.append("/locators");
                    }
                    if (forceReservedVisibleUpdate) {
                        debug.append("/force reserved visible");
                    }
                    if (this.stale) {
                        debug.append("/stale");
                    }
                } else if (locatorsUpdate) {
                    debug.append("Updated locators");
                    if (forceReservedVisibleUpdate) {
                        debug.append("/force reserved visible");
                    }
                    if (this.stale) {
                        debug.append("/stale");
                    }
                } else if (forceReservedVisibleUpdate) {
                    debug.append("Updated force reserved visible");
                    if (this.stale) {
                        debug.append("/stale");
                    }
                } else {
                    debug.append("Updated stale");
                }
                debug.append(" context: user=" + requestUserPrincipal + ", profileLocators=(");
                if (requestProfileLocators != null) {
                    boolean firstEntry = true;
                    for (Map.Entry entry : requestProfileLocators.entrySet()) {
                        String locatorName = (String)entry.getKey();
                        ProfileLocator locator = (ProfileLocator)entry.getValue();
                        if (!firstEntry) {
                            debug.append(",");
                        } else {
                            firstEntry = false;
                        }
                        debug.append(locatorName);
                        debug.append("=");
                        debug.append(locator.toString());
                    }
                } else {
                    debug.append("null");
                }
                debug.append(")");
                log.debug(debug.toString());
            }
            return true;
        }
        return false;
    }

    private synchronized void clearSessionProfileLocators() {
        this.profileLocators = null;
        this.userPrincipal = null;
        this.siteView = null;
        this.folderPageHistory = null;
        if (this.menuDefinitionLocatorCache != null) {
            this.menuDefinitionLocatorCache.clear();
        }
        this.stale = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSiteView getSiteView() {
        AbstractSiteView view = this.siteView;
        while (view == null) {
            Map createViewProfileLocators = null;
            String createViewUserPrincipal = null;
            boolean createView = false;
            PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
            synchronized (portalSiteSessionContextImpl) {
                view = this.siteView;
                createView = view == null && this.pageManager != null;
                createViewProfileLocators = this.profileLocators;
                createViewUserPrincipal = this.userPrincipal;
            }
            boolean viewCreated = false;
            if (createView) {
                view = createViewProfileLocators != null ? new SearchPathsSiteView(this.pageManager, createViewProfileLocators, this.forceReservedVisible) : new PhysicalSiteView(this.pageManager, this.userPrincipal);
                PortalSiteSessionContextImpl portalSiteSessionContextImpl2 = this;
                synchronized (portalSiteSessionContextImpl2) {
                    if (this.siteView == null && this.pageManager != null && this.profileLocators == createViewProfileLocators && this.userPrincipal == createViewUserPrincipal) {
                        this.siteView = view;
                        viewCreated = true;
                    }
                    view = this.siteView;
                }
            }
            if (!viewCreated || !log.isDebugEnabled()) continue;
            if (view instanceof SearchPathsSiteView) {
                log.debug("Created search path site view: search paths=" + ((SearchPathsSiteView)view).getSearchPathsString());
                continue;
            }
            if (!(view instanceof PhysicalSiteView)) continue;
            log.debug("Created physical site view");
        }
        return view;
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public PortalSiteContentTypeMapper getContentTypeMapper() {
        return this.contentTypeMapper;
    }

    public boolean isValid() {
        return this.pageManager != null;
    }

    public Map getProfileLocators() {
        return this.profileLocators;
    }

    public Set getStandardMenuNames() {
        AbstractSiteView view = this.getSiteView();
        return view != null ? view.getStandardMenuNames() : null;
    }

    public List getMenuDefinitionLocators(Node node) {
        AbstractSiteView view = this.getSiteView();
        return view != null ? view.getMenuDefinitionLocators(node) : null;
    }

    public SiteViewMenuDefinitionLocator getMenuDefinitionLocator(Node node, String name) {
        AbstractSiteView view = this.getSiteView();
        return view != null ? view.getMenuDefinitionLocator(node, name) : null;
    }

    public BaseFragmentsElement getManagedPageOrTemplate(BaseFragmentsElement pageOrTemplate) {
        AbstractSiteView view = this.getSiteView();
        if (pageOrTemplate instanceof Page) {
            return view != null ? view.getManagedPage((Page)pageOrTemplate) : null;
        }
        if (pageOrTemplate instanceof PageTemplate) {
            return view != null ? view.getManagedPageTemplate((PageTemplate)pageOrTemplate) : null;
        }
        if (pageOrTemplate instanceof DynamicPage) {
            return view != null ? view.getManagedDynamicPage((DynamicPage)pageOrTemplate) : null;
        }
        if (pageOrTemplate instanceof FragmentDefinition) {
            return view != null ? view.getManagedFragmentDefinition((FragmentDefinition)pageOrTemplate) : null;
        }
        return null;
    }

    public PageTemplate getManagedPageTemplate(PageTemplate pageTemplate) {
        AbstractSiteView view = this.getSiteView();
        return view != null ? view.getManagedPageTemplate(pageTemplate) : null;
    }

    public DynamicPage getManagedDynamicPage(DynamicPage dynamicPage) {
        AbstractSiteView view = this.getSiteView();
        return view != null ? view.getManagedDynamicPage(dynamicPage) : null;
    }

    public FragmentDefinition getManagedFragmentDefinition(FragmentDefinition fragmentDefinition) {
        AbstractSiteView view = this.getSiteView();
        return view != null ? view.getManagedFragmentDefinition(fragmentDefinition) : null;
    }

    public String getUserFolderPath(Map requestProfileLocators, String requestUserPrincipal, boolean requestForceReservedVisible) {
        if (this.updateSessionProfileLocators(requestProfileLocators, requestUserPrincipal, this.forceReservedVisible)) {
            AbstractSiteView view = this.getSiteView();
            return view != null ? view.getUserFolderPath() : null;
        }
        return null;
    }

    public String getBaseFolderPath(Map requestProfileLocators, String requestUserPrincipal, boolean requestForceReservedVisible) {
        if (this.updateSessionProfileLocators(requestProfileLocators, requestUserPrincipal, this.forceReservedVisible)) {
            AbstractSiteView view = this.getSiteView();
            return view != null ? view.getBaseFolderPath() : null;
        }
        return null;
    }

    public Map getMenuDefinitionLocatorCache() {
        return this.menuDefinitionLocatorCache;
    }

    public void setMenuDefinitionLocatorCache(Map cache) {
        this.menuDefinitionLocatorCache = cache;
    }

    private static boolean locatorsEquals(Map locators0, Map locators1) {
        if (locators0 == locators1) {
            return true;
        }
        if (locators0 == null || locators1 == null) {
            return false;
        }
        if (locators0.size() != locators1.size()) {
            return false;
        }
        Iterator entriesIter = locators0.entrySet().iterator();
        if (entriesIter.hasNext()) {
            Map.Entry entry = entriesIter.next();
            ProfileLocator locator0 = (ProfileLocator)entry.getValue();
            ProfileLocator locator1 = (ProfileLocator)locators1.get(entry.getKey());
            if (locator1 == null) {
                return false;
            }
            ProfileLocatorProperty[] properties0 = (ProfileLocatorProperty[])locator0.iterator().next();
            ProfileLocatorProperty[] properties1 = (ProfileLocatorProperty[])locator1.iterator().next();
            if (properties0 != null || properties1 != null) {
                if (properties0 == null || properties1 == null || properties0.length != properties1.length) {
                    return false;
                }
                int limit = properties0.length;
                for (int i = 0; i < limit; ++i) {
                    if (!(!properties0[i].getName().equals(properties1[i].getName()) || properties0[i].isControl() && !properties1[i].isControl() || properties0[i].isNavigation() && !properties1[i].isNavigation()) && (!properties0[i].isControl() && !properties0[i].isNavigation() || (properties0[i].getValue() != null || properties1[i].getValue() == null) && (properties0[i].getValue() == null || properties0[i].getValue().equals(properties1[i].getValue())))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static String locatorRequestPath(ProfileLocator locator) {
        return PortalSiteSessionContextImpl.locatorRequestPath(locator, locator.getRequestPath());
    }

    private static String locatorRequestPath(ProfileLocator locator, String requestPath) {
        ProfileLocatorProperty[] properties = (ProfileLocatorProperty[])locator.iterator().next();
        int limit = properties.length;
        for (int i = 0; i < limit; ++i) {
            if (properties[i].isControl() || properties[i].isNavigation() || properties[i].getValue() == null) continue;
            String locatorPath = properties[i].getValue();
            if (locatorPath.startsWith("/")) {
                return locatorPath;
            }
            if (locatorPath.indexOf("/") == -1 && !locatorPath.endsWith(".psml")) {
                locatorPath = locatorPath + ".psml";
            }
            boolean rootFolderRequest = requestPath.equals("/");
            boolean folderRequest = !requestPath.endsWith(".psml");
            int lastSeparatorIndex = requestPath.lastIndexOf(47);
            if (lastSeparatorIndex > 0 && (!folderRequest || requestPath.endsWith("/"))) {
                return requestPath.substring(0, lastSeparatorIndex) + "/" + locatorPath;
            }
            if (!rootFolderRequest && folderRequest) {
                return requestPath + "/" + locatorPath;
            }
            return "/" + locatorPath;
        }
        return requestPath;
    }

    public void newNode(Node node) {
        this.updatedNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatedNode(Node node) {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            this.stale = true;
        }
        if (log.isDebugEnabled()) {
            if (node != null) {
                log.debug("Page manager update event, (node=" + node.getPath() + "): set session context state stale");
            } else {
                log.debug("Page manager update event: set session context state stale");
            }
        }
    }

    public void removedNode(Node node) {
        this.updatedNode(node);
    }

    public synchronized void reapNodes(long interval) {
        if (this.locatorsLastUpdateCheck > 0L && System.currentTimeMillis() - this.locatorsLastUpdateCheck > interval) {
            this.siteView = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDidActivate(HttpSessionEvent event) {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            this.stale = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Session activation event: set session context state stale");
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        this.clearSessionProfileLocators();
        if (log.isDebugEnabled()) {
            log.debug("Session deactivation event: clear session context state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueBound(HttpSessionBindingEvent event) {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            if (!this.subscribed && this.pageManager != null) {
                this.pageManager.addListener((PageManagerEventListener)this);
                this.subscribed = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Session bound event: setup page manager listener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent event) {
        PortalSiteSessionContextImpl portalSiteSessionContextImpl = this;
        synchronized (portalSiteSessionContextImpl) {
            if (this.subscribed && this.pageManager != null) {
                this.pageManager.removeListener((PageManagerEventListener)this);
                this.subscribed = false;
            }
            this.clearSessionProfileLocators();
        }
        if (log.isDebugEnabled()) {
            log.debug("Session unbound event: clear page manager listener and session context state");
        }
    }

    private synchronized Map getFolderPageHistory() {
        if (this.folderPageHistory == null) {
            this.folderPageHistory = new HashMap();
        }
        return this.folderPageHistory;
    }
}

