/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.impl;

import java.util.regex.Matcher;
import org.apache.jetspeed.portalsite.impl.AbstractPatternMapping;

public class RequestPathMapping
extends AbstractPatternMapping {
    private String serverName;
    private String contentType;
    private String mappedPath;

    public RequestPathMapping(String pattern, String mappedPath) {
        this(null, pattern, mappedPath);
    }

    public RequestPathMapping(String contentType, String pattern, String mappedPath) {
        this(null, contentType, pattern, mappedPath);
    }

    public RequestPathMapping(String serverName, String contentType, String pattern, String mappedPath) {
        super(pattern);
        this.serverName = serverName;
        this.contentType = contentType;
        this.mappedPath = mappedPath;
    }

    public String map(String requestServerName, String requestContentType, String requestPath) {
        if (!(this.serverName == null || requestServerName == null || this.serverName.equals(requestServerName) || this.serverName.startsWith(".") && requestServerName.endsWith(this.serverName))) {
            return null;
        }
        if (this.contentType != null && !this.contentType.equals("*") && requestContentType != null && !this.contentType.equals(requestContentType)) {
            return null;
        }
        Matcher patternMatcher = this.getPatternMatcher(requestPath);
        if (patternMatcher.find()) {
            return patternMatcher.replaceAll(this.mappedPath);
        }
        return null;
    }
}

