/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.portalsite.menu.StandardBackMenuDefinition;
import org.apache.jetspeed.portalsite.menu.StandardBreadcrumbsMenuDefinition;
import org.apache.jetspeed.portalsite.menu.StandardNavigationsMenuDefinition;
import org.apache.jetspeed.portalsite.menu.StandardPagesMenuDefinition;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;

public abstract class AbstractSiteView {
    public static final String CURRENT_PAGE_PATH = "~";
    public static final String ALT_CURRENT_PAGE_PATH = "@";
    public static final char ALT_CURRENT_PAGE_PATH_CHAR = '@';
    public static final String ALT_CURRENT_PAGE_PATH_0 = "@0";
    public static final String MENU_DEFINITION_PATH = "+";
    public static final char MENU_DEFINITION_PATH_CHAR = '+';
    public static final String STANDARD_BACK_MENU_NAME = "back";
    public static final String STANDARD_BREADCRUMBS_MENU_NAME = "breadcrumbs";
    public static final String STANDARD_PAGES_MENU_NAME = "pages";
    public static final String STANDARD_NAVIGATIONS_MENU_NAME = "navigations";
    public static final String CUSTOM_PAGE_NAVIGATIONS_MENU_NAME = "page-navigations";
    private static final Set STANDARD_MENU_NAMES = new HashSet(3);
    private static final List STANDARD_MENU_DEFINITION_LOCATORS;
    private PageManager pageManager;
    private Folder rootFolderView;

    public AbstractSiteView(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public PageManager getPageManager() {
        return this.pageManager;
    }

    public Folder getRootFolderView() throws FolderNotFoundException {
        if (this.rootFolderView == null) {
            this.rootFolderView = this.createRootFolderView();
        }
        return this.rootFolderView;
    }

    protected abstract Folder createRootFolderView() throws FolderNotFoundException;

    public Node getNodeView(String path, Node currentNode, String menuPath, boolean onlyConcrete, boolean onlyViewable, boolean onlyVisible) throws NodeNotFoundException {
        String currentPath = path;
        Folder currentFolder = null;
        Page currentPage = null;
        if (currentNode instanceof Page) {
            currentPage = (Page)currentNode;
            currentFolder = (Folder)currentPage.getParent();
        } else if (currentNode instanceof Folder) {
            currentFolder = (Folder)currentNode;
        }
        if (currentPath.equals(CURRENT_PAGE_PATH) || currentPath.equals(ALT_CURRENT_PAGE_PATH)) {
            return currentPage;
        }
        if (currentPath.equals(ALT_CURRENT_PAGE_PATH_0)) {
            return currentNode;
        }
        if (currentNode != null) {
            currentPath = AbstractSiteView.substituteCurrentPathExpressions(currentNode, currentPath);
        }
        if (menuPath != null) {
            currentPath = AbstractSiteView.substituteMenuPathExpressions(menuPath, currentPath);
        }
        if (currentPath.startsWith("/")) {
            currentPath = currentPath.substring(1);
            currentFolder = null;
        }
        if (currentFolder == null) {
            currentFolder = this.getRootFolderView();
        }
        while (currentPath.length() > 0 && !currentPath.equals("/")) {
            int separatorIndex = currentPath.indexOf("/");
            if (separatorIndex != -1) {
                String subfolder = currentPath.substring(0, separatorIndex);
                currentPath = currentPath.substring(separatorIndex + 1);
                if (subfolder.equals("..")) {
                    if (currentFolder.getParent() != null) {
                        currentFolder = (Folder)currentFolder.getParent();
                        continue;
                    }
                    throw new NodeNotFoundException("Specified path " + path + " not found.");
                }
                if (subfolder.equals(".")) continue;
                try {
                    currentFolder = currentFolder.getFolder(subfolder);
                    continue;
                }
                catch (NodeException ne) {
                    NodeNotFoundException nnfe = new NodeNotFoundException("Specified path " + path + " not found.");
                    nnfe.initCause((Throwable)ne);
                    throw nnfe;
                }
                catch (NodeNotFoundException nnfe) {
                    this.checkAccessToNodeNotFound(currentFolder, subfolder);
                    NodeNotFoundException nnfeWrapper = new NodeNotFoundException("Specified path " + path + " not found.");
                    nnfeWrapper.initCause((Throwable)nnfe);
                    throw nnfeWrapper;
                }
            }
            try {
                Node node;
                NodeSet children = currentFolder.getAll();
                if (!(children == null || (node = children.get(currentPath)) == null || onlyConcrete && !AbstractSiteView.isConcreteNode(node) || onlyVisible && !AbstractSiteView.isVisible(node, currentPage) || onlyViewable && !AbstractSiteView.isViewable(node, onlyVisible))) {
                    return node;
                }
            }
            catch (NodeException ne) {
                NodeNotFoundException nnfe = new NodeNotFoundException("Specified path " + path + " not found.");
                nnfe.initCause((Throwable)ne);
                throw nnfe;
            }
            this.checkAccessToNodeNotFound(currentFolder, currentPath);
            throw new NodeNotFoundException("Specified path " + path + " not found or viewable/visible.");
        }
        if (!(onlyVisible && !AbstractSiteView.isVisible((Node)currentFolder, null) || onlyViewable && !AbstractSiteView.isViewable((Node)currentFolder, onlyVisible))) {
            return currentFolder;
        }
        throw new NodeNotFoundException("Specified path " + path + " not found or viewable/visible.");
    }

    protected abstract void checkAccessToNodeNotFound(Folder var1, String var2);

    public List getNodeViews(String regexpPath, Node currentNode, String menuPath, boolean onlyConcrete, boolean onlyViewable, boolean onlyVisible) {
        String currentRegexpPath = regexpPath;
        Folder currentFolder2 = null;
        Page currentPage = null;
        if (currentNode instanceof Page) {
            currentPage = (Page)currentNode;
            currentFolder2 = (Folder)currentPage.getParent();
        } else if (currentNode instanceof Folder) {
            currentFolder2 = (Folder)currentNode;
        }
        if (currentRegexpPath.equals(CURRENT_PAGE_PATH) || currentRegexpPath.equals(ALT_CURRENT_PAGE_PATH)) {
            if (currentPage != null) {
                ArrayList<Page> views = new ArrayList<Page>(1);
                views.add(currentPage);
                return views;
            }
            return null;
        }
        if (currentNode != null) {
            if (currentRegexpPath.equals(ALT_CURRENT_PAGE_PATH_0)) {
                ArrayList<Node> views = new ArrayList<Node>(1);
                views.add(currentNode);
                return views;
            }
            currentRegexpPath = AbstractSiteView.substituteCurrentPathExpressions(currentNode, currentRegexpPath);
        }
        if (menuPath != null) {
            currentRegexpPath = AbstractSiteView.substituteMenuPathExpressions(menuPath, currentRegexpPath);
        }
        if (currentRegexpPath.startsWith("/")) {
            currentRegexpPath = currentRegexpPath.substring(1);
            currentFolder2 = null;
        }
        if (currentFolder2 == null) {
            try {
                currentFolder2 = this.getRootFolderView();
            }
            catch (FolderNotFoundException fnfe) {
                return null;
            }
            catch (SecurityException se) {
                return null;
            }
        }
        while (currentRegexpPath.length() > 0 && !currentRegexpPath.equals("/")) {
            int separatorIndex = currentRegexpPath.indexOf("/");
            if (separatorIndex != -1) {
                String subfolder = currentRegexpPath.substring(0, separatorIndex);
                currentRegexpPath = currentRegexpPath.substring(separatorIndex + 1);
                if (subfolder.equals("..")) {
                    if (currentFolder2.getParent() != null) {
                        currentFolder2 = (Folder)currentFolder2.getParent();
                        continue;
                    }
                    return null;
                }
                if (subfolder.equals(".")) continue;
                try {
                    String subfolderPattern = AbstractSiteView.pathRegexpPattern(subfolder);
                    if (subfolderPattern != null) {
                        NodeSet subfolders = currentFolder2.getFolders();
                        if (subfolders != null) {
                            if ((subfolders = subfolders.inclusiveSubset(subfolderPattern)) != null) {
                                if (subfolders.size() > 1) {
                                    ArrayList views = null;
                                    for (Folder currentFolder2 : subfolders) {
                                        List subfolderViews = this.getNodeViews(currentRegexpPath, (Node)currentFolder2, menuPath, onlyConcrete, onlyViewable, onlyVisible);
                                        if (subfolderViews == null || subfolderViews.isEmpty()) continue;
                                        if (views == null) {
                                            views = new ArrayList();
                                        }
                                        views.addAll(subfolderViews);
                                    }
                                    return views;
                                }
                                if (subfolders.size() == 1) {
                                    currentFolder2 = (Folder)subfolders.iterator().next();
                                    continue;
                                }
                                return null;
                            }
                            return null;
                        }
                        return null;
                    }
                    currentFolder2 = currentFolder2.getFolder(subfolder);
                    continue;
                }
                catch (NodeException ne) {
                    return null;
                }
                catch (NodeNotFoundException nnfe) {
                    return null;
                }
                catch (SecurityException se) {
                    return null;
                }
            }
            try {
                NodeSet children = currentFolder2.getAll();
                if (children != null) {
                    String pathPattern = AbstractSiteView.pathRegexpPattern(currentRegexpPath);
                    if (pathPattern != null) {
                        if ((children = children.inclusiveSubset(pathPattern)) != null && !children.isEmpty()) {
                            ArrayList<Node> views = null;
                            for (Node child : children) {
                                if (onlyConcrete && !AbstractSiteView.isConcreteNode(child) || onlyVisible && !AbstractSiteView.isVisible(child, currentPage) || onlyViewable && !AbstractSiteView.isViewable(child, onlyVisible)) continue;
                                if (views == null) {
                                    views = new ArrayList<Node>(children.size());
                                }
                                views.add(child);
                            }
                            return views;
                        }
                    } else {
                        Node child = children.get(currentRegexpPath);
                        if (!(child == null || onlyConcrete && !AbstractSiteView.isConcreteNode(child) || onlyVisible && !AbstractSiteView.isVisible(child, currentPage) || onlyViewable && !AbstractSiteView.isViewable(child, onlyVisible))) {
                            ArrayList<Folder> views = new ArrayList<Folder>(1);
                            views.add(currentFolder2);
                            return views;
                        }
                    }
                }
            }
            catch (NodeException ne) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            return null;
        }
        if (!(onlyVisible && !AbstractSiteView.isVisible((Node)currentFolder2, null) || onlyViewable && !AbstractSiteView.isViewable((Node)currentFolder2, onlyVisible))) {
            ArrayList<Folder> views = new ArrayList<Folder>(1);
            views.add(currentFolder2);
            return views;
        }
        return null;
    }

    private static String substituteCurrentPathExpressions(Node currentNode, String path) {
        String[] currentNodePathElements = null;
        int pathIndex = path.indexOf(64);
        while (pathIndex != -1) {
            if (pathIndex + 1 < path.length()) {
                String currentNodePathElement = null;
                char pathElementIndexChar = path.charAt(pathIndex + 1);
                if (pathElementIndexChar >= '0' && pathElementIndexChar <= '9') {
                    int pathElementIndex = pathElementIndexChar - 48;
                    if (pathElementIndex > 0) {
                        if (currentNodePathElements == null) {
                            currentNodePathElements = currentNode.getPath().split("/");
                        }
                        if (pathElementIndex < currentNodePathElements.length) {
                            currentNodePathElement = currentNodePathElements[pathElementIndex];
                        }
                    } else {
                        currentNodePathElement = currentNode.getPath();
                        if (currentNodePathElement.endsWith("/")) {
                            currentNodePathElement = currentNodePathElement.substring(0, currentNodePathElement.length() - 1);
                        }
                        if (currentNodePathElement.startsWith("/")) {
                            currentNodePathElement = currentNodePathElement.substring(1);
                        }
                    }
                } else if (pathElementIndexChar == '$') {
                    if (currentNodePathElements == null) {
                        currentNodePathElements = currentNode.getPath().split("/");
                    }
                    currentNodePathElement = currentNodePathElements[currentNodePathElements.length - 1];
                }
                if (currentNodePathElement != null) {
                    path = path.substring(0, pathIndex) + currentNodePathElement + path.substring(pathIndex + 2);
                    pathIndex += currentNodePathElement.length() - 1;
                }
            }
            pathIndex = path.indexOf(64, pathIndex + 1);
        }
        return path;
    }

    private static String substituteMenuPathExpressions(String menuPath, String path) {
        String strippedMenuPath = null;
        int pathIndex = path.indexOf(43);
        while (pathIndex != -1) {
            if (strippedMenuPath == null && (strippedMenuPath = menuPath.substring(1)).endsWith("/")) {
                strippedMenuPath = menuPath.substring(0, strippedMenuPath.length() - 1);
            }
            if (strippedMenuPath.length() > 0) {
                if (pathIndex == 0) {
                    path = "/" + strippedMenuPath + path.substring(1);
                    pathIndex = path.indexOf(43, strippedMenuPath.length() + 1);
                    continue;
                }
                path = path.substring(0, pathIndex) + strippedMenuPath + path.substring(pathIndex + 1);
                pathIndex = path.indexOf(43, pathIndex + strippedMenuPath.length());
                continue;
            }
            path = pathIndex > 0 && pathIndex + 1 < path.length() && path.charAt(pathIndex - 1) == '/' && path.charAt(pathIndex + 1) == '/' ? path.substring(0, pathIndex) + path.substring(pathIndex + 2) : path.substring(0, pathIndex) + path.substring(pathIndex + 1);
            pathIndex = path.indexOf(43, pathIndex);
        }
        return path;
    }

    private static String pathRegexpPattern(String regexp) {
        StringBuffer pattern = null;
        int limit = regexp.length();
        block9: for (int i = 0; i < limit; ++i) {
            char regexpChar = regexp.charAt(i);
            switch (regexpChar) {
                case '*': 
                case '.': 
                case '?': 
                case '[': {
                    if (pattern == null) {
                        pattern = new StringBuffer(regexp.length() * 2);
                        pattern.append(regexp.substring(0, i));
                    }
                    switch (regexpChar) {
                        case '*': {
                            pattern.append(".*");
                            break;
                        }
                        case '.': {
                            pattern.append("\\.");
                            break;
                        }
                        case '?': {
                            pattern.append('.');
                            break;
                        }
                        case '[': {
                            pattern.append('[');
                        }
                    }
                    continue block9;
                }
                default: {
                    if (pattern == null) continue block9;
                    pattern.append(regexpChar);
                }
            }
        }
        if (pattern != null) {
            return pattern.toString();
        }
        return null;
    }

    private static boolean isConcreteNode(Node node) {
        return node instanceof Folder || node instanceof Page || node instanceof Link;
    }

    private static boolean isVisible(Node node, Page currentPage) {
        if (node instanceof Page) {
            return !node.isHidden() || node == currentPage;
        }
        if (node instanceof Folder) {
            return !node.isHidden() && !((Folder)node).isReserved();
        }
        if (node instanceof Link) {
            return !node.isHidden();
        }
        return false;
    }

    private static boolean isViewable(Node node, boolean onlyVisible) {
        if (node instanceof Page || node instanceof Link) {
            return true;
        }
        if (node instanceof Folder) {
            try {
                NodeSet children = ((Folder)node).getAll();
                if (children != null) {
                    for (Node child : children) {
                        if (onlyVisible && !AbstractSiteView.isVisible(child, null) || !AbstractSiteView.isViewable(child, onlyVisible)) continue;
                        return true;
                    }
                }
            }
            catch (NodeException ne) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    public Set getStandardMenuNames() {
        return STANDARD_MENU_NAMES;
    }

    public List getStandardMenuDefinitionLocators() {
        return STANDARD_MENU_DEFINITION_LOCATORS;
    }

    public abstract List getMenuDefinitionLocators(Node var1);

    public abstract SiteViewMenuDefinitionLocator getMenuDefinitionLocator(Node var1, String var2);

    public abstract String getProfileLocatorName(Node var1);

    public abstract Page getManagedPage(Page var1);

    public abstract Link getManagedLink(Link var1);

    public abstract Folder getManagedFolder(Folder var1);

    public abstract PageTemplate getManagedPageTemplate(PageTemplate var1);

    public abstract DynamicPage getManagedDynamicPage(DynamicPage var1);

    public abstract FragmentDefinition getManagedFragmentDefinition(FragmentDefinition var1);

    public abstract String getUserFolderPath();

    public abstract String getBaseFolderPath();

    static {
        STANDARD_MENU_NAMES.add(STANDARD_BACK_MENU_NAME);
        STANDARD_MENU_NAMES.add(STANDARD_BREADCRUMBS_MENU_NAME);
        STANDARD_MENU_NAMES.add(STANDARD_PAGES_MENU_NAME);
        STANDARD_MENU_NAMES.add(STANDARD_NAVIGATIONS_MENU_NAME);
        STANDARD_MENU_DEFINITION_LOCATORS = new ArrayList(4);
        STANDARD_MENU_DEFINITION_LOCATORS.add(new SiteViewMenuDefinitionLocator(new StandardBackMenuDefinition()));
        STANDARD_MENU_DEFINITION_LOCATORS.add(new SiteViewMenuDefinitionLocator(new StandardBreadcrumbsMenuDefinition()));
        STANDARD_MENU_DEFINITION_LOCATORS.add(new SiteViewMenuDefinitionLocator(new StandardPagesMenuDefinition()));
        STANDARD_MENU_DEFINITION_LOCATORS.add(new SiteViewMenuDefinitionLocator(new StandardNavigationsMenuDefinition()));
    }
}

