/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.proxy.FolderProxy;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.proxy.DynamicPageProxy;
import org.apache.jetspeed.om.page.proxy.FragmentDefinitionProxy;
import org.apache.jetspeed.om.page.proxy.LinkProxy;
import org.apache.jetspeed.om.page.proxy.PageProxy;
import org.apache.jetspeed.om.page.proxy.PageTemplateProxy;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.jetspeed.page.document.proxy.NodeProxy;
import org.apache.jetspeed.portalsite.view.AbstractSiteView;
import org.apache.jetspeed.portalsite.view.SearchPathsSiteViewProxy;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;
import org.apache.jetspeed.portalsite.view.SiteViewSearchPath;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.ProfileLocatorProperty;

public class SearchPathsSiteView
extends AbstractSiteView {
    private List searchPaths;
    private String searchPathsString;
    private boolean forceReservedVisible;
    private SiteViewSearchPath userSearchPath;
    private SiteViewSearchPath baseSearchPath;

    public SearchPathsSiteView(PageManager pageManager, List searchPaths, boolean forceReservedVisible) {
        super(pageManager);
        if (searchPaths != null && !searchPaths.isEmpty()) {
            SiteViewSearchPath searchPath2;
            this.searchPaths = new ArrayList(searchPaths.size());
            ArrayList<SiteViewSearchPath> allSearchPaths = new ArrayList<SiteViewSearchPath>(searchPaths.size());
            StringBuilder searchPathsStringBuilder = new StringBuilder();
            for (Object pathObject : searchPaths) {
                String path;
                if (!(pathObject instanceof SiteViewSearchPath) && (path = pathObject.toString().trim()).length() > 0) {
                    pathObject = new SiteViewSearchPath("page", path);
                }
                searchPath2 = (SiteViewSearchPath)pathObject;
                allSearchPaths.add(searchPath2);
                if (this.searchPaths.indexOf(searchPath2) != -1) continue;
                try {
                    if (pageManager.getFolder(searchPath2.toString()) == null) continue;
                    this.searchPaths.add(searchPath2);
                    if (searchPathsStringBuilder.length() == 0) {
                        searchPathsStringBuilder.append(searchPath2);
                        continue;
                    }
                    searchPathsStringBuilder.append(',');
                    searchPathsStringBuilder.append(searchPath2);
                }
                catch (NodeException ne) {
                }
                catch (NodeNotFoundException nnfe) {
                }
                catch (SecurityException se) {}
            }
            if (this.searchPaths.isEmpty()) {
                this.searchPaths.add(new SiteViewSearchPath("page"));
                this.searchPathsString = "/";
            } else {
                this.searchPathsString = searchPathsStringBuilder.toString();
            }
            for (SiteViewSearchPath searchPath2 : allSearchPaths) {
                if (!searchPath2.isUserPath()) continue;
                this.userSearchPath = searchPath2;
                break;
            }
            if (allSearchPaths.size() == 1) {
                searchPath2 = (SiteViewSearchPath)allSearchPaths.get(0);
                if (!searchPath2.isPrincipalPath()) {
                    this.baseSearchPath = searchPath2;
                }
            } else {
                ListIterator baseSearchPathsIter = allSearchPaths.listIterator(allSearchPaths.size());
                while (baseSearchPathsIter.hasPrevious()) {
                    SiteViewSearchPath searchPath3 = (SiteViewSearchPath)baseSearchPathsIter.previous();
                    int scanSearchPathsIndex = baseSearchPathsIter.previousIndex();
                    if (scanSearchPathsIndex == -1) {
                        if (!searchPath3.isPrincipalPath()) {
                            this.baseSearchPath = searchPath3;
                        }
                    } else if (!(searchPath3.isPrincipalPath() || this.baseSearchPath != null && searchPath3.getPathDepth() <= this.baseSearchPath.getPathDepth())) {
                        boolean isCommonSearchPath = true;
                        ListIterator scanBaseSearchPathsIter = allSearchPaths.listIterator(scanSearchPathsIndex + 1);
                        while (scanBaseSearchPathsIter.hasPrevious()) {
                            SiteViewSearchPath scanSearchPath = (SiteViewSearchPath)scanBaseSearchPathsIter.previous();
                            if (scanSearchPath.toString().startsWith(searchPath3.toString())) continue;
                            isCommonSearchPath = false;
                            break;
                        }
                        if (isCommonSearchPath) {
                            this.baseSearchPath = searchPath3;
                            continue;
                        }
                    }
                    break;
                }
            }
        } else {
            this.searchPaths = new ArrayList(1);
            this.searchPaths.add(new SiteViewSearchPath("page"));
            this.searchPathsString = "/";
            this.baseSearchPath = (SiteViewSearchPath)this.searchPaths.get(0);
        }
        this.forceReservedVisible = forceReservedVisible;
    }

    public SearchPathsSiteView(PageManager pageManager, String[] searchPaths, boolean forceReservedVisible) {
        this(pageManager, SearchPathsSiteView.makeSearchPathList(searchPaths), forceReservedVisible);
    }

    private static List makeSearchPathList(String[] searchPaths) {
        if (searchPaths != null && searchPaths.length > 0) {
            ArrayList<String> searchPathsList = new ArrayList<String>(searchPaths.length);
            for (int i = 0; i < searchPaths.length; ++i) {
                searchPathsList.add(searchPaths[i]);
            }
            return searchPathsList;
        }
        return null;
    }

    public SearchPathsSiteView(PageManager pageManager, String searchPaths, boolean forceReservedVisible) {
        this(pageManager, SearchPathsSiteView.makeSearchPathList(searchPaths), forceReservedVisible);
    }

    private static List makeSearchPathList(String searchPaths) {
        return searchPaths != null ? SearchPathsSiteView.makeSearchPathList(searchPaths.split(",")) : null;
    }

    public SearchPathsSiteView(PageManager pageManager, ProfileLocator locator, boolean forceReservedVisible) {
        this(pageManager, SearchPathsSiteView.makeSearchPathList(locator), forceReservedVisible);
    }

    private static List makeSearchPathList(ProfileLocator locator) {
        if (locator != null) {
            return SearchPathsSiteView.mergeSearchPathList("page", locator, new ArrayList(8));
        }
        return null;
    }

    public SearchPathsSiteView(PageManager pageManager, Map locators, boolean forceReservedVisible) {
        this(pageManager, SearchPathsSiteView.makeSearchPathList(locators), forceReservedVisible);
    }

    private static List makeSearchPathList(Map locators) {
        if (locators != null && !locators.isEmpty()) {
            ArrayList searchPaths = new ArrayList(8 * locators.size());
            ProfileLocator pageLocator = (ProfileLocator)locators.get("page");
            if (pageLocator != null) {
                SearchPathsSiteView.mergeSearchPathList("page", pageLocator, searchPaths);
            }
            if (pageLocator == null || locators.size() > 1) {
                for (String locatorName : locators.keySet()) {
                    if (locatorName.equals("page")) continue;
                    SearchPathsSiteView.mergeSearchPathList(locatorName, (ProfileLocator)locators.get(locatorName), searchPaths);
                }
            }
            return searchPaths;
        }
        return null;
    }

    private static List mergeSearchPathList(String locatorName, ProfileLocator locator, List searchPaths) {
        ArrayList locatorSearchPaths = new ArrayList(8);
        int addLocatorSearchPathsAt = 0;
        Iterator locatorIter = locator.iterator();
        while (locatorIter.hasNext()) {
            String pathRoot = "/";
            ArrayList<PathStringBuilder> paths = new ArrayList<PathStringBuilder>(8);
            paths.add(new PathStringBuilder(pathRoot));
            int pathDepth = 0;
            int lastPathsCount = 0;
            String lastPropertyName = null;
            int lastPropertyValueLength = 0;
            boolean navigatedPathRoot = false;
            int skipProfileLocatorIterations = -1;
            ProfileLocatorProperty[] properties = (ProfileLocatorProperty[])locatorIter.next();
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].isNavigation()) {
                    if (properties[i].getValue() != null) {
                        pathRoot = properties[i].getValue();
                        int pathRootDepth = 0;
                        if (!pathRoot.startsWith("/")) {
                            pathRoot = "/" + pathRoot;
                        }
                        if (!pathRoot.endsWith("/")) {
                            pathRoot = pathRoot + "/";
                        }
                        if (!pathRoot.equals("/")) {
                            int folderIndex = 1;
                            do {
                                if (!pathRoot.regionMatches(folderIndex, "__", 0, "__".length())) {
                                    pathRoot = pathRoot.substring(0, folderIndex) + "__" + pathRoot.substring(folderIndex);
                                }
                                ++pathRootDepth;
                            } while ((folderIndex = pathRoot.indexOf("/", folderIndex) + 1) != -1 && folderIndex != pathRoot.length());
                        }
                        PathStringBuilder path = new PathStringBuilder(pathRoot);
                        path.setPathDepth(pathRootDepth);
                        pathDepth = 0;
                        paths.clear();
                        paths.add(path);
                        lastPathsCount = 0;
                        lastPropertyName = null;
                        lastPropertyValueLength = 0;
                        navigatedPathRoot = true;
                        skipProfileLocatorIterations = 0;
                        continue;
                    }
                    ++skipProfileLocatorIterations;
                    continue;
                }
                if (properties[i].isControl()) {
                    if (properties[i].getValue() != null) {
                        boolean principalPath;
                        String propertyName = properties[i].getName().toLowerCase();
                        String propertyValue = properties[i].getValue();
                        String prefixedPropertyName = "_" + propertyName;
                        boolean userPath = prefixedPropertyName.equals("_user");
                        boolean rolePath = !userPath && prefixedPropertyName.equals("_role");
                        boolean groupPath = !userPath && !rolePath && prefixedPropertyName.equals("_group");
                        boolean bl = principalPath = userPath || rolePath || groupPath;
                        if (propertyName.equals(lastPropertyName)) {
                            ArrayList<PathStringBuilder> multipleValuePaths = new ArrayList<PathStringBuilder>(lastPathsCount);
                            Iterator pathsIter = paths.iterator();
                            for (int count = 0; pathsIter.hasNext() && count < lastPathsCount; ++count) {
                                PathStringBuilder path = (PathStringBuilder)pathsIter.next();
                                PathStringBuilder multipleValuePath = new PathStringBuilder(path.toString());
                                multipleValuePath.setLength(multipleValuePath.length() - lastPropertyValueLength - 1);
                                multipleValuePath.append(propertyValue);
                                multipleValuePath.append('/');
                                multipleValuePath.setUserPath(userPath);
                                multipleValuePath.setPrincipalPath(path.isPrincipalPath() || principalPath);
                                multipleValuePath.setPathDepth(path.getPathDepth() + 1);
                                multipleValuePaths.add(multipleValuePath);
                            }
                            paths.addAll(multipleValuePaths);
                            ++skipProfileLocatorIterations;
                            continue;
                        }
                        for (PathStringBuilder path : paths) {
                            path.append("_");
                            path.append(propertyName);
                            path.append('/');
                            path.append(propertyValue);
                            path.append('/');
                            path.setUserPath(userPath);
                            path.setPrincipalPath(path.isPrincipalPath() || principalPath);
                            path.setPathDepth(path.getPathDepth() + 1);
                        }
                        ++pathDepth;
                        lastPathsCount = paths.size();
                        lastPropertyValueLength = propertyValue.length();
                        lastPropertyName = propertyName;
                        skipProfileLocatorIterations = 0;
                        continue;
                    }
                    ++skipProfileLocatorIterations;
                    continue;
                }
                ++skipProfileLocatorIterations;
            }
            for (int skip = skipProfileLocatorIterations; skip > 0 && locatorIter.hasNext(); --skip) {
                locatorIter.next();
            }
            if (pathDepth > 0 || navigatedPathRoot) {
                locatorSearchPaths.addAll(addLocatorSearchPathsAt, paths);
                addLocatorSearchPathsAt += paths.size();
            }
            if (pathDepth == 1 && !navigatedPathRoot) {
                locatorSearchPaths.add(addLocatorSearchPathsAt++, new PathStringBuilder(pathRoot));
            }
            if (pathDepth == 0 && navigatedPathRoot) {
                addLocatorSearchPathsAt = 0;
            }
            if ((pathDepth > 1 || navigatedPathRoot) && locatorIter.hasNext()) continue;
            for (PathStringBuilder searchPathBuilder : locatorSearchPaths) {
                SiteViewSearchPath searchPath = new SiteViewSearchPath(locatorName, searchPathBuilder.toString(), searchPathBuilder.isUserPath(), searchPathBuilder.isPrincipalPath(), searchPathBuilder.getPathDepth());
                int existsAt = searchPaths.indexOf(searchPath);
                if (existsAt != -1) {
                    if (existsAt >= searchPaths.size() - 1) continue;
                    searchPaths.add(searchPaths.remove(existsAt));
                    continue;
                }
                searchPaths.add(searchPath);
            }
            locatorSearchPaths.clear();
            addLocatorSearchPathsAt = 0;
        }
        return searchPaths;
    }

    public SearchPathsSiteView(PageManager pageManager) {
        this(pageManager, (List)null, false);
    }

    public List getSearchPaths() {
        return this.searchPaths;
    }

    public String getSearchPathsString() {
        return this.searchPathsString;
    }

    protected Folder createRootFolderView() throws FolderNotFoundException {
        try {
            SiteViewSearchPath searchPath = (SiteViewSearchPath)this.searchPaths.get(0);
            String path = searchPath.toString();
            String locatorName = searchPath.getLocatorName();
            Folder rootFolder = this.getPageManager().getFolder(path);
            return FolderProxy.newInstance(this, locatorName, null, rootFolder, this.forceReservedVisible);
        }
        catch (NodeException ne) {
            FolderNotFoundException fnfe = new FolderNotFoundException("Root folder not found");
            fnfe.initCause((Throwable)ne);
            throw fnfe;
        }
        catch (NodeNotFoundException nnfe) {
            FolderNotFoundException fnfe = new FolderNotFoundException("Root folder not found");
            fnfe.initCause((Throwable)nnfe);
            throw fnfe;
        }
    }

    protected void checkAccessToNodeNotFound(Folder folder, String folderName) {
        FolderProxy.getFolderProxy(folder).checkAccessToNodeNotFound(folderName);
    }

    public List getMenuDefinitionLocators(Node node) {
        NodeProxy nodeProxy = NodeProxy.getNodeProxy(node);
        if (nodeProxy != null) {
            return nodeProxy.getMenuDefinitionLocators();
        }
        return null;
    }

    public SiteViewMenuDefinitionLocator getMenuDefinitionLocator(Node node, String name) {
        NodeProxy nodeProxy = NodeProxy.getNodeProxy(node);
        if (nodeProxy != null) {
            return nodeProxy.getMenuDefinitionLocator(name);
        }
        return null;
    }

    public String getProfileLocatorName(Node node) {
        SearchPathsSiteViewProxy siteViewProxy = SearchPathsSiteViewProxy.getSiteViewProxy(node);
        if (siteViewProxy != null) {
            return siteViewProxy.getLocatorName();
        }
        return null;
    }

    public Page getManagedPage(Page page) {
        PageProxy pageProxy = (PageProxy)NodeProxy.getNodeProxy(page);
        return pageProxy != null ? pageProxy.getPage() : null;
    }

    public Link getManagedLink(Link link) {
        LinkProxy linkProxy = (LinkProxy)NodeProxy.getNodeProxy(link);
        return linkProxy != null ? linkProxy.getLink() : null;
    }

    public Folder getManagedFolder(Folder folder) {
        FolderProxy folderProxy = (FolderProxy)NodeProxy.getNodeProxy(folder);
        return folderProxy != null ? folderProxy.getDefaultFolder() : null;
    }

    public PageTemplate getManagedPageTemplate(PageTemplate pageTemplate) {
        PageTemplateProxy pageTemplateProxy = (PageTemplateProxy)NodeProxy.getNodeProxy(pageTemplate);
        return pageTemplateProxy != null ? pageTemplateProxy.getPageTemplate() : null;
    }

    public DynamicPage getManagedDynamicPage(DynamicPage dynamicPage) {
        DynamicPageProxy dynamicPageProxy = (DynamicPageProxy)NodeProxy.getNodeProxy(dynamicPage);
        return dynamicPageProxy != null ? dynamicPageProxy.getDynamicPage() : null;
    }

    public FragmentDefinition getManagedFragmentDefinition(FragmentDefinition fragmentDefinition) {
        FragmentDefinitionProxy fragmentDefinitionProxy = (FragmentDefinitionProxy)NodeProxy.getNodeProxy(fragmentDefinition);
        return fragmentDefinitionProxy != null ? fragmentDefinitionProxy.getFragmentDefinition() : null;
    }

    public String getUserFolderPath() {
        return this.userSearchPath != null ? this.userSearchPath.toString() : null;
    }

    public String getBaseFolderPath() {
        return this.baseSearchPath != null ? this.baseSearchPath.toString() : null;
    }

    private static class PathStringBuilder {
        private StringBuilder stringBuilder;
        private boolean userPath;
        private boolean principalPath;
        private int pathDepth;

        public PathStringBuilder() {
            this.stringBuilder = new StringBuilder();
        }

        public PathStringBuilder(String s) {
            this.stringBuilder = new StringBuilder(s);
        }

        public PathStringBuilder append(String s) {
            this.stringBuilder.append(s);
            return this;
        }

        public PathStringBuilder append(char c) {
            this.stringBuilder.append(c);
            return this;
        }

        public int length() {
            return this.stringBuilder.length();
        }

        public void setLength(int length) {
            this.stringBuilder.setLength(length);
        }

        public String toString() {
            return this.stringBuilder.toString();
        }

        public boolean isUserPath() {
            return this.userPath;
        }

        public void setUserPath(boolean userPath) {
            this.userPath = userPath;
        }

        public boolean isPrincipalPath() {
            return this.principalPath;
        }

        public void setPrincipalPath(boolean principalPath) {
            this.principalPath = principalPath;
        }

        public int getPathDepth() {
            return this.pathDepth;
        }

        public void setPathDepth(int pathDepth) {
            this.pathDepth = pathDepth;
        }
    }
}

