/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.view;

public class SiteViewSearchPath {
    private static final String USER_PATH_PATTERN = ".*/_user/[^/]+";
    private String locatorName;
    private String searchPath;
    private boolean userPath;
    private boolean principalPath;
    private int pathDepth;

    public SiteViewSearchPath(String locatorName) {
        this(locatorName, "/", false, false, 0);
    }

    public SiteViewSearchPath(String locatorName, String searchPath) {
        this(locatorName, searchPath, searchPath.matches(USER_PATH_PATTERN), SiteViewSearchPath.principalSearchPath(searchPath), SiteViewSearchPath.searchPathDepth(searchPath));
    }

    private static int searchPathDepth(String searchPath) {
        int depth = 0;
        int length = searchPath.length();
        int prefixLength = "_".length();
        int index = searchPath.indexOf(47);
        while (index != -1) {
            if (searchPath.regionMatches(index + 1, "_", 0, prefixLength)) {
                ++depth;
            }
            index = searchPath.indexOf(47, index + 1);
        }
        return depth;
    }

    private static boolean principalSearchPath(String searchPath) {
        return searchPath.contains("/_user/") || searchPath.contains("/_role/") || searchPath.contains("/_group/");
    }

    public SiteViewSearchPath(String locatorName, String searchPath, boolean userPath, boolean principalPath, int pathDepth) {
        this.locatorName = locatorName;
        this.searchPath = searchPath.endsWith("/") && !searchPath.equals("/") ? searchPath.substring(0, searchPath.length() - 1) : searchPath;
        this.userPath = userPath;
        this.principalPath = principalPath;
        this.pathDepth = pathDepth;
    }

    public String toString() {
        return this.searchPath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.searchPath.equals(obj);
        }
        return this.searchPath.equals(obj.toString());
    }

    public int hashCode() {
        return this.searchPath.hashCode();
    }

    public String getLocatorName() {
        return this.locatorName;
    }

    public boolean isUserPath() {
        return this.userPath;
    }

    public boolean isPrincipalPath() {
        return this.principalPath;
    }

    public int getPathDepth() {
        return this.pathDepth;
    }
}

