/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portalsite.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.portalsite.view.SiteViewMenuDefinitionLocator;

public class SiteViewUtils {
    public static List mergeMenuDefinitionLocators(List definitions, Node definitionNode, String path, boolean override, List menuDefinitionLocators) {
        if (definitions != null) {
            for (MenuDefinition definition : definitions) {
                String definitionName = definition.getName();
                if (definitionName == null) continue;
                if (!SiteViewUtils.menuDefinitionLocatorsContains(menuDefinitionLocators, definitionName)) {
                    if (menuDefinitionLocators == null) {
                        menuDefinitionLocators = Collections.synchronizedList(new ArrayList(definitions.size() * 2));
                    }
                    menuDefinitionLocators.add(new SiteViewMenuDefinitionLocator(definition, definitionNode, path, override));
                    continue;
                }
                if (!override) continue;
                throw new RuntimeException("Override menu definitions must be merged/added before others!");
            }
        }
        return menuDefinitionLocators;
    }

    public static List mergeMenuDefinitionLocators(List locators, List menuDefinitionLocators) {
        if (locators != null) {
            for (SiteViewMenuDefinitionLocator locator : locators) {
                String definitionName = locator.getName();
                if (SiteViewUtils.menuDefinitionLocatorsContains(menuDefinitionLocators, definitionName)) continue;
                if (menuDefinitionLocators == null) {
                    menuDefinitionLocators = Collections.synchronizedList(new ArrayList(locators.size() * 2));
                }
                menuDefinitionLocators.add(locator);
            }
        }
        return menuDefinitionLocators;
    }

    public static boolean menuDefinitionLocatorsContains(List menuDefinitionLocators, String name) {
        return SiteViewUtils.findMenuDefinitionLocator(menuDefinitionLocators, name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SiteViewMenuDefinitionLocator findMenuDefinitionLocator(List menuDefinitionLocators, String name) {
        if (menuDefinitionLocators != null && name != null) {
            List list = menuDefinitionLocators;
            synchronized (list) {
                for (SiteViewMenuDefinitionLocator locator : menuDefinitionLocators) {
                    if (!name.equals(locator.getName())) continue;
                    return locator;
                }
            }
        }
        return null;
    }
}

