/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.proxy;

import java.lang.ref.WeakReference;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeException;

public class FolderWeakReference {
    private PageManager pageManager;
    private String path;
    private volatile WeakReference<Folder> referentFolder;

    public FolderWeakReference(PageManager pageManager, Folder folder) {
        this.pageManager = pageManager;
        this.path = folder.getPath();
        this.referentFolder = new WeakReference<Folder>(folder);
    }

    public Folder getFolder() {
        Folder folder = (Folder)this.referentFolder.get();
        if (folder != null && !folder.isStale()) {
            return folder;
        }
        try {
            this.referentFolder = new WeakReference<Folder>(this.pageManager.getFolder(this.path));
            return (Folder)this.referentFolder.get();
        }
        catch (FolderNotFoundException fnfe) {
            throw new RuntimeException("Folder " + this.path + " has been removed: " + (Object)((Object)fnfe), fnfe);
        }
        catch (NodeException ne) {
            throw new RuntimeException("Folder " + this.path + " can not be accessed: " + (Object)((Object)ne), ne);
        }
    }
}

