/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.proxy;

import java.lang.ref.WeakReference;
import org.apache.jetspeed.om.page.DynamicPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.NodeException;

public class DynamicPageWeakReference {
    private PageManager pageManager;
    private String path;
    private volatile WeakReference<DynamicPage> referentDynamicPage;

    public DynamicPageWeakReference(PageManager pageManager, DynamicPage dynamicPage) {
        this.pageManager = pageManager;
        this.path = dynamicPage.getPath();
        this.referentDynamicPage = new WeakReference<DynamicPage>(dynamicPage);
    }

    public DynamicPage getDynamicPage() {
        DynamicPage dynamicPage = (DynamicPage)this.referentDynamicPage.get();
        if (dynamicPage != null && !dynamicPage.isStale()) {
            return dynamicPage;
        }
        try {
            this.referentDynamicPage = new WeakReference<DynamicPage>(this.pageManager.getDynamicPage(this.path));
            return (DynamicPage)this.referentDynamicPage.get();
        }
        catch (PageNotFoundException pnfe) {
            throw new RuntimeException("DynamicPage " + this.path + " has been removed: " + (Object)((Object)pnfe), pnfe);
        }
        catch (NodeException ne) {
            throw new RuntimeException("DynamicPage " + this.path + " can not be accessed: " + (Object)((Object)ne), ne);
        }
    }
}

