/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.proxy;

import java.lang.ref.WeakReference;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.NodeException;

public class FragmentDefinitionWeakReference {
    private PageManager pageManager;
    private String path;
    private volatile WeakReference<FragmentDefinition> referentFragmentDefinition;

    public FragmentDefinitionWeakReference(PageManager pageManager, FragmentDefinition fragmentDefinition) {
        this.pageManager = pageManager;
        this.path = fragmentDefinition.getPath();
        this.referentFragmentDefinition = new WeakReference<FragmentDefinition>(fragmentDefinition);
    }

    public FragmentDefinition getFragmentDefinition() {
        FragmentDefinition fragmentDefinition = (FragmentDefinition)this.referentFragmentDefinition.get();
        if (fragmentDefinition != null && !fragmentDefinition.isStale()) {
            return fragmentDefinition;
        }
        try {
            this.referentFragmentDefinition = new WeakReference<FragmentDefinition>(this.pageManager.getFragmentDefinition(this.path));
            return (FragmentDefinition)this.referentFragmentDefinition.get();
        }
        catch (PageNotFoundException pnfe) {
            throw new RuntimeException("FragmentDefinition " + this.path + " has been removed: " + (Object)((Object)pnfe), pnfe);
        }
        catch (NodeException ne) {
            throw new RuntimeException("FragmentDefinition " + this.path + " can not be accessed: " + (Object)((Object)ne), ne);
        }
    }
}

