/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.proxy;

import java.lang.ref.WeakReference;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.NodeException;

public class LinkWeakReference {
    private PageManager pageManager;
    private String path;
    private volatile WeakReference<Link> referentLink;

    public LinkWeakReference(PageManager pageManager, Link link) {
        this.pageManager = pageManager;
        this.path = link.getPath();
        this.referentLink = new WeakReference<Link>(link);
    }

    public Link getLink() {
        Link link = (Link)this.referentLink.get();
        if (link != null && !link.isStale()) {
            return link;
        }
        try {
            this.referentLink = new WeakReference<Link>(this.pageManager.getLink(this.path));
            return (Link)this.referentLink.get();
        }
        catch (DocumentNotFoundException dnfe) {
            throw new RuntimeException("Link " + this.path + " has been removed: " + (Object)((Object)dnfe), dnfe);
        }
        catch (NodeException ne) {
            throw new RuntimeException("Link " + this.path + " can not be accessed: " + (Object)((Object)ne), ne);
        }
    }
}

