/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.proxy.FolderProxy;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.proxy.PageWeakReference;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.proxy.NodeProxy;
import org.apache.jetspeed.portalsite.view.SearchPathsSiteView;

public class PageProxy
extends NodeProxy
implements InvocationHandler {
    protected static final Method GET_MENU_DEFINITIONS_METHOD = PageProxy.reflectMethod(Page.class, "getMenuDefinitions", null);
    private PageWeakReference pageReference;

    public static Page newInstance(SearchPathsSiteView view, String locatorName, Folder parentFolder, Page page) {
        return (Page)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{Page.class}, (InvocationHandler)new PageProxy(view, locatorName, parentFolder, page));
    }

    private PageProxy(SearchPathsSiteView view, String locatorName, Folder parentFolder, Page page) {
        super(view, locatorName, parentFolder, page.getName(), page.isHidden());
        this.pageReference = new PageWeakReference(view.getPageManager(), page);
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(GET_MENU_DEFINITIONS_METHOD)) {
            return this.getMenuDefinitions();
        }
        if (m.equals(GET_PARENT_METHOD)) {
            return this.getParent();
        }
        if (m.equals(GET_PATH_METHOD)) {
            return this.getPath();
        }
        if (m.equals(GET_URL_METHOD)) {
            return this.getUrl();
        }
        if (m.equals(EQUALS_METHOD)) {
            return new Boolean(this.equals(args[0]));
        }
        if (m.equals(HASH_CODE_METHOD)) {
            return new Integer(this.hashCode());
        }
        if (m.equals(IS_HIDDEN_METHOD)) {
            return new Boolean(this.isHidden());
        }
        if (m.equals(TO_STRING_METHOD)) {
            return this.toString();
        }
        if (m.getName().startsWith("set")) {
            throw new RuntimeException("Page instance is immutable from proxy.");
        }
        try {
            return m.invoke((Object)this.pageReference.getPage(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public Page getPage() {
        return this.pageReference.getPage();
    }

    protected void aggregateMenuDefinitionLocators() {
        FolderProxy parentFolderProxy = FolderProxy.getFolderProxy(this.getParent());
        Page page = this.pageReference.getPage();
        this.mergeMenuDefinitionLocators(page.getMenuDefinitions(), (Node)page, parentFolderProxy.getPath(), true);
        this.mergeMenuDefinitionLocators(parentFolderProxy.getMenuDefinitionLocators());
    }
}

