/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.proxy.FolderProxy;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.proxy.PageTemplateWeakReference;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.proxy.NodeProxy;
import org.apache.jetspeed.portalsite.view.SearchPathsSiteView;

public class PageTemplateProxy
extends NodeProxy
implements InvocationHandler {
    protected static final Method GET_MENU_DEFINITIONS_METHOD = PageTemplateProxy.reflectMethod(PageTemplate.class, "getMenuDefinitions", null);
    private PageTemplateWeakReference pageTemplateReference;

    public static PageTemplate newInstance(SearchPathsSiteView view, String locatorName, Folder parentFolder, PageTemplate pageTemplate) {
        return (PageTemplate)Proxy.newProxyInstance(pageTemplate.getClass().getClassLoader(), new Class[]{PageTemplate.class}, (InvocationHandler)new PageTemplateProxy(view, locatorName, parentFolder, pageTemplate));
    }

    private PageTemplateProxy(SearchPathsSiteView view, String locatorName, Folder parentFolder, PageTemplate pageTemplate) {
        super(view, locatorName, parentFolder, pageTemplate.getName(), false);
        this.pageTemplateReference = new PageTemplateWeakReference(view.getPageManager(), pageTemplate);
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(GET_MENU_DEFINITIONS_METHOD)) {
            return this.getMenuDefinitions();
        }
        if (m.equals(GET_PARENT_METHOD)) {
            return this.getParent();
        }
        if (m.equals(GET_PATH_METHOD)) {
            return this.getPath();
        }
        if (m.equals(GET_URL_METHOD)) {
            return this.getUrl();
        }
        if (m.equals(EQUALS_METHOD)) {
            return new Boolean(this.equals(args[0]));
        }
        if (m.equals(HASH_CODE_METHOD)) {
            return new Integer(this.hashCode());
        }
        if (m.equals(IS_HIDDEN_METHOD)) {
            return new Boolean(this.isHidden());
        }
        if (m.equals(TO_STRING_METHOD)) {
            return this.toString();
        }
        if (m.getName().startsWith("set")) {
            throw new RuntimeException("PageTemplate instance is immutable from proxy.");
        }
        try {
            return m.invoke((Object)this.pageTemplateReference.getPageTemplate(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public PageTemplate getPageTemplate() {
        return this.pageTemplateReference.getPageTemplate();
    }

    protected void aggregateMenuDefinitionLocators() {
        FolderProxy parentFolderProxy = FolderProxy.getFolderProxy(this.getParent());
        PageTemplate pageTemplate = this.pageTemplateReference.getPageTemplate();
        this.mergeMenuDefinitionLocators(pageTemplate.getMenuDefinitions(), (Node)pageTemplate, parentFolderProxy.getPath(), false);
    }
}

